/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import com.google.gson.annotations.Expose;
import com.mapd.parser.extension.ddl.SqlOptionsBuilder;
import java.util.List;
import java.util.Map;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.util.EscapedStringJsonBuilder;

public class SqlAlterTable
extends SqlDdl {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("ALTER_TABLE", SqlKind.OTHER_DDL);
    @Expose
    private AlterType alterType;
    @Expose
    private String tableName;
    @Expose
    private String newTableName;
    @Expose
    private String columnName;
    @Expose
    private String newColumnName;
    @Expose
    private String command;
    @Expose
    private SqlNodeList columnList;
    @Expose
    private Map<String, String> options;

    public SqlAlterTable(SqlParserPos pos, SqlIdentifier name) {
        super(OPERATOR, pos);
        this.tableName = name.toString();
    }

    public SqlAlterTable(SqlParserPos pos, AlterType alterType, String tableName, String newTableName, String columnName, String newColumnName, SqlNodeList columnList, Map<String, String> options) {
        super(OPERATOR, pos);
        this.alterType = alterType;
        this.tableName = tableName;
        this.newTableName = newTableName;
        this.columnName = columnName;
        this.newColumnName = newColumnName;
        this.options = options;
        this.columnList = columnList;
        this.command = OPERATOR.getName();
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER");
        writer.keyword("TABLE");
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        map.put("command", "ALTER_TABLE");
        map.put("tableName", this.tableName.toString());
        switch (this.alterType) {
            case RENAME_TABLE: {
                map.put("alterType", "RENAME_TABLE");
                map.put("newTableName", this.newTableName.toString());
                break;
            }
            case RENAME_COLUMN: {
                map.put("alterType", "RENAME_COLUMN");
                map.put("columnName", this.columnName.toString());
                map.put("newColumnName", this.newColumnName.toString());
                break;
            }
            case ADD_COLUMN: {
                map.put("alterType", "ADD_COLUMN");
                if (this.columnList == null) break;
                List<Object> elements_list = jsonBuilder.list();
                for (SqlNode elementNode : this.columnList) {
                    if (!(elementNode instanceof SqlCall)) {
                        throw new CalciteException("Column definition for table " + this.columnName.toString() + " is invalid: " + elementNode.toString(), null);
                    }
                    elements_list.add(elementNode);
                }
                map.put("columnData", elements_list);
                break;
            }
            case ALTER_COLUMN: {
                map.put("alterType", "ALTER_COLUMN");
                if (this.columnList == null) break;
                List<Object> elements_list = jsonBuilder.list();
                for (SqlNode elementNode : this.columnList) {
                    if (!(elementNode instanceof SqlCall)) {
                        throw new CalciteException("Column definition " + this.tableName.toString() + " is invalid: " + elementNode.toString(), null);
                    }
                    SqlBasicVisitor<Object> sqlVisitor = new SqlBasicVisitor<Object>(){
                        String column_name = "<UNSET>";

                        @Override
                        public Object visit(SqlIdentifier id) {
                            this.column_name = id.toString();
                            return null;
                        }

                        @Override
                        public Object visit(SqlDataTypeSpec spec) {
                            if (!(spec.getTypeNameSpec() instanceof SqlBasicTypeNameSpec)) {
                                throw new CalciteException("Type definition for column " + this.column_name.toString() + " is invalid: " + spec.toString(), null);
                            }
                            return null;
                        }
                    };
                    elementNode.accept(sqlVisitor);
                    elements_list.add(elementNode);
                }
                map.put("alterData", elements_list);
                break;
            }
            case DROP_COLUMN: {
                map.put("alterType", "DROP_COLUMN");
                map.put("columnData", this.columnList.toString());
                break;
            }
            case ALTER_OPTIONS: {
                map.put("alterType", "ALTER_OPTIONS");
                map.put("options", this.options);
            }
        }
        Map<String, Object> payload = jsonBuilder.map();
        payload.put("payload", map);
        return jsonBuilder.toJsonString(payload);
    }

    public static class Builder
    extends SqlOptionsBuilder {
        private SqlParserPos pos;
        private AlterType alterType;
        private String tableName;
        private String newTableName;
        private String columnName;
        private String newColumnName;
        private SqlNodeList columnList;

        public void setPos(SqlParserPos pos) {
            this.pos = pos;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void alterOptions() {
            this.alterType = AlterType.ALTER_OPTIONS;
        }

        public void alterTableName(String newTableName) {
            this.alterType = AlterType.RENAME_TABLE;
            this.newTableName = newTableName;
        }

        public void alterColumnName(String columnName, String newColumnName) {
            this.alterType = AlterType.RENAME_COLUMN;
            this.columnName = columnName;
            this.newColumnName = newColumnName;
        }

        public void addColumnList(SqlNodeList columnList) {
            this.alterType = AlterType.ADD_COLUMN;
            this.columnList = columnList;
        }

        public void addAlterColumnList(SqlNodeList columnList) {
            this.alterType = AlterType.ALTER_COLUMN;
            this.columnList = columnList;
        }

        public void dropColumn(SqlNodeList columnList) {
            this.alterType = AlterType.DROP_COLUMN;
            this.columnList = columnList;
        }

        public SqlAlterTable build() {
            return new SqlAlterTable(this.pos, this.alterType, this.tableName, this.newTableName, this.columnName, this.newColumnName, this.columnList, this.options);
        }
    }

    public static enum AlterType {
        RENAME_TABLE,
        RENAME_COLUMN,
        ADD_COLUMN,
        ALTER_COLUMN,
        DROP_COLUMN,
        ALTER_OPTIONS;

    }
}

