/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import com.mapd.parser.extension.ddl.heavydb.HeavyDBOptionsMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlCreateTable
extends SqlCreate {
    public final boolean temporary;
    public final SqlIdentifier name;
    public final SqlNodeList columnList;
    public SqlNode query = null;
    private final HeavyDBOptionsMap options;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    protected SqlCreateTable(SqlParserPos pos, boolean replace, boolean temporary, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, HeavyDBOptionsMap withOptions, SqlNode query) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.temporary = temporary;
        this.name = Objects.requireNonNull(name);
        this.options = withOptions;
        this.columnList = columnList;
        this.query = query;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.query);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.temporary) {
            writer.keyword("TEMPORARY");
        }
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.query != null) {
            writer.keyword("AS");
            writer.newlineAndIndent();
            this.query.unparse(writer, 0, 0);
        }
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        jsonBuilder.put(map, "command", "CREATE_TABLE");
        jsonBuilder.put(map, "name", this.name.toString());
        if (this.query != null) {
            SqlWriterConfig c = SqlPrettyWriter.config().withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withSelectListItemsOnSeparateLines(false).withWhereListItemsOnSeparateLines(false).withValuesListNewline(false);
            SqlPrettyWriter writer = new SqlPrettyWriter(c);
            this.query.unparse(writer, 0, 0);
            jsonBuilder.put(map, "query", writer.toString());
        }
        List<Object> elements_list = jsonBuilder.list();
        if (this.columnList != null) {
            for (SqlNode elementNode : this.columnList) {
                if (!(elementNode instanceof SqlCall)) {
                    throw new CalciteException("Column definition for table " + this.name.toString() + " is invalid: " + elementNode.toString(), null);
                }
                elements_list.add(elementNode);
            }
        }
        jsonBuilder.put(map, "elements", elements_list);
        jsonBuilder.put(map, "temporary", this.temporary);
        jsonBuilder.put(map, "ifNotExists", this.ifNotExists);
        map.put("options", this.options);
        Map<String, Object> payload = jsonBuilder.map();
        payload.put("payload", map);
        return jsonBuilder.toJsonString(payload);
    }
}

