/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.EscapedStringJsonBuilder;

public class SqlInsertIntoTable
extends SqlDdl {
    public final SqlNode name;
    public final SqlNodeList columnList;
    public SqlNode query = null;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("INSERT_INTO_TABLE_AS_SELECT", SqlKind.OTHER_DDL);

    public SqlInsertIntoTable(SqlParserPos pos, SqlNode table, SqlNode query, SqlNodeList columnList) {
        super(OPERATOR, pos);
        this.name = table;
        this.query = query;
        this.columnList = columnList;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("INSERT");
        writer.keyword("INTO");
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.query != null) {
            writer.newlineAndIndent();
            this.query.unparse(writer, 0, 0);
        }
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        map.put("command", "INSERT_INTO_TABLE_AS_SELECT");
        map.put("name", this.name.toString());
        SqlWriterConfig c = SqlPrettyWriter.config().withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withSelectListItemsOnSeparateLines(false).withWhereListItemsOnSeparateLines(false).withValuesListNewline(false);
        SqlPrettyWriter writer = new SqlPrettyWriter(c);
        this.query.unparse(writer, 0, 0);
        map.put("query", writer.toString());
        if (this.columnList != null) {
            List<Object> col_list = jsonBuilder.list();
            for (SqlNode col : this.columnList) {
                col_list.add(col.toString());
            }
            jsonBuilder.put(map, "columns", col_list);
        }
        Map<String, Object> payload = jsonBuilder.map();
        payload.put("payload", map);
        return jsonBuilder.toJsonString(payload);
    }
}

