/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.JsonBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlInsertValues
extends SqlDdl {
    public final SqlNode name;
    public SqlNode values;
    public final SqlNodeList columnList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("INSERT_INTO_TABLE_AS_SELECT", SqlKind.OTHER_DDL);

    public SqlInsertValues(SqlParserPos pos, SqlNode name, SqlNode values, SqlNodeList columnList) {
        super(OPERATOR, pos);
        this.name = name;
        this.values = values;
        this.columnList = columnList;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.values);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame;
        writer.keyword("INSERT");
        writer.keyword("INTO");
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        writer.keyword("VALUES");
        frame = writer.startList("(", ")");
        this.values.unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        map.put("command", "INSERT_VALUES_INTO_TABLE");
        map.put("name", this.name.toString());
        if (this.columnList != null) {
            List<Object> col_list = jsonBuilder.list();
            for (SqlNode col : this.columnList) {
                col_list.add(col.toString());
            }
            jsonBuilder.put(map, "columns", col_list);
        }
        List<Object> rows = jsonBuilder.list();
        for (SqlNode row_node : ((SqlBasicCall)this.values).getOperands()) {
            rows.add(this.toJson(row_node, (JsonBuilder)jsonBuilder));
        }
        jsonBuilder.put(map, "values", rows);
        Map<String, Object> payload = jsonBuilder.map();
        payload.put("payload", map);
        return jsonBuilder.toJsonString(payload);
    }

    private Object toJson(SqlNode node, JsonBuilder jsonBuilder) {
        if (node instanceof SqlLiteral) {
            return this.toJson((SqlLiteral)node, jsonBuilder);
        }
        if (node instanceof SqlBasicCall) {
            return this.toJson((SqlBasicCall)node, jsonBuilder);
        }
        throw new RuntimeException("Unexpected node in values statement: " + node.toString());
    }

    private Object toJson(SqlLiteral literal, JsonBuilder jsonBuilder) {
        Map<String, @Nullable Object> map = jsonBuilder.map();
        map.put("literal", literal.toValue());
        map.put("type", literal.getTypeName().toString());
        if (literal instanceof SqlNumericLiteral) {
            SqlNumericLiteral numeric = (SqlNumericLiteral)literal;
            map.put("scale", numeric.getScale());
            map.put("precision", numeric.getPrec());
        }
        return map;
    }

    private Object toJson(SqlBasicCall call, JsonBuilder jsonBuilder) {
        if (call.getOperator().kind == SqlKind.ARRAY_VALUE_CONSTRUCTOR) {
            return this.arrayToJson(call, jsonBuilder);
        }
        if (call.getOperator().kind == SqlKind.ROW) {
            return this.rowToJson(call, jsonBuilder);
        }
        throw new RuntimeException("Unexpected sql call: " + call.getOperator().kind.toString());
    }

    private Object rowToJson(SqlBasicCall row, JsonBuilder jsonBuilder) {
        List<Object> values = jsonBuilder.list();
        for (SqlNode operand : row.getOperands()) {
            values.add(this.toJson(operand, jsonBuilder));
        }
        return values;
    }

    private Object arrayToJson(SqlBasicCall array, JsonBuilder jsonBuilder) {
        Map<String, @Nullable Object> map = jsonBuilder.map();
        List<Object> elements = jsonBuilder.list();
        for (SqlNode operand : array.getOperands()) {
            elements.add(this.toJson(operand, jsonBuilder));
        }
        map.put("array", elements);
        return map;
    }
}

