/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlKeyConstraint
extends SqlCall {
    private static final SqlSpecialOperator UNIQUE = new SqlSpecialOperator("UNIQUE", SqlKind.UNIQUE);
    protected static final SqlSpecialOperator PRIMARY = new SqlSpecialOperator("PRIMARY KEY", SqlKind.PRIMARY_KEY);
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private final SqlIdentifier referencesCol;

    SqlKeyConstraint(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        this(pos, name, columnList, null);
    }

    SqlKeyConstraint(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList, SqlIdentifier referencesCol) {
        super(pos);
        this.name = name;
        this.columnList = columnList;
        this.referencesCol = referencesCol;
    }

    public static SqlKeyConstraint unique(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList);
    }

    public static SqlKeyConstraint primary(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList){

            @Override
            public SqlOperator getOperator() {
                return PRIMARY;
            }
        };
    }

    public static SqlKeyConstraint shard(SqlParserPos pos, SqlIdentifier colName) {
        SqlNodeList colList = SqlNodeList.of(colName);
        return new SqlKeyConstraint(pos, new SqlIdentifier("SHARD_KEY", pos), colList);
    }

    public static SqlKeyConstraint sharedDict(SqlParserPos pos, SqlIdentifier colName, SqlIdentifier referencesCol) {
        SqlNodeList colList = SqlNodeList.of(colName);
        return new SqlKeyConstraint(pos, new SqlIdentifier("SHARED_DICT", pos), colList, referencesCol);
    }

    @Override
    public SqlOperator getOperator() {
        return UNIQUE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.name != null) {
            writer.keyword("CONSTRAINT");
            this.name.unparse(writer, 0, 0);
        }
        writer.keyword(this.getOperator().getName());
        this.columnList.unparse(writer, 1, 1);
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        jsonBuilder.put(map, "type", "SQL_COLUMN_CONSTRAINT");
        jsonBuilder.put(map, "name", this.name == null ? null : this.name.toString());
        ArrayList<String> colNamesList = new ArrayList<String>();
        for (int i = 0; i < this.columnList.size(); ++i) {
            SqlNode colNode = this.columnList.get(i);
            colNamesList.add(colNode.toString());
        }
        jsonBuilder.put(map, "columns", colNamesList);
        Map<String, Object> referencesMap = jsonBuilder.map();
        if (this.referencesCol != null) {
            if (this.referencesCol.isSimple()) {
                jsonBuilder.put(referencesMap, "column", this.referencesCol.toString());
            } else {
                jsonBuilder.put(referencesMap, "table", this.referencesCol.getComponent(0).toString());
                jsonBuilder.put(referencesMap, "column", this.referencesCol.getComponent(1).toString());
            }
        }
        jsonBuilder.put(map, "references", referencesMap);
        return jsonBuilder.toJsonString(map);
    }
}

