/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl.heavysql;

import com.google.gson.annotations.Expose;
import com.mapd.parser.extension.ddl.heavysql.HeavySqlArray;
import com.mapd.parser.extension.ddl.heavysql.HeavySqlEncoding;
import com.mapd.parser.extension.ddl.heavysql.HeavySqlJson;
import com.mapd.parser.extension.ddl.heavysql.HeavySqlTypeNameSpec;
import java.util.Objects;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;

public class HeavySqlDataType
extends HeavySqlJson {
    @Expose
    private String type;
    @Expose
    private HeavySqlArray array;
    @Expose
    private Integer precision;
    @Expose
    private Integer scale;
    @Expose
    private boolean notNull;
    @Expose
    private Integer coordinateSystem;
    @Expose
    private HeavySqlEncoding encoding;

    public HeavySqlDataType(SqlDataTypeSpec type, boolean notNull, HeavySqlArray array, HeavySqlEncoding encoding) {
        SqlBasicTypeNameSpec typeNameSpec;
        Objects.requireNonNull(type);
        if (type.getTypeNameSpec() instanceof HeavySqlTypeNameSpec) {
            typeNameSpec = (HeavySqlTypeNameSpec)type.getTypeNameSpec();
            this.type = ((HeavySqlTypeNameSpec)typeNameSpec).getName();
            this.coordinateSystem = ((HeavySqlTypeNameSpec)typeNameSpec).getCoordinate();
        } else {
            this.type = type.getTypeName().toString();
        }
        if (type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec) {
            typeNameSpec = (SqlBasicTypeNameSpec)type.getTypeNameSpec();
            this.precision = typeNameSpec.getPrecision() == -1 ? null : Integer.valueOf(typeNameSpec.getPrecision());
            Integer n = this.scale = typeNameSpec.getScale() == -1 ? null : Integer.valueOf(typeNameSpec.getScale());
        }
        if (array != null) {
            this.array = new HeavySqlArray(this.type, array.getSize());
            this.type = "ARRAY";
        }
        this.notNull = notNull;
        this.encoding = encoding;
    }
}

