/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.server;

import com.mapd.calcite.parser.HeavyDBParser;
import com.mapd.calcite.parser.HeavyDBSqlOperatorTable;
import com.mapd.common.SockTransportProperties;
import com.mapd.parser.server.ExtensionFunction;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ConversionUtil;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CalciteParserFactory
implements PoolableObjectFactory {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(CalciteParserFactory.class);
    private final String dataDir;
    private final Map<String, ExtensionFunction> extSigs;
    private final int dbPort;
    private final SockTransportProperties socket_transport_properties;
    private volatile HeavyDBSqlOperatorTable tableOperator;
    private final Supplier<HeavyDBSqlOperatorTable> tableOperatorSupplier = new Supplier<HeavyDBSqlOperatorTable>(){

        @Override
        public HeavyDBSqlOperatorTable get() {
            return CalciteParserFactory.this.tableOperator;
        }
    };

    public CalciteParserFactory(String dataDir, Map<String, ExtensionFunction> extSigs, int dbPort, SockTransportProperties skT) {
        this.dataDir = dataDir;
        this.extSigs = extSigs;
        this.dbPort = dbPort;
        this.socket_transport_properties = skT;
        this.updateOperatorTable();
    }

    public void updateOperatorTable() {
        HeavyDBSqlOperatorTable tableOperator = new HeavyDBSqlOperatorTable(SqlStdOperatorTable.instance());
        tableOperator.addUDF(this.extSigs);
        this.tableOperator = tableOperator;
    }

    @Override
    public Object makeObject() throws Exception {
        HeavyDBParser obj = new HeavyDBParser(this.dataDir, this.tableOperatorSupplier, this.dbPort, this.socket_transport_properties);
        return obj;
    }

    @Override
    public void destroyObject(Object obj) throws Exception {
    }

    @Override
    public boolean validateObject(Object obj) {
        HeavyDBParser mdp = (HeavyDBParser)obj;
        if (mdp.getCallCount() < 1000) {
            return true;
        }
        HEAVYDBLOGGER.debug(" invalidating object due to max use count");
        return false;
    }

    @Override
    public void activateObject(Object obj) throws Exception {
    }

    @Override
    public void passivateObject(Object obj) throws Exception {
    }

    static {
        System.setProperty("saffron.default.charset", ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.nationalcharset", ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.collation.name", ConversionUtil.NATIVE_UTF16_CHARSET_NAME + "$en_US");
    }
}

