/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.server;

import com.mapd.common.SockTransportProperties;
import com.mapd.parser.server.CalciteServerWrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteServerCaller {
    private SockTransportProperties client_skT = null;
    private SockTransportProperties server_skT = null;
    private static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(CalciteServerCaller.class);
    private CommandLine cmd = null;

    public static void main(String[] args) {
        CalciteServerCaller csc = new CalciteServerCaller();
        csc.doWork(args);
    }

    private void doWork(String[] args) {
        Path extensionFunctionsAstFile;
        String udfName;
        String dataDir;
        int dbPortNum;
        int portNum;
        CalciteServerWrapper calciteServerWrapper;
        block25: {
            calciteServerWrapper = null;
            Options options = new Options();
            Option port = Option.builder("p").hasArg().desc("port number").longOpt("port").build();
            Option ssl_trust_store = Option.builder("T").hasArg().desc("SSL_trust_store").longOpt("trust_store").build();
            Option ssl_trust_passwd = Option.builder("P").hasArg().desc("SSL_trust_password").longOpt("trust_store_pw").build();
            Option ssl_keystore = Option.builder("Y").hasArg().desc("SSL keystore").longOpt("keystore").build();
            Option ssl_keystore_password = Option.builder("Z").hasArg().desc("SSL keystore password").longOpt("keystore_password").build();
            Option dbPort = Option.builder("m").hasArg().desc("HEAVY.AI port number").longOpt("db_port").build();
            Option data = Option.builder("d").hasArg().desc("data directory").required().longOpt("data").build();
            Option extensions = Option.builder("e").hasArg().desc("extension signatures directory").longOpt("extensions").build();
            Option udf_file = Option.builder("u").hasArg().desc("User Defined Functions file path").longOpt("udf").build();
            Option config_file = Option.builder("c").hasArg().desc("Configuration file").longOpt("config").build();
            options.addOption(port);
            options.addOption(data);
            options.addOption(extensions);
            options.addOption(dbPort);
            options.addOption(ssl_trust_store);
            options.addOption(ssl_trust_passwd);
            options.addOption(ssl_keystore);
            options.addOption(ssl_keystore_password);
            options.addOption(udf_file);
            options.addOption(config_file);
            DefaultParser parser = new DefaultParser();
            try {
                this.cmd = parser.parse(options, args);
            }
            catch (ParseException ex) {
                HEAVYDBLOGGER.error(ex.getLocalizedMessage());
                this.help(options);
                System.exit(0);
            }
            portNum = Integer.valueOf(this.cmd.getOptionValue("port", "6279"));
            dbPortNum = Integer.valueOf(this.cmd.getOptionValue("db_port", "6274"));
            dataDir = this.cmd.getOptionValue("data", "data");
            String extensionsDir = this.cmd.getOptionValue("extensions", "build/QueryEngine");
            String trust_store = this.cmd.getOptionValue("trust_store", "");
            String trust_store_pw = this.cmd.getOptionValue("trust_store_pw", "");
            String key_store = this.cmd.getOptionValue("keystore", "");
            String key_store_pw = this.cmd.getOptionValue("keystore_password", "");
            udfName = this.cmd.getOptionValue("udf", "");
            String configuration_file = this.cmd.getOptionValue("config", "");
            extensionFunctionsAstFile = Paths.get(extensionsDir, "ExtensionFunctions.ast");
            Properties p = new Properties();
            try {
                p.load(this.getClass().getResourceAsStream("/log4j2.properties"));
            }
            catch (IOException ex) {
                HEAVYDBLOGGER.error("Could not load log4j property file from resources " + ex.getMessage());
            }
            p.put("log.dir", dataDir);
            try {
                Properties properties = null;
                if (!configuration_file.isEmpty()) {
                    properties = CalciteServerCaller.readPropertyFile(configuration_file);
                }
                if (trust_store == null || trust_store.isEmpty()) {
                    this.client_skT = SockTransportProperties.getUnencryptedClient();
                } else {
                    if (properties != null && trust_store_pw.isEmpty() && (trust_store_pw = properties.getProperty("ssl-trust-password")) == null) {
                        HEAVYDBLOGGER.warn("Failed to load trust store password from config file [" + configuration_file + "] for trust store [" + trust_store + "]");
                    }
                    try {
                        this.client_skT = SockTransportProperties.getEncryptedClientSpecifiedTrustStore(trust_store, trust_store_pw);
                    }
                    catch (Exception eX) {
                        String error = "Loading encrypted client SockTransportProperties failed. Error - " + eX.toString();
                        throw new RuntimeException(error);
                    }
                }
                if (key_store != null && !key_store.isEmpty()) {
                    if (properties != null && key_store_pw.isEmpty() && (key_store_pw = properties.getProperty("ssl-keystore-password")) == null) {
                        String err = "Failed to load key store password from config file [" + configuration_file + "] for key store [" + key_store + "]";
                        throw new RuntimeException(err);
                    }
                    try {
                        this.server_skT = SockTransportProperties.getEncryptedServer(key_store, key_store_pw);
                        break block25;
                    }
                    catch (Exception eX) {
                        String error = "Loading encrypted Server SockTransportProperties failed. Error - " + eX.toString();
                        throw eX;
                    }
                }
                this.server_skT = SockTransportProperties.getUnecryptedServer();
            }
            catch (Exception ex) {
                HEAVYDBLOGGER.error("Error opening SocketTransport. " + ex.getMessage());
                System.exit(0);
            }
        }
        try {
            if (!udfName.isEmpty()) {
                Path path = Paths.get(udfName, new String[0]);
            }
        }
        catch (FileSystemNotFoundException ex1) {
            HEAVYDBLOGGER.error("Could not load udf file " + ex1.getMessage());
        }
        calciteServerWrapper = new CalciteServerWrapper(portNum, dbPortNum, dataDir, extensionFunctionsAstFile.toString(), this.client_skT, this.server_skT, udfName);
        block16: while (true) {
            try {
                while (true) {
                    calciteServerWrapper.run();
                    if (calciteServerWrapper.shutdown()) break block16;
                    try {
                        Thread.sleep(4000L);
                        continue block16;
                    }
                    catch (InterruptedException ex1) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("CalciteServerCaller", options);
    }

    private static Properties readPropertyFile(String fileName) {
        Properties properties = new Properties();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
            StringBuffer sb = new StringBuffer();
            String line = bufferedReader.readLine();
            while (line != null && !line.toLowerCase().equals("[web]")) {
                line = line.replaceAll("[\",']", "");
                sb.append(line + "\n");
                line = bufferedReader.readLine();
            }
            properties.load(new StringReader(sb.toString()));
        }
        catch (IOException iE) {
            HEAVYDBLOGGER.warn("Could not load configuration file [" + fileName + "] to get keystore/truststore password. Error - " + iE.toString());
        }
        return properties;
    }
}

