/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.server;

import ai.heavy.thrift.calciteserver.CalciteServer;
import ai.heavy.thrift.calciteserver.InvalidParseRequest;
import ai.heavy.thrift.calciteserver.TAccessedQueryObjects;
import ai.heavy.thrift.calciteserver.TCompletionHint;
import ai.heavy.thrift.calciteserver.TCompletionHintType;
import ai.heavy.thrift.calciteserver.TExtArgumentType;
import ai.heavy.thrift.calciteserver.TFilterPushDownInfo;
import ai.heavy.thrift.calciteserver.TOptimizationOption;
import ai.heavy.thrift.calciteserver.TPlanResult;
import ai.heavy.thrift.calciteserver.TQueryParsingOption;
import ai.heavy.thrift.calciteserver.TRestriction;
import ai.heavy.thrift.calciteserver.TUserDefinedFunction;
import ai.heavy.thrift.calciteserver.TUserDefinedTableFunction;
import com.google.common.collect.ImmutableList;
import com.mapd.calcite.parser.HeavyDBParser;
import com.mapd.calcite.parser.HeavyDBParserOptions;
import com.mapd.calcite.parser.HeavyDBUser;
import com.mapd.common.SockTransportProperties;
import com.mapd.parser.server.CalciteParserFactory;
import com.mapd.parser.server.ExtensionFunction;
import com.mapd.parser.server.ExtensionFunctionSignatureParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.prepare.HeavyDBPlanner;
import org.apache.calcite.prepare.SqlIdentifierCapturer;
import org.apache.calcite.rel.rules.Restriction;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.thrift.TException;
import org.apache.thrift.server.TServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteServerHandler
implements CalciteServer.Iface {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(CalciteServerHandler.class);
    private TServer server;
    private final int dbPort;
    private volatile long callCount;
    private final GenericObjectPool parserPool;
    private final CalciteParserFactory calciteParserFactory;
    private final String extSigsJson;
    private final String udfSigsJson;
    private String udfRTSigsJson = "";
    Map<String, ExtensionFunction> udfRTSigs = null;
    Map<String, ExtensionFunction> udtfSigs = null;
    private SockTransportProperties skT;
    private Map<String, ExtensionFunction> extSigs = null;
    private String dataDir;

    public CalciteServerHandler(int dbPort, String dataDir, String extensionFunctionsAstFile, SockTransportProperties skT, String udfAstFile) {
        this.dbPort = dbPort;
        this.dataDir = dataDir;
        Map<String, ExtensionFunction> udfSigs = null;
        try {
            this.extSigs = ExtensionFunctionSignatureParser.parse(extensionFunctionsAstFile);
        }
        catch (IOException ex) {
            HEAVYDBLOGGER.error("Could not load extension function signatures: " + ex.getMessage(), ex);
        }
        this.extSigsJson = ExtensionFunctionSignatureParser.signaturesToJson(this.extSigs);
        try {
            if (!udfAstFile.isEmpty()) {
                udfSigs = ExtensionFunctionSignatureParser.parseUdfAst(udfAstFile);
            }
        }
        catch (IOException ex) {
            HEAVYDBLOGGER.error("Could not load udf function signatures: " + ex.getMessage(), ex);
        }
        this.udfSigsJson = ExtensionFunctionSignatureParser.signaturesToJson(udfSigs);
        if (!udfAstFile.isEmpty()) {
            this.extSigs.putAll(udfSigs);
        }
        this.calciteParserFactory = new CalciteParserFactory(dataDir, this.extSigs, dbPort, skT);
        this.parserPool = new GenericObjectPool(this.calciteParserFactory);
    }

    @Override
    public void ping() throws TException {
        HEAVYDBLOGGER.debug("Ping hit");
    }

    @Override
    public TPlanResult process(String user, String session, String catalog, String queryText, TQueryParsingOption queryParsingOption, TOptimizationOption optimizationOption, List<TRestriction> trestrictions) throws InvalidParseRequest, TException {
        String jsonResult;
        HeavyDBParser parser;
        long timer = System.currentTimeMillis();
        ++this.callCount;
        try {
            parser = (HeavyDBParser)this.parserPool.borrowObject();
            parser.clearMemo();
        }
        catch (Exception ex) {
            String msg = "Could not get Parse Item from pool: " + ex.getMessage();
            HEAVYDBLOGGER.error(msg, ex);
            throw new InvalidParseRequest(-1, msg);
        }
        ArrayList<Restriction> rests = null;
        if (trestrictions != null && !trestrictions.isEmpty()) {
            rests = new ArrayList<Restriction>();
            for (TRestriction trestriction : trestrictions) {
                Restriction rest = null;
                rest = new Restriction(trestriction.database, trestriction.table, trestriction.column, trestriction.values);
                rests.add(rest);
            }
        }
        HeavyDBUser dbUser = new HeavyDBUser(user, session, catalog, this.dbPort, rests);
        HEAVYDBLOGGER.debug("process was called User: " + user + " Catalog: " + catalog + " sql: " + queryText);
        parser.setUser(dbUser);
        HeavyDBParser.CURRENT_PARSER.set(parser);
        boolean buildRATreeFromRAString = false;
        if (queryText.startsWith("execute calcite")) {
            queryText = queryText.replaceFirst("execute calcite", "");
            buildRATreeFromRAString = true;
        }
        if ((queryText = queryText.trim()).length() > 0 && queryText.charAt(queryText.length() - 1) == ';') {
            queryText = queryText.substring(0, queryText.length() - 1);
        }
        TAccessedQueryObjects primaryAccessedObjects = new TAccessedQueryObjects();
        TAccessedQueryObjects resolvedAccessedObjects = new TAccessedQueryObjects();
        try {
            ArrayList<HeavyDBParserOptions.FilterPushDownInfo> filterPushDownInfo = new ArrayList<HeavyDBParserOptions.FilterPushDownInfo>();
            for (TFilterPushDownInfo req : optimizationOption.filter_push_down_info) {
                filterPushDownInfo.add(new HeavyDBParserOptions.FilterPushDownInfo(req.input_prev, req.input_start, req.input_next));
            }
            HeavyDBParserOptions parserOptions = new HeavyDBParserOptions(filterPushDownInfo, queryParsingOption.legacy_syntax, queryParsingOption.is_explain, optimizationOption.is_view_optimize, optimizationOption.enable_watchdog, optimizationOption.distributed_mode);
            if (!buildRATreeFromRAString) {
                Pair<String, SqlIdentifierCapturer> res = parser.process(queryText, parserOptions);
                jsonResult = (String)res.left;
                SqlIdentifierCapturer capturer = (SqlIdentifierCapturer)res.right;
                primaryAccessedObjects.tables_selected_from = new ArrayList<ImmutableList<String>>(capturer.selects);
                primaryAccessedObjects.tables_inserted_into = new ArrayList<ImmutableList<String>>(capturer.inserts);
                primaryAccessedObjects.tables_updated_in = new ArrayList<ImmutableList<String>>(capturer.updates);
                primaryAccessedObjects.tables_deleted_from = new ArrayList<ImmutableList<String>>(capturer.deletes);
                resolvedAccessedObjects.tables_selected_from = new ArrayList<ImmutableList<String>>(parser.resolveSelectIdentifiers(capturer));
                resolvedAccessedObjects.tables_inserted_into = new ArrayList<ImmutableList<String>>(capturer.inserts);
                resolvedAccessedObjects.tables_updated_in = new ArrayList<ImmutableList<String>>(capturer.updates);
                resolvedAccessedObjects.tables_deleted_from = new ArrayList<ImmutableList<String>>(capturer.deletes);
            } else {
                jsonResult = parser.buildRATreeAndPerformQueryOptimization(queryText, parserOptions);
            }
        }
        catch (SqlParseException ex) {
            String msg = "SQL Error: " + ex.getMessage();
            HEAVYDBLOGGER.error(msg);
            throw new InvalidParseRequest(-2, msg);
        }
        catch (ValidationException ex) {
            String msg = "SQL Error: " + ex.getMessage();
            if (ex.getCause() != null && ex.getCause().getClass() == CalciteContextException.class) {
                msg = "SQL Error: " + ex.getCause().getMessage();
            }
            HEAVYDBLOGGER.error(msg);
            throw new InvalidParseRequest(-3, msg);
        }
        catch (CalciteContextException ex) {
            String msg = ex.getMessage();
            HEAVYDBLOGGER.error(msg);
            throw new InvalidParseRequest(-6, msg);
        }
        catch (RelConversionException ex) {
            String msg = "Failed to generate relational algebra for query " + ex.getMessage();
            HEAVYDBLOGGER.error(msg, ex);
            throw new InvalidParseRequest(-5, msg);
        }
        catch (Throwable ex) {
            HEAVYDBLOGGER.error(ex.getClass().toString());
            String msg = ex.getMessage();
            HEAVYDBLOGGER.error(msg, ex);
            throw new InvalidParseRequest(-4, msg);
        }
        finally {
            HeavyDBParser.CURRENT_PARSER.set(null);
            try {
                this.parserPool.returnObject(parser);
            }
            catch (Exception ex) {
                String msg = "Could not return parse object: " + ex.getMessage();
                HEAVYDBLOGGER.error(msg, ex);
                throw new InvalidParseRequest(-7, msg);
            }
        }
        TPlanResult result = new TPlanResult();
        result.primary_accessed_objects = primaryAccessedObjects;
        result.resolved_accessed_objects = resolvedAccessedObjects;
        result.plan_result = jsonResult;
        result.execution_time_ms = System.currentTimeMillis() - timer;
        return result;
    }

    @Override
    public void shutdown() throws TException {
        HEAVYDBLOGGER.debug("Shutdown calcite java server");
        this.server.stop();
    }

    @Override
    public String getExtensionFunctionWhitelist() {
        return this.extSigsJson;
    }

    @Override
    public String getUserDefinedFunctionWhitelist() {
        return this.udfSigsJson;
    }

    @Override
    public String getRuntimeExtensionFunctionWhitelist() {
        return this.udfRTSigsJson;
    }

    void setServer(TServer s2) {
        this.server = s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMetadata(String catalog, String table) throws TException {
        HeavyDBParser parser;
        HEAVYDBLOGGER.debug("Received invalidation from server for " + catalog + " : " + table);
        long timer = System.currentTimeMillis();
        ++this.callCount;
        try {
            parser = (HeavyDBParser)this.parserPool.borrowObject();
        }
        catch (Exception ex) {
            String msg = "Could not get Parse Item from pool: " + ex.getMessage();
            HEAVYDBLOGGER.error(msg, ex);
            return;
        }
        HeavyDBParser.CURRENT_PARSER.set(parser);
        try {
            parser.updateMetaData(catalog, table);
        }
        finally {
            HeavyDBParser.CURRENT_PARSER.set(null);
            try {
                HEAVYDBLOGGER.debug("Returning object to pool");
                this.parserPool.returnObject(parser);
            }
            catch (Exception ex) {
                String msg = "Could not return parse object: " + ex.getMessage();
                HEAVYDBLOGGER.error(msg, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TCompletionHint> getCompletionHints(String user, String session, String catalog, List<String> visible_tables, String sql, int cursor) throws TException {
        HeavyDBPlanner.CompletionResult completion_result;
        HeavyDBParser parser;
        ++this.callCount;
        try {
            parser = (HeavyDBParser)this.parserPool.borrowObject();
        }
        catch (Exception ex) {
            String msg = "Could not get Parse Item from pool: " + ex.getMessage();
            HEAVYDBLOGGER.error(msg, ex);
            throw new TException(msg);
        }
        HeavyDBUser dbUser = new HeavyDBUser(user, session, catalog, this.dbPort, null);
        HEAVYDBLOGGER.debug("getCompletionHints was called User: " + user + " Catalog: " + catalog + " sql: " + sql);
        parser.setUser(dbUser);
        HeavyDBParser.CURRENT_PARSER.set(parser);
        try {
            completion_result = parser.getCompletionHints(sql, cursor, visible_tables);
        }
        catch (Exception ex) {
            String msg = "Could not retrieve completion hints: " + ex.getMessage();
            HEAVYDBLOGGER.error(msg, ex);
            ArrayList<TCompletionHint> arrayList = new ArrayList<TCompletionHint>();
            return arrayList;
        }
        finally {
            HeavyDBParser.CURRENT_PARSER.set(null);
            try {
                this.parserPool.returnObject(parser);
            }
            catch (Exception ex) {
                String msg = "Could not return parse object: " + ex.getMessage();
                HEAVYDBLOGGER.error(msg, ex);
                throw new InvalidParseRequest(-4, msg);
            }
        }
        ArrayList<TCompletionHint> result = new ArrayList<TCompletionHint>();
        for (SqlMoniker hint : completion_result.hints) {
            result.add(new TCompletionHint(CalciteServerHandler.hintTypeToThrift(hint.getType()), hint.getFullyQualifiedNames(), completion_result.replaced));
        }
        return result;
    }

    @Override
    public void setRuntimeExtensionFunctions(List<TUserDefinedFunction> udfs, List<TUserDefinedTableFunction> udtfs, boolean isruntime) {
        if (isruntime) {
            if (this.udfRTSigs != null) {
                for (String name : this.udfRTSigs.keySet()) {
                    this.extSigs.remove(name);
                }
                this.udfRTSigsJson = "";
                this.udfRTSigs.clear();
            } else {
                this.udfRTSigs = new HashMap<String, ExtensionFunction>();
            }
            for (TUserDefinedFunction udf : udfs) {
                this.udfRTSigs.put(udf.name, CalciteServerHandler.toExtensionFunction(udf, isruntime));
            }
            for (TUserDefinedTableFunction udtf : udtfs) {
                this.udfRTSigs.put(udtf.name, CalciteServerHandler.toExtensionFunction(udtf, isruntime));
            }
            for (String name : this.udfRTSigs.keySet()) {
                if (!this.extSigs.containsKey(name)) continue;
                HEAVYDBLOGGER.error("Extension function `" + name + "` exists. Skipping runtime extenension function with the same name.");
                this.udfRTSigs.remove(name);
            }
            this.udfRTSigsJson = ExtensionFunctionSignatureParser.signaturesToJson(this.udfRTSigs);
            this.extSigs.putAll(this.udfRTSigs);
        } else {
            if (this.udtfSigs == null) {
                this.udtfSigs = new HashMap<String, ExtensionFunction>();
            }
            for (TUserDefinedTableFunction udtf : udtfs) {
                this.udtfSigs.put(udtf.name, CalciteServerHandler.toExtensionFunction(udtf, isruntime));
            }
            this.extSigs.putAll(this.udtfSigs);
        }
        this.calciteParserFactory.updateOperatorTable();
    }

    private static ExtensionFunction toExtensionFunction(TUserDefinedFunction udf, boolean isruntime) {
        ArrayList<ExtensionFunction.ExtArgumentType> args = new ArrayList<ExtensionFunction.ExtArgumentType>();
        for (TExtArgumentType atype : udf.argTypes) {
            ExtensionFunction.ExtArgumentType arg_type = CalciteServerHandler.toExtArgumentType(atype);
            if (arg_type == ExtensionFunction.ExtArgumentType.Void) continue;
            args.add(arg_type);
        }
        return new ExtensionFunction(args, CalciteServerHandler.toExtArgumentType(udf.retType), udf.annotations);
    }

    private static ExtensionFunction toExtensionFunction(TUserDefinedTableFunction udtf, boolean isruntime) {
        int sqlInputArgIdx = 0;
        int inputArgIdx = 0;
        int outputArgIdx = 0;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ExtensionFunction.ExtArgumentType> args = new ArrayList<ExtensionFunction.ExtArgumentType>();
        HashMap<String, List<ExtensionFunction.ExtArgumentType>> cursor_field_types = new HashMap<String, List<ExtensionFunction.ExtArgumentType>>();
        HashMap default_values = new HashMap();
        for (TExtArgumentType atype : udtf.sqlArgTypes) {
            args.add(CalciteServerHandler.toExtArgumentType(atype));
            Map<String, String> annot = udtf.annotations.get(sqlInputArgIdx);
            String name = annot.getOrDefault("name", "inp" + sqlInputArgIdx);
            if (atype == TExtArgumentType.Cursor) {
                String field_names_annot = annot.getOrDefault("fields", "");
                ArrayList<ExtensionFunction.ExtArgumentType> field_types = new ArrayList<ExtensionFunction.ExtArgumentType>();
                if (field_names_annot.length() > 0) {
                    String[] field_names = field_names_annot.substring(1, field_names_annot.length() - 1).split(",");
                    for (int i = 0; i < field_names.length; ++i) {
                        field_types.add(CalciteServerHandler.toExtArgumentType(udtf.getInputArgTypes().get(inputArgIdx++)));
                    }
                } else if (!isruntime) {
                    field_types.add(CalciteServerHandler.toExtArgumentType(udtf.getInputArgTypes().get(inputArgIdx++)));
                }
                name = name + field_names_annot;
                cursor_field_types.put(name, field_types);
            } else {
                Comparable<?> default_val;
                String default_value_annot = annot.getOrDefault("default", null);
                if (default_value_annot != null && (default_val = CalciteServerHandler.getDefaultValueForAnnot(default_value_annot, atype)) != null) {
                    default_values.put(name, default_val);
                }
                ++inputArgIdx;
            }
            names.add(name);
            ++sqlInputArgIdx;
        }
        ArrayList<ExtensionFunction.ExtArgumentType> outs = new ArrayList<ExtensionFunction.ExtArgumentType>();
        for (TExtArgumentType otype : udtf.outputArgTypes) {
            outs.add(CalciteServerHandler.toExtArgumentType(otype));
            Map<String, String> annot = udtf.annotations.get(sqlInputArgIdx);
            names.add(annot.getOrDefault("name", "out" + outputArgIdx));
            ++sqlInputArgIdx;
            ++outputArgIdx;
        }
        return new ExtensionFunction(args, outs, names, udtf.annotations.get(udtf.annotations.size() - 1), cursor_field_types, default_values);
    }

    private static Comparable<?> getDefaultValueForAnnot(String annot, TExtArgumentType input_type) {
        switch (input_type) {
            case Int8: {
                return new Byte(annot);
            }
            case Int16: {
                return new Short(annot);
            }
            case Int32: {
                return new Integer(annot);
            }
            case Int64: {
                return new Long(annot);
            }
            case Float: {
                return new Float(annot);
            }
            case Double: {
                return new Double(annot);
            }
            case Bool: {
                return new Boolean(annot);
            }
            case TextEncodingNone: {
                return annot;
            }
        }
        HEAVYDBLOGGER.error("Unsupported type in UDTF 'default' annotation: " + input_type.toString());
        return null;
    }

    private static ExtensionFunction.ExtArgumentType toExtArgumentType(TExtArgumentType type) {
        switch (type) {
            case Int8: {
                return ExtensionFunction.ExtArgumentType.Int8;
            }
            case Int16: {
                return ExtensionFunction.ExtArgumentType.Int16;
            }
            case Int32: {
                return ExtensionFunction.ExtArgumentType.Int32;
            }
            case Int64: {
                return ExtensionFunction.ExtArgumentType.Int64;
            }
            case Float: {
                return ExtensionFunction.ExtArgumentType.Float;
            }
            case Double: {
                return ExtensionFunction.ExtArgumentType.Double;
            }
            case Void: {
                return ExtensionFunction.ExtArgumentType.Void;
            }
            case PInt8: {
                return ExtensionFunction.ExtArgumentType.PInt8;
            }
            case PInt16: {
                return ExtensionFunction.ExtArgumentType.PInt16;
            }
            case PInt32: {
                return ExtensionFunction.ExtArgumentType.PInt32;
            }
            case PInt64: {
                return ExtensionFunction.ExtArgumentType.PInt64;
            }
            case PFloat: {
                return ExtensionFunction.ExtArgumentType.PFloat;
            }
            case PDouble: {
                return ExtensionFunction.ExtArgumentType.PDouble;
            }
            case PBool: {
                return ExtensionFunction.ExtArgumentType.PBool;
            }
            case Bool: {
                return ExtensionFunction.ExtArgumentType.Bool;
            }
            case ArrayInt8: {
                return ExtensionFunction.ExtArgumentType.ArrayInt8;
            }
            case ArrayInt16: {
                return ExtensionFunction.ExtArgumentType.ArrayInt16;
            }
            case ArrayInt32: {
                return ExtensionFunction.ExtArgumentType.ArrayInt32;
            }
            case ArrayInt64: {
                return ExtensionFunction.ExtArgumentType.ArrayInt64;
            }
            case ArrayFloat: {
                return ExtensionFunction.ExtArgumentType.ArrayFloat;
            }
            case ArrayDouble: {
                return ExtensionFunction.ExtArgumentType.ArrayDouble;
            }
            case ArrayBool: {
                return ExtensionFunction.ExtArgumentType.ArrayBool;
            }
            case ArrayTextEncodingDict: {
                return ExtensionFunction.ExtArgumentType.ArrayTextEncodingDict;
            }
            case ColumnInt8: {
                return ExtensionFunction.ExtArgumentType.ColumnInt8;
            }
            case ColumnInt16: {
                return ExtensionFunction.ExtArgumentType.ColumnInt16;
            }
            case ColumnInt32: {
                return ExtensionFunction.ExtArgumentType.ColumnInt32;
            }
            case ColumnInt64: {
                return ExtensionFunction.ExtArgumentType.ColumnInt64;
            }
            case ColumnFloat: {
                return ExtensionFunction.ExtArgumentType.ColumnFloat;
            }
            case ColumnDouble: {
                return ExtensionFunction.ExtArgumentType.ColumnDouble;
            }
            case ColumnBool: {
                return ExtensionFunction.ExtArgumentType.ColumnBool;
            }
            case ColumnTextEncodingDict: {
                return ExtensionFunction.ExtArgumentType.ColumnTextEncodingDict;
            }
            case ColumnTimestamp: {
                return ExtensionFunction.ExtArgumentType.ColumnTimestamp;
            }
            case GeoPoint: {
                return ExtensionFunction.ExtArgumentType.GeoPoint;
            }
            case GeoMultiPoint: {
                return ExtensionFunction.ExtArgumentType.GeoMultiPoint;
            }
            case GeoLineString: {
                return ExtensionFunction.ExtArgumentType.GeoLineString;
            }
            case GeoMultiLineString: {
                return ExtensionFunction.ExtArgumentType.GeoMultiLineString;
            }
            case Cursor: {
                return ExtensionFunction.ExtArgumentType.Cursor;
            }
            case GeoPolygon: {
                return ExtensionFunction.ExtArgumentType.GeoPolygon;
            }
            case GeoMultiPolygon: {
                return ExtensionFunction.ExtArgumentType.GeoMultiPolygon;
            }
            case TextEncodingNone: {
                return ExtensionFunction.ExtArgumentType.TextEncodingNone;
            }
            case TextEncodingDict: {
                return ExtensionFunction.ExtArgumentType.TextEncodingDict;
            }
            case Timestamp: {
                return ExtensionFunction.ExtArgumentType.Timestamp;
            }
            case ColumnListInt8: {
                return ExtensionFunction.ExtArgumentType.ColumnListInt8;
            }
            case ColumnListInt16: {
                return ExtensionFunction.ExtArgumentType.ColumnListInt16;
            }
            case ColumnListInt32: {
                return ExtensionFunction.ExtArgumentType.ColumnListInt32;
            }
            case ColumnListInt64: {
                return ExtensionFunction.ExtArgumentType.ColumnListInt64;
            }
            case ColumnListFloat: {
                return ExtensionFunction.ExtArgumentType.ColumnListFloat;
            }
            case ColumnListDouble: {
                return ExtensionFunction.ExtArgumentType.ColumnListDouble;
            }
            case ColumnListBool: {
                return ExtensionFunction.ExtArgumentType.ColumnListBool;
            }
            case ColumnListTextEncodingDict: {
                return ExtensionFunction.ExtArgumentType.ColumnListTextEncodingDict;
            }
            case ColumnArrayInt8: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayInt8;
            }
            case ColumnArrayInt16: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayInt16;
            }
            case ColumnArrayInt32: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayInt32;
            }
            case ColumnArrayInt64: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayInt64;
            }
            case ColumnArrayFloat: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayFloat;
            }
            case ColumnArrayDouble: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayDouble;
            }
            case ColumnArrayBool: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayBool;
            }
            case ColumnArrayTextEncodingDict: {
                return ExtensionFunction.ExtArgumentType.ColumnArrayTextEncodingDict;
            }
            case ColumnListArrayInt8: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayInt8;
            }
            case ColumnListArrayInt16: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayInt16;
            }
            case ColumnListArrayInt32: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayInt32;
            }
            case ColumnListArrayInt64: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayInt64;
            }
            case ColumnListArrayFloat: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayFloat;
            }
            case ColumnListArrayDouble: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayDouble;
            }
            case ColumnListArrayBool: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayBool;
            }
            case ColumnListArrayTextEncodingDict: {
                return ExtensionFunction.ExtArgumentType.ColumnListArrayTextEncodingDict;
            }
            case DayTimeInterval: {
                return ExtensionFunction.ExtArgumentType.DayTimeInterval;
            }
            case YearMonthTimeInterval: {
                return ExtensionFunction.ExtArgumentType.YearMonthTimeInterval;
            }
            case ColumnGeoPoint: {
                return ExtensionFunction.ExtArgumentType.ColumnGeoPoint;
            }
            case ColumnGeoLineString: {
                return ExtensionFunction.ExtArgumentType.ColumnGeoLineString;
            }
            case ColumnGeoPolygon: {
                return ExtensionFunction.ExtArgumentType.ColumnGeoPolygon;
            }
            case ColumnGeoMultiPoint: {
                return ExtensionFunction.ExtArgumentType.ColumnGeoMultiPoint;
            }
            case ColumnGeoMultiLineString: {
                return ExtensionFunction.ExtArgumentType.ColumnGeoMultiLineString;
            }
            case ColumnGeoMultiPolygon: {
                return ExtensionFunction.ExtArgumentType.ColumnGeoMultiPolygon;
            }
            case ColumnListGeoPoint: {
                return ExtensionFunction.ExtArgumentType.ColumnListGeoPoint;
            }
            case ColumnListGeoLineString: {
                return ExtensionFunction.ExtArgumentType.ColumnListGeoLineString;
            }
            case ColumnListGeoPolygon: {
                return ExtensionFunction.ExtArgumentType.ColumnListGeoPolygon;
            }
            case ColumnListGeoMultiPoint: {
                return ExtensionFunction.ExtArgumentType.ColumnListGeoMultiPoint;
            }
            case ColumnListGeoMultiLineString: {
                return ExtensionFunction.ExtArgumentType.ColumnListGeoMultiLineString;
            }
            case ColumnListGeoMultiPolygon: {
                return ExtensionFunction.ExtArgumentType.ColumnListGeoMultiPolygon;
            }
        }
        HEAVYDBLOGGER.error("toExtArgumentType: unknown type " + type);
        return null;
    }

    private static TCompletionHintType hintTypeToThrift(SqlMonikerType type) {
        switch (type) {
            case COLUMN: {
                return TCompletionHintType.COLUMN;
            }
            case TABLE: {
                return TCompletionHintType.TABLE;
            }
            case VIEW: {
                return TCompletionHintType.VIEW;
            }
            case SCHEMA: {
                return TCompletionHintType.SCHEMA;
            }
            case CATALOG: {
                return TCompletionHintType.CATALOG;
            }
            case REPOSITORY: {
                return TCompletionHintType.REPOSITORY;
            }
            case FUNCTION: {
                return TCompletionHintType.FUNCTION;
            }
            case KEYWORD: {
                return TCompletionHintType.KEYWORD;
            }
        }
        return null;
    }
}

