/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.DeriveMode;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;

public class EnumerableMergeJoin
extends Join
implements EnumerableRel {
    protected EnumerableMergeJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traits, ImmutableList.of(), left, right, condition, variablesSet, joinType);
        boolean isDistinct;
        List<RelCollation> leftCollations = left.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE);
        List<RelCollation> rightCollations = right.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE);
        boolean bl = isDistinct = Util.isDistinct(this.joinInfo.leftKeys) && Util.isDistinct(this.joinInfo.rightKeys);
        if (!(RelCollations.containsOrderless(leftCollations, (List<Integer>)this.joinInfo.leftKeys) && RelCollations.containsOrderless(rightCollations, (List<Integer>)this.joinInfo.rightKeys) || !isDistinct)) {
            throw new RuntimeException("wrong collation in left or right input");
        }
        List<RelCollation> collations = traits.getTraits(RelCollationTraitDef.INSTANCE);
        assert (collations != null && collations.size() > 0);
        ImmutableIntList rightKeys = this.joinInfo.rightKeys.incr(left.getRowType().getFieldCount());
        if (!RelCollations.containsOrderless(collations, (List<Integer>)this.joinInfo.leftKeys) && !RelCollations.containsOrderless(collations, (List<Integer>)rightKeys) && isDistinct) {
            throw new RuntimeException("wrong collation for mergejoin");
        }
        if (!EnumerableMergeJoin.isMergeJoinSupported(joinType)) {
            throw new UnsupportedOperationException("EnumerableMergeJoin unsupported for join type " + (Object)((Object)joinType));
        }
    }

    public static boolean isMergeJoinSupported(JoinRelType joinType) {
        return EnumerableDefaults.isMergeJoinSupported(EnumUtils.toLinq4jJoinType(joinType));
    }

    @Deprecated
    EnumerableMergeJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        this(cluster, traits, left, right, condition, variablesSet, joinType);
    }

    @Deprecated
    EnumerableMergeJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, traits, left, right, condition, leftKeys, rightKeys, CorrelationId.setOf(variablesStopped), joinType);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        Object collation = required.getCollation();
        List<Integer> reqKeys = RelCollations.ordinals(collation);
        ImmutableBitSet reqKeySet = ImmutableBitSet.of(reqKeys);
        ImmutableBitSet leftKeySet = ImmutableBitSet.of(this.joinInfo.leftKeys);
        ImmutableBitSet rightKeySet = ImmutableBitSet.of(this.joinInfo.rightKeys).shift(this.left.getRowType().getFieldCount());
        if (reqKeySet.equals(leftKeySet)) {
            Mappings.TargetMapping mapping = this.buildMapping(true);
            RelCollation rightCollation = (RelCollation)collation.apply(mapping);
            return Pair.of(required, ImmutableList.of(required, required.replace(rightCollation)));
        }
        if (reqKeySet.equals(rightKeySet)) {
            RelCollation rightCollation = RelCollations.shift(collation, -this.left.getRowType().getFieldCount());
            Mappings.TargetMapping mapping = this.buildMapping(false);
            RelCollation leftCollation = (RelCollation)rightCollation.apply(mapping);
            return Pair.of(required, ImmutableList.of(required.replace(leftCollation), required.replace(rightCollation)));
        }
        return null;
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        int keyCount = this.joinInfo.leftKeys.size();
        Object collation = childTraits.getCollation();
        int colCount = collation.getFieldCollations().size();
        if (colCount < keyCount || keyCount == 0) {
            return null;
        }
        if (colCount > keyCount) {
            collation = RelCollations.of(collation.getFieldCollations().subList(0, keyCount));
        }
        ImmutableIntList sourceKeys = childId == 0 ? this.joinInfo.leftKeys : this.joinInfo.rightKeys;
        ImmutableBitSet keySet = ImmutableBitSet.of(sourceKeys);
        ImmutableBitSet childCollationKeys = ImmutableBitSet.of(RelCollations.ordinals(collation));
        if (!childCollationKeys.equals(keySet)) {
            return null;
        }
        Mappings.TargetMapping mapping = this.buildMapping(childId == 0);
        RelCollation targetCollation = (RelCollation)collation.apply(mapping);
        if (childId == 0) {
            RelTraitSet joinTraits = this.getTraitSet().replace((RelTrait)collation);
            return Pair.of(joinTraits, ImmutableList.of(childTraits, this.right.getTraitSet().replace(targetCollation)));
        }
        assert (childId == 1);
        RelTraitSet joinTraits = this.getTraitSet().replace(targetCollation);
        return Pair.of(joinTraits, ImmutableList.of(joinTraits, childTraits.replace((RelTrait)collation)));
    }

    @Override
    public DeriveMode getDeriveMode() {
        return DeriveMode.BOTH;
    }

    private Mappings.TargetMapping buildMapping(boolean left2Right) {
        ImmutableIntList sourceKeys = left2Right ? this.joinInfo.leftKeys : this.joinInfo.rightKeys;
        ImmutableIntList targetKeys = left2Right ? this.joinInfo.rightKeys : this.joinInfo.leftKeys;
        HashMap<Integer, Integer> keyMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.joinInfo.leftKeys.size(); ++i) {
            keyMap.put(sourceKeys.get(i), targetKeys.get(i));
        }
        Mappings.TargetMapping mapping = Mappings.target(keyMap, (left2Right ? this.left : this.right).getRowType().getFieldCount(), (left2Right ? this.right : this.left).getRowType().getFieldCount());
        return mapping;
    }

    public static EnumerableMergeJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType) {
        RelOptCluster cluster = right.getCluster();
        RelTraitSet traitSet = cluster.traitSet();
        if (traitSet.isEnabled(RelCollationTraitDef.INSTANCE)) {
            RelMetadataQuery mq = cluster.getMetadataQuery();
            List<RelCollation> collations = RelMdCollation.mergeJoin(mq, left, right, leftKeys, rightKeys, joinType);
            traitSet = traitSet.replace(collations);
        }
        return new EnumerableMergeJoin(cluster, traitSet, left, right, condition, ImmutableSet.of(), joinType);
    }

    @Override
    public EnumerableMergeJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new EnumerableMergeJoin(this.getCluster(), traitSet, left, right, condition, this.variablesSet, joinType);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        double rowCount = mq.getRowCount(this);
        double d = leftRowCount + rightRowCount + rowCount;
        return planner.getCostFactory().makeCost(d, 0.0, 0.0);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        RexNode nonEquiCondition;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        ParameterExpression left_ = Expressions.parameter(leftResult.physType.getJavaRowType(), "left");
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        ParameterExpression right_ = Expressions.parameter(rightResult.physType.getJavaRowType(), "right");
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferArray());
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        for (Pair<Integer, Integer> pair : Pair.zip(this.joinInfo.leftKeys, this.joinInfo.rightKeys)) {
            RelDataType keyType = typeFactory.leastRestrictive(ImmutableList.of(this.left.getRowType().getFieldList().get((Integer)pair.left).getType(), this.right.getRowType().getFieldList().get((Integer)pair.right).getType()));
            Type keyClass = typeFactory.getJavaClass(keyType);
            leftExpressions.add(EnumUtils.convert(leftResult.physType.fieldReference(left_, (Integer)pair.left), keyClass));
            rightExpressions.add(EnumUtils.convert(rightResult.physType.fieldReference(right_, (Integer)pair.right), keyClass));
        }
        Expression predicate = Expressions.constant(null);
        if (!this.joinInfo.nonEquiConditions.isEmpty() && (nonEquiCondition = RexUtil.composeConjunction(this.getCluster().getRexBuilder(), this.joinInfo.nonEquiConditions, true)) != null) {
            predicate = EnumUtils.generatePredicate(implementor, this.getCluster().getRexBuilder(), this.left, this.right, leftResult.physType, rightResult.physType, nonEquiCondition);
        }
        PhysType leftKeyPhysType = leftResult.physType.project(this.joinInfo.leftKeys, JavaRowFormat.LIST);
        PhysType rightKeyPhysType = rightResult.physType.project(this.joinInfo.rightKeys, JavaRowFormat.LIST);
        int keysSize = this.joinInfo.leftKeys.size();
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(keysSize);
        for (int i = 0; i < keysSize; ++i) {
            fieldCollations.add(new RelFieldCollation(i, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST));
        }
        RelCollation collation = RelCollations.of(fieldCollations);
        Expression comparator = leftKeyPhysType.generateComparator(collation);
        return implementor.result(physType, builder.append(Expressions.call(BuiltInMethod.MERGE_JOIN.method, Expressions.list(leftExpression, rightExpression, Expressions.lambda(leftKeyPhysType.record(leftExpressions), left_), Expressions.lambda(rightKeyPhysType.record(rightExpressions), right_), predicate, EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType)), Expressions.constant((Object)EnumUtils.toLinq4jJoinType(this.joinType)), comparator))).toBlock());
    }
}

