/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.AggAddContext;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggResetContext;
import org.apache.calcite.adapter.enumerable.AggResultContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableMatch;
import org.apache.calcite.adapter.enumerable.MatchImplementor;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.StrictAggImplementor;
import org.apache.calcite.adapter.enumerable.StrictWinAggImplementor;
import org.apache.calcite.adapter.enumerable.TableFunctionCallImplementor;
import org.apache.calcite.adapter.enumerable.WinAggAddContext;
import org.apache.calcite.adapter.enumerable.WinAggContext;
import org.apache.calcite.adapter.enumerable.WinAggImplementor;
import org.apache.calcite.adapter.enumerable.WinAggResultContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.OptimizeShuttle;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ImplementableAggFunction;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTypeConstructorFunction;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.fun.SqlJsonArrayAggAggFunction;
import org.apache.calcite.sql.fun.SqlJsonObjectAggAggFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;

public class RexImpTable {
    public static final RexImpTable INSTANCE = new RexImpTable();
    public static final ConstantExpression NULL_EXPR = Expressions.constant(null);
    public static final ConstantExpression FALSE_EXPR = Expressions.constant(false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant(true);
    public static final ConstantExpression COMMA_EXPR = Expressions.constant(",");
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, "FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, "TRUE");
    private final Map<SqlOperator, RexCallImplementor> map = new HashMap<SqlOperator, RexCallImplementor>();
    private final Map<SqlAggFunction, Supplier<? extends AggImplementor>> aggMap = new HashMap<SqlAggFunction, Supplier<? extends AggImplementor>>();
    private final Map<SqlAggFunction, Supplier<? extends WinAggImplementor>> winAggMap = new HashMap<SqlAggFunction, Supplier<? extends WinAggImplementor>>();
    private final Map<SqlMatchFunction, Supplier<? extends MatchImplementor>> matchMap = new HashMap<SqlMatchFunction, Supplier<? extends MatchImplementor>>();
    private final Map<SqlOperator, Supplier<? extends TableFunctionCallImplementor>> tvfImplementorMap = new HashMap<SqlOperator, Supplier<? extends TableFunctionCallImplementor>>();

    RexImpTable() {
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROW, BuiltInMethod.ARRAY.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltInMethod.UPPER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltInMethod.LOWER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltInMethod.INITCAP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TO_BASE64, BuiltInMethod.TO_BASE64.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.FROM_BASE64, BuiltInMethod.FROM_BASE64.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.MD5, BuiltInMethod.MD5.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SHA1, BuiltInMethod.SHA1.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltInMethod.SUBSTRING.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.LEFT, BuiltInMethod.LEFT.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlLibraryOperators.RIGHT, BuiltInMethod.RIGHT.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.REPLACE, BuiltInMethod.REPLACE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TRANSLATE3, BuiltInMethod.TRANSLATE3.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.CHR, "chr", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CONCAT, BuiltInMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION, BuiltInMethod.MULTI_STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT2, BuiltInMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltInMethod.OVERLAY.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltInMethod.POSITION.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ASCII, BuiltInMethod.ASCII.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.REPEAT, BuiltInMethod.REPEAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SPACE, BuiltInMethod.SPACE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.STRCMP, BuiltInMethod.STRCMP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SOUNDEX, BuiltInMethod.SOUNDEX.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.DIFFERENCE, BuiltInMethod.DIFFERENCE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.REVERSE, BuiltInMethod.REVERSE.method, NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.TRIM, new TrimImplementor());
        this.map.put(SqlStdOperatorTable.AND, new LogicalAndImplementor());
        this.map.put(SqlStdOperatorTable.OR, new LogicalOrImplementor());
        this.map.put(SqlStdOperatorTable.NOT, new LogicalNotImplementor());
        this.defineBinary(SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
        this.defineBinary(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
        this.defineBinary(SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
        this.defineBinary(SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
        this.defineBinary(SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
        this.defineBinary(SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
        this.defineBinary(SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
        this.defineBinary(SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineBinary(SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineUnary(SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT, BuiltInMethod.BIG_DECIMAL_NEGATE.getMethodName());
        this.defineUnary(SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT, null);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, "mod", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, "exp", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, "power", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LN, "ln", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOG10, "log10", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, "abs", NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.RAND, new RandImplementor());
        this.map.put(SqlStdOperatorTable.RAND_INTEGER, new RandIntegerImplementor());
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ACOS, "acos", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ASIN, "asin", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN, "atan", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN2, "atan2", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CBRT, "cbrt", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.COS, "cos", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.COSH, "cosh", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.COT, "cot", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.DEGREES, "degrees", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.RADIANS, "radians", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROUND, "sround", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SIGN, "sign", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SIN, "sin", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SINH, "sinh", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.TAN, "tan", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TANH, "tanh", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.TRUNCATE, "struncate", NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.PI, new PiImplementor());
        this.map.put(SqlStdOperatorTable.DATETIME_PLUS, new DatetimeArithmeticImplementor());
        this.map.put(SqlStdOperatorTable.MINUS_DATE, new DatetimeArithmeticImplementor());
        this.map.put(SqlStdOperatorTable.EXTRACT, new ExtractImplementor());
        this.map.put(SqlStdOperatorTable.FLOOR, new FloorImplementor(BuiltInMethod.FLOOR.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_FLOOR.method, BuiltInMethod.UNIX_DATE_FLOOR.method));
        this.map.put(SqlStdOperatorTable.CEIL, new FloorImplementor(BuiltInMethod.CEIL.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_CEIL.method, BuiltInMethod.UNIX_DATE_CEIL.method));
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LAST_DAY, "lastDay", NullPolicy.STRICT);
        this.map.put(SqlLibraryOperators.DAYNAME, new PeriodNameImplementor("dayName", BuiltInMethod.DAYNAME_WITH_TIMESTAMP, BuiltInMethod.DAYNAME_WITH_DATE));
        this.map.put(SqlLibraryOperators.MONTHNAME, new PeriodNameImplementor("monthName", BuiltInMethod.MONTHNAME_WITH_TIMESTAMP, BuiltInMethod.MONTHNAME_WITH_DATE));
        this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_SECONDS, "timestampSeconds", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_MILLIS, "timestampMillis", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_MICROS, "timestampMicros", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_SECONDS, "unixSeconds", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_MILLIS, "unixMillis", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_MICROS, "unixMicros", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.DATE_FROM_UNIX_DATE, "dateFromUnixDate", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_DATE, "unixDate", NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.IS_NULL, new IsNullImplementor());
        this.map.put(SqlStdOperatorTable.IS_NOT_NULL, new IsNotNullImplementor());
        this.map.put(SqlStdOperatorTable.IS_TRUE, new IsTrueImplementor());
        this.map.put(SqlStdOperatorTable.IS_NOT_TRUE, new IsNotTrueImplementor());
        this.map.put(SqlStdOperatorTable.IS_FALSE, new IsFalseImplementor());
        this.map.put(SqlStdOperatorTable.IS_NOT_FALSE, new IsNotFalseImplementor());
        MethodImplementor likeImplementor = new MethodImplementor(BuiltInMethod.LIKE.method, NullPolicy.STRICT, false);
        this.map.put(SqlStdOperatorTable.LIKE, likeImplementor);
        this.map.put(SqlStdOperatorTable.NOT_LIKE, likeImplementor);
        MethodImplementor similarImplementor = new MethodImplementor(BuiltInMethod.SIMILAR.method, NullPolicy.STRICT, false);
        this.map.put(SqlStdOperatorTable.SIMILAR_TO, similarImplementor);
        this.map.put(SqlStdOperatorTable.NOT_SIMILAR_TO, NotImplementor.of(similarImplementor));
        MethodImplementor posixRegexImplementor = new MethodImplementor(BuiltInMethod.POSIX_REGEX.method, NullPolicy.STRICT, false);
        this.map.put(SqlStdOperatorTable.POSIX_REGEX_CASE_INSENSITIVE, posixRegexImplementor);
        this.map.put(SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, posixRegexImplementor);
        this.map.put(SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE, NotImplementor.of(posixRegexImplementor));
        this.map.put(SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE, NotImplementor.of(posixRegexImplementor));
        this.map.put(SqlLibraryOperators.REGEXP_REPLACE, new RegexpReplaceImplementor());
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CARDINALITY, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SLICE, BuiltInMethod.SLICE.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ELEMENT, BuiltInMethod.ELEMENT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.STRUCT_ACCESS, BuiltInMethod.STRUCT_ACCESS.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MEMBER_OF, BuiltInMethod.MEMBER_OF.method, NullPolicy.NONE);
        MethodImplementor isEmptyImplementor = new MethodImplementor(BuiltInMethod.IS_EMPTY.method, NullPolicy.NONE, false);
        this.map.put(SqlStdOperatorTable.IS_EMPTY, isEmptyImplementor);
        this.map.put(SqlStdOperatorTable.IS_NOT_EMPTY, NotImplementor.of(isEmptyImplementor));
        MethodImplementor isASetImplementor = new MethodImplementor(BuiltInMethod.IS_A_SET.method, NullPolicy.NONE, false);
        this.map.put(SqlStdOperatorTable.IS_A_SET, isASetImplementor);
        this.map.put(SqlStdOperatorTable.IS_NOT_A_SET, NotImplementor.of(isASetImplementor));
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT, BuiltInMethod.MULTISET_INTERSECT_DISTINCT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT, BuiltInMethod.MULTISET_INTERSECT_ALL.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT, BuiltInMethod.MULTISET_EXCEPT_DISTINCT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT, BuiltInMethod.MULTISET_EXCEPT_ALL.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_UNION_DISTINCT, BuiltInMethod.MULTISET_UNION_DISTINCT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_UNION, BuiltInMethod.MULTISET_UNION_ALL.method, NullPolicy.NONE);
        MethodImplementor subMultisetImplementor = new MethodImplementor(BuiltInMethod.SUBMULTISET_OF.method, NullPolicy.NONE, false);
        this.map.put(SqlStdOperatorTable.SUBMULTISET_OF, subMultisetImplementor);
        this.map.put(SqlStdOperatorTable.NOT_SUBMULTISET_OF, NotImplementor.of(subMultisetImplementor));
        this.map.put(SqlStdOperatorTable.COALESCE, new CoalesceImplementor());
        this.map.put(SqlStdOperatorTable.CAST, new CastImplementor());
        this.map.put(SqlLibraryOperators.DATE, new CastImplementor());
        this.map.put(SqlStdOperatorTable.REINTERPRET, new ReinterpretImplementor());
        ValueConstructorImplementor value = new ValueConstructorImplementor();
        this.map.put(SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ITEM, new ItemImplementor());
        this.map.put(SqlStdOperatorTable.DEFAULT, new DefaultImplementor());
        this.defineMethod(SqlStdOperatorTable.CURRENT_VALUE, BuiltInMethod.SEQUENCE_CURRENT_VALUE.method, NullPolicy.STRICT);
        this.defineMethod(SqlStdOperatorTable.NEXT_VALUE, BuiltInMethod.SEQUENCE_NEXT_VALUE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.COMPRESS, BuiltInMethod.COMPRESS.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.EXTRACT_VALUE, BuiltInMethod.EXTRACT_VALUE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.XML_TRANSFORM, BuiltInMethod.XML_TRANSFORM.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.EXTRACT_XML, BuiltInMethod.EXTRACT_XML.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.EXISTS_NODE, BuiltInMethod.EXISTS_NODE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_VALUE_EXPRESSION, BuiltInMethod.JSON_VALUE_EXPRESSION.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_EXISTS, BuiltInMethod.JSON_EXISTS.method, NullPolicy.ARG0);
        this.map.put(SqlStdOperatorTable.JSON_VALUE, new JsonValueImplementor(BuiltInMethod.JSON_VALUE.method));
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_QUERY, BuiltInMethod.JSON_QUERY.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_TYPE, BuiltInMethod.JSON_TYPE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_DEPTH, BuiltInMethod.JSON_DEPTH.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_KEYS, BuiltInMethod.JSON_KEYS.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_PRETTY, BuiltInMethod.JSON_PRETTY.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_LENGTH, BuiltInMethod.JSON_LENGTH.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_REMOVE, BuiltInMethod.JSON_REMOVE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_STORAGE_SIZE, BuiltInMethod.JSON_STORAGE_SIZE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, BuiltInMethod.JSON_OBJECT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, BuiltInMethod.JSON_ARRAY.method, NullPolicy.NONE);
        this.aggMap.put(SqlStdOperatorTable.JSON_OBJECTAGG.with(SqlJsonConstructorNullClause.ABSENT_ON_NULL), JsonObjectAggImplementor.supplierFor(BuiltInMethod.JSON_OBJECTAGG_ADD.method));
        this.aggMap.put(SqlStdOperatorTable.JSON_OBJECTAGG.with(SqlJsonConstructorNullClause.NULL_ON_NULL), JsonObjectAggImplementor.supplierFor(BuiltInMethod.JSON_OBJECTAGG_ADD.method));
        this.aggMap.put(SqlStdOperatorTable.JSON_ARRAYAGG.with(SqlJsonConstructorNullClause.ABSENT_ON_NULL), JsonArrayAggImplementor.supplierFor(BuiltInMethod.JSON_ARRAYAGG_ADD.method));
        this.aggMap.put(SqlStdOperatorTable.JSON_ARRAYAGG.with(SqlJsonConstructorNullClause.NULL_ON_NULL), JsonArrayAggImplementor.supplierFor(BuiltInMethod.JSON_ARRAYAGG_ADD.method));
        this.map.put(SqlStdOperatorTable.IS_JSON_VALUE, new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method, NullPolicy.NONE, false));
        this.map.put(SqlStdOperatorTable.IS_JSON_OBJECT, new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method, NullPolicy.NONE, false));
        this.map.put(SqlStdOperatorTable.IS_JSON_ARRAY, new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method, NullPolicy.NONE, false));
        this.map.put(SqlStdOperatorTable.IS_JSON_SCALAR, new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method, NullPolicy.NONE, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_JSON_VALUE, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method, NullPolicy.NONE, false)));
        this.map.put(SqlStdOperatorTable.IS_NOT_JSON_OBJECT, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method, NullPolicy.NONE, false)));
        this.map.put(SqlStdOperatorTable.IS_NOT_JSON_ARRAY, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method, NullPolicy.NONE, false)));
        this.map.put(SqlStdOperatorTable.IS_NOT_JSON_SCALAR, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method, NullPolicy.NONE, false)));
        SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
        this.map.put(SqlStdOperatorTable.USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SESSION_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SYSTEM_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_PATH, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_ROLE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_CATALOG, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
        this.aggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.REGR_COUNT, this.constructorSupplier(CountImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM0, this.constructorSupplier(SumImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM, this.constructorSupplier(SumImplementor.class));
        Supplier<MinMaxImplementor> minMax = this.constructorSupplier(MinMaxImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.MIN, minMax);
        this.aggMap.put(SqlStdOperatorTable.MAX, minMax);
        this.aggMap.put(SqlStdOperatorTable.ANY_VALUE, minMax);
        this.aggMap.put(SqlStdOperatorTable.SOME, minMax);
        this.aggMap.put(SqlStdOperatorTable.EVERY, minMax);
        Supplier<BitOpImplementor> bitop = this.constructorSupplier(BitOpImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.BIT_AND, bitop);
        this.aggMap.put(SqlStdOperatorTable.BIT_OR, bitop);
        this.aggMap.put(SqlStdOperatorTable.BIT_XOR, bitop);
        this.aggMap.put(SqlStdOperatorTable.SINGLE_VALUE, this.constructorSupplier(SingleValueImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.COLLECT, this.constructorSupplier(CollectImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.LISTAGG, this.constructorSupplier(ListaggImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.FUSION, this.constructorSupplier(FusionImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.INTERSECTION, this.constructorSupplier(IntersectionImplementor.class));
        Supplier<GroupingImplementor> grouping = this.constructorSupplier(GroupingImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.GROUPING, grouping);
        this.aggMap.put(SqlStdOperatorTable.GROUPING_ID, grouping);
        this.winAggMap.put(SqlStdOperatorTable.RANK, this.constructorSupplier(RankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.DENSE_RANK, this.constructorSupplier(DenseRankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.ROW_NUMBER, this.constructorSupplier(RowNumberImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.FIRST_VALUE, this.constructorSupplier(FirstValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.NTH_VALUE, this.constructorSupplier(NthValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAST_VALUE, this.constructorSupplier(LastValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LEAD, this.constructorSupplier(LeadImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAG, this.constructorSupplier(LagImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.NTILE, this.constructorSupplier(NtileImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountWinImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.REGR_COUNT, this.constructorSupplier(CountWinImplementor.class));
        this.matchMap.put(SqlStdOperatorTable.CLASSIFIER, () -> new ClassifierImplementor());
        this.matchMap.put(SqlStdOperatorTable.LAST, () -> new LastImplementor());
        this.tvfImplementorMap.put(SqlStdOperatorTable.TUMBLE, () -> new TumbleImplementor());
        this.tvfImplementorMap.put(SqlStdOperatorTable.HOP, () -> new HopImplementor());
        this.tvfImplementorMap.put(SqlStdOperatorTable.SESSION, () -> new SessionImplementor());
    }

    private <T> Supplier<T> constructorSupplier(Class<T> klass) {
        Constructor constructor;
        try {
            constructor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(klass + " should implement zero arguments constructor");
        }
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
            }
        };
    }

    public static CallImplementor createImplementor(NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        return (translator, call, nullAs) -> {
            RexCallImplementor rexCallImplementor = RexImpTable.createRexCallImplementor(implementor, nullPolicy, harmonize);
            List<RexToLixTranslator.Result> arguments = translator.getCallOperandResult(call);
            assert (arguments != null);
            RexToLixTranslator.Result result = rexCallImplementor.implement(translator, call, arguments);
            return nullAs.handle(result.valueVariable);
        };
    }

    private void defineMethod(SqlOperator operator, String functionName, NullPolicy nullPolicy) {
        this.map.put(operator, new MethodNameImplementor(functionName, nullPolicy, false));
    }

    private void defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.map.put(operator, new MethodImplementor(method, nullPolicy, false));
    }

    private void defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.map.put(operator, new UnaryImplementor(expressionType, nullPolicy, backupMethodName));
    }

    private void defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.map.put(operator, new BinaryImplementor(nullPolicy, true, expressionType, backupMethodName));
    }

    private static RexCallImplementor createRexCallImplementor(final NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        return new AbstractRexCallImplementor(nullPolicy, harmonize){

            @Override
            String getVariableName() {
                return "not_null_udf";
            }

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                return implementor.implement(translator, call, argValueList);
            }
        };
    }

    private static RexCallImplementor wrapAsRexCallImplementor(final CallImplementor implementor) {
        return new AbstractRexCallImplementor(NullPolicy.NONE, false){

            @Override
            String getVariableName() {
                return "udf";
            }

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                return implementor.implement(translator, call, NullAs.NULL);
            }
        };
    }

    public RexCallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            Function udf = ((SqlUserDefinedFunction)operator).getFunction();
            if (!(udf instanceof ImplementableFunction)) {
                throw new IllegalStateException("User defined function " + operator + " must implement ImplementableFunction");
            }
            CallImplementor implementor = ((ImplementableFunction)udf).getImplementor();
            return RexImpTable.wrapAsRexCallImplementor(implementor);
        }
        if (operator instanceof SqlTypeConstructorFunction) {
            return this.map.get(SqlStdOperatorTable.ROW);
        }
        return this.map.get(operator);
    }

    public AggImplementor get(SqlAggFunction aggregation, boolean forWindowAggregate) {
        Supplier<? extends WinAggImplementor> winAgg;
        if (aggregation instanceof SqlUserDefinedAggFunction) {
            SqlUserDefinedAggFunction udaf = (SqlUserDefinedAggFunction)aggregation;
            if (!(udaf.function instanceof ImplementableAggFunction)) {
                throw new IllegalStateException("User defined aggregation " + aggregation + " must implement ImplementableAggFunction");
            }
            return ((ImplementableAggFunction)udaf.function).getImplementor(forWindowAggregate);
        }
        if (forWindowAggregate && (winAgg = this.winAggMap.get(aggregation)) != null) {
            return winAgg.get();
        }
        Supplier<? extends AggImplementor> aggSupplier = this.aggMap.get(aggregation);
        if (aggSupplier == null) {
            return null;
        }
        return aggSupplier.get();
    }

    public MatchImplementor get(SqlMatchFunction function) {
        Supplier<? extends MatchImplementor> supplier = this.matchMap.get(function);
        if (supplier != null) {
            return supplier.get();
        }
        throw new IllegalStateException("Supplier should not be null");
    }

    public TableFunctionCallImplementor get(SqlWindowTableFunction operator) {
        Supplier<? extends TableFunctionCallImplementor> supplier = this.tvfImplementorMap.get(operator);
        if (supplier != null) {
            return supplier.get();
        }
        throw new IllegalStateException("Supplier should not be null");
    }

    static Expression optimize(Expression expression) {
        return expression.accept(new OptimizeShuttle());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is(operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition(Expressions.equal(operand, NULL_EXPR), NULL_EXPR, expression));
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != null && typeName != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    static Expression getDefaultValue(Type type) {
        if (Primitive.is(type)) {
            Primitive p = Primitive.of(type);
            return Expressions.constant(p.defaultValue, type);
        }
        return Expressions.constant(null, type);
    }

    public static Expression multiplyDivide(Expression e, BigDecimal multiplier, BigDecimal divider) {
        if (multiplier.equals(BigDecimal.ONE)) {
            if (divider.equals(BigDecimal.ONE)) {
                return e;
            }
            return Expressions.divide(e, Expressions.constant(divider.intValueExact()));
        }
        BigDecimal x = multiplier.divide(divider, RoundingMode.UNNECESSARY);
        switch (x.compareTo(BigDecimal.ONE)) {
            case 0: {
                return e;
            }
            case 1: {
                return Expressions.multiply(e, Expressions.constant(x.intValueExact()));
            }
            case -1: {
                return RexImpTable.multiplyDivide(e, BigDecimal.ONE, x);
            }
        }
        throw new AssertionError();
    }

    private static Expression mod(Expression operand, long factor) {
        if (factor == 1L) {
            return operand;
        }
        return Expressions.call(BuiltInMethod.FLOOR_MOD.method, operand, Expressions.constant(factor));
    }

    private static long getFactor(TimeUnit unit) {
        switch (unit) {
            case DAY: {
                return 1L;
            }
            case HOUR: {
                return TimeUnit.DAY.multiplier.longValue();
            }
            case MINUTE: {
                return TimeUnit.HOUR.multiplier.longValue();
            }
            case SECOND: {
                return TimeUnit.MINUTE.multiplier.longValue();
            }
            case MILLISECOND: {
                return TimeUnit.SECOND.multiplier.longValue();
            }
            case MONTH: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case QUARTER: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case MILLENNIUM: 
            case CENTURY: 
            case YEAR: 
            case DECADE: {
                return 1L;
            }
        }
        throw Util.unexpected(unit);
    }

    private static class SessionImplementor
    implements TableFunctionCallImplementor {
        private SessionImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, Expression inputEnumerable, RexCall call, PhysType inputPhysType, PhysType outputPhysType) {
            RexCall timestampDescriptor = (RexCall)call.getOperands().get(0);
            RexCall keyDescriptor = (RexCall)call.getOperands().get(1);
            Expression gapInterval = translator.translate(call.getOperands().get(2));
            ConstantExpression wmColIndexExpr = Expressions.constant(((RexInputRef)timestampDescriptor.getOperands().get(0)).getIndex());
            ConstantExpression keyColIndexExpr = Expressions.constant(((RexInputRef)keyDescriptor.getOperands().get(0)).getIndex());
            return Expressions.call(BuiltInMethod.SESSIONIZATION.method, Expressions.list(Expressions.call(inputEnumerable, BuiltInMethod.ENUMERABLE_ENUMERATOR.method, new Expression[0]), wmColIndexExpr, keyColIndexExpr, gapInterval));
        }
    }

    private static class HopImplementor
    implements TableFunctionCallImplementor {
        private HopImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, Expression inputEnumerable, RexCall call, PhysType inputPhysType, PhysType outputPhysType) {
            Expression slidingInterval = translator.translate(call.getOperands().get(1));
            Expression windowSize = translator.translate(call.getOperands().get(2));
            RexCall descriptor = (RexCall)call.getOperands().get(0);
            ConstantExpression wmColIndexExpr = Expressions.constant(((RexInputRef)descriptor.getOperands().get(0)).getIndex());
            ConstantExpression offsetExpr = call.getOperands().size() > 3 ? translator.translate(call.getOperands().get(3)) : Expressions.constant(0, Long.TYPE);
            return Expressions.call(BuiltInMethod.HOPPING.method, Expressions.list(Expressions.call(inputEnumerable, BuiltInMethod.ENUMERABLE_ENUMERATOR.method, new Expression[0]), wmColIndexExpr, slidingInterval, windowSize, offsetExpr));
        }
    }

    private static class TumbleImplementor
    implements TableFunctionCallImplementor {
        private TumbleImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, Expression inputEnumerable, RexCall call, PhysType inputPhysType, PhysType outputPhysType) {
            Expression intervalExpression = translator.translate(call.getOperands().get(1));
            RexCall descriptor = (RexCall)call.getOperands().get(0);
            ParameterExpression parameter = Expressions.parameter(Primitive.box(inputPhysType.getJavaRowType()), "_input");
            Expression wmColExpr = inputPhysType.fieldReference(parameter, ((RexInputRef)descriptor.getOperands().get(0)).getIndex(), outputPhysType.getJavaFieldType(inputPhysType.getRowType().getFieldCount()));
            ConstantExpression offsetExpr = call.getOperands().size() > 2 ? translator.translate(call.getOperands().get(2)) : Expressions.constant(0, Long.TYPE);
            return Expressions.call(BuiltInMethod.TUMBLING.method, inputEnumerable, EnumUtils.tumblingWindowSelector(inputPhysType, outputPhysType, wmColExpr, intervalExpression, offsetExpr));
        }
    }

    private static class DefaultImplementor
    extends AbstractRexCallImplementor {
        DefaultImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "default";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.constant(null);
        }
    }

    private static class RegexpReplaceImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor[] implementors;

        RegexpReplaceImplementor() {
            super(NullPolicy.STRICT, false);
            this.implementors = new AbstractRexCallImplementor[]{new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE3.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE4.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE5.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE6.method, this.nullPolicy)};
        }

        @Override
        String getVariableName() {
            return "regexp_replace";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementors[call.getOperands().size() - 3].implementSafe(translator, call, argValueList);
        }
    }

    private static class IsTrueImplementor
    extends AbstractRexCallImplementor {
        IsTrueImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_true";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant(false, type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal(argValueList.get(0), TRUE_EXPR);
        }
    }

    private static class IsNullImplementor
    extends AbstractRexCallImplementor {
        IsNullImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_null";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant(true, type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal(argValueList.get(0), NULL_EXPR);
        }
    }

    private static class IsNotTrueImplementor
    extends AbstractRexCallImplementor {
        IsNotTrueImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_not_true";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant(true, type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual(argValueList.get(0), TRUE_EXPR);
        }
    }

    private static class IsNotNullImplementor
    extends AbstractRexCallImplementor {
        IsNotNullImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_not_null";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant(false, type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual(argValueList.get(0), NULL_EXPR);
        }
    }

    private static class IsNotFalseImplementor
    extends AbstractRexCallImplementor {
        IsNotFalseImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_not_false";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant(true, type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual(argValueList.get(0), FALSE_EXPR);
        }
    }

    private static class IsFalseImplementor
    extends AbstractRexCallImplementor {
        IsFalseImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_false";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant(false, type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal(argValueList.get(0), FALSE_EXPR);
        }
    }

    private static class PiImplementor
    extends AbstractRexCallImplementor {
        PiImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "pi";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.constant(Math.PI);
        }
    }

    private static class RandIntegerImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor[] implementors;

        RandIntegerImplementor() {
            super(NullPolicy.STRICT, false);
            this.implementors = new AbstractRexCallImplementor[]{null, new ReflectiveImplementor(BuiltInMethod.RAND_INTEGER.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.RAND_INTEGER_SEED.method, this.nullPolicy)};
        }

        @Override
        String getVariableName() {
            return "rand_integer";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementors[call.getOperands().size()].implementSafe(translator, call, argValueList);
        }
    }

    private static class RandImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor[] implementors;

        RandImplementor() {
            super(NullPolicy.STRICT, false);
            this.implementors = new AbstractRexCallImplementor[]{new ReflectiveImplementor(BuiltInMethod.RAND.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.RAND_SEED.method, this.nullPolicy)};
        }

        @Override
        String getVariableName() {
            return "rand";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementors[call.getOperands().size()].implementSafe(translator, call, argValueList);
        }
    }

    private static class ReflectiveImplementor
    extends AbstractRexCallImplementor {
        protected final Method method;

        ReflectiveImplementor(Method method, NullPolicy nullPolicy) {
            super(nullPolicy, false);
            this.method = method;
        }

        @Override
        String getVariableName() {
            return "reflective_" + this.method.getName();
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            List<Expression> argValueList0 = EnumUtils.fromInternal(this.method.getParameterTypes(), argValueList);
            if ((this.method.getModifiers() & 8) != 0) {
                return Expressions.call(this.method, argValueList0);
            }
            NewExpression target = Expressions.new_(this.method.getDeclaringClass());
            return Expressions.call((Expression)target, this.method, argValueList0);
        }
    }

    private static class LogicalNotImplementor
    extends AbstractRexCallImplementor {
        LogicalNotImplementor() {
            super(NullPolicy.NONE, true);
        }

        @Override
        String getVariableName() {
            return "logical_not";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.call(BuiltInMethod.NOT.method, argValueList);
        }
    }

    private static class LogicalOrImplementor
    extends AbstractRexCallImplementor {
        LogicalOrImplementor() {
            super(NullPolicy.NONE, true);
        }

        @Override
        String getVariableName() {
            return "logical_or";
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<Expression> argIsNullList = new ArrayList<Expression>();
            for (RexToLixTranslator.Result result2 : arguments) {
                argIsNullList.add(result2.isNullVariable);
            }
            List<Expression> nullAsFalse = arguments.stream().map(result -> Expressions.condition(result.isNullVariable, FALSE_EXPR, result.valueVariable)).collect(Collectors.toList());
            Expression hasTrue = Expressions.foldOr(nullAsFalse);
            Expression hasNull = Expressions.foldOr(argIsNullList);
            Expression callExpression = Expressions.condition(hasTrue, BOXED_TRUE_EXPR, Expressions.condition(hasNull, NULL_EXPR, BOXED_FALSE_EXPR));
            NullAs nullAs = translator.isNullable(call) ? NullAs.NULL : NullAs.NOT_POSSIBLE;
            Expression valueExpression = nullAs.handle(callExpression);
            ParameterExpression valueVariable = Expressions.parameter(valueExpression.getType(), translator.getBlockBuilder().newName(this.getVariableName() + "_value"));
            Expression isNullExpression = translator.checkNull(valueExpression);
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, translator.getBlockBuilder().newName(this.getVariableName() + "_isNull"));
            translator.getBlockBuilder().add(Expressions.declare(16, valueVariable, valueExpression));
            translator.getBlockBuilder().add(Expressions.declare(16, isNullVariable, isNullExpression));
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return null;
        }
    }

    private static class LogicalAndImplementor
    extends AbstractRexCallImplementor {
        LogicalAndImplementor() {
            super(NullPolicy.NONE, true);
        }

        @Override
        String getVariableName() {
            return "logical_and";
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<Expression> argIsNullList = new ArrayList<Expression>();
            for (RexToLixTranslator.Result result2 : arguments) {
                argIsNullList.add(result2.isNullVariable);
            }
            List<Expression> nullAsTrue = arguments.stream().map(result -> Expressions.condition(result.isNullVariable, TRUE_EXPR, result.valueVariable)).collect(Collectors.toList());
            UnaryExpression hasFalse = Expressions.not(Expressions.foldAnd(nullAsTrue));
            Expression hasNull = Expressions.foldOr(argIsNullList);
            Expression callExpression = Expressions.condition(hasFalse, BOXED_FALSE_EXPR, Expressions.condition(hasNull, NULL_EXPR, BOXED_TRUE_EXPR));
            NullAs nullAs = translator.isNullable(call) ? NullAs.NULL : NullAs.NOT_POSSIBLE;
            Expression valueExpression = nullAs.handle(callExpression);
            ParameterExpression valueVariable = Expressions.parameter(valueExpression.getType(), translator.getBlockBuilder().newName(this.getVariableName() + "_value"));
            Expression isNullExpression = translator.checkNull(valueVariable);
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, translator.getBlockBuilder().newName(this.getVariableName() + "_isNull"));
            translator.getBlockBuilder().add(Expressions.declare(16, valueVariable, valueExpression));
            translator.getBlockBuilder().add(Expressions.declare(16, isNullVariable, isNullExpression));
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return null;
        }
    }

    private static abstract class AbstractRexCallImplementor
    implements RexCallImplementor {
        final NullPolicy nullPolicy;
        private final boolean harmonize;

        AbstractRexCallImplementor(NullPolicy nullPolicy, boolean harmonize) {
            this.nullPolicy = nullPolicy;
            this.harmonize = harmonize;
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<Expression> argIsNullList = new ArrayList<Expression>();
            ArrayList<Expression> argValueList = new ArrayList<Expression>();
            for (RexToLixTranslator.Result result : arguments) {
                argIsNullList.add(result.isNullVariable);
                argValueList.add(result.valueVariable);
            }
            Expression condition = this.getCondition(argIsNullList);
            ParameterExpression valueVariable = this.genValueStatement(translator, call, argValueList, condition);
            ParameterExpression isNullVariable = this.genIsNullStatement(translator, valueVariable);
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        abstract String getVariableName();

        Expression getCondition(List<Expression> argIsNullList) {
            if (argIsNullList.size() == 0 || this.nullPolicy == null || this.nullPolicy == NullPolicy.NONE) {
                return FALSE_EXPR;
            }
            if (this.nullPolicy == NullPolicy.ARG0) {
                return argIsNullList.get(0);
            }
            return Expressions.foldOr(argIsNullList);
        }

        private ParameterExpression genValueStatement(RexToLixTranslator translator, RexCall call, List<Expression> argValueList, Expression condition) {
            List<Expression> optimizedArgValueList = argValueList;
            if (this.harmonize) {
                optimizedArgValueList = this.harmonize(optimizedArgValueList, translator, call);
            }
            optimizedArgValueList = this.unboxIfNecessary(optimizedArgValueList);
            Expression callValue = this.implementSafe(translator, call, optimizedArgValueList);
            SqlOperator op = call.getOperator();
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            boolean noConvert = returnType == null || returnType == callValue.getType() || op instanceof SqlUserDefinedTableMacro || op instanceof SqlUserDefinedTableFunction;
            Expression convertedCallValue = noConvert ? callValue : EnumUtils.convert(callValue, returnType);
            Expression valueExpression = Expressions.condition(condition, this.getIfTrue(convertedCallValue.getType(), argValueList), convertedCallValue);
            ParameterExpression value = Expressions.parameter(convertedCallValue.getType(), translator.getBlockBuilder().newName(this.getVariableName() + "_value"));
            translator.getBlockBuilder().add(Expressions.declare(16, value, valueExpression));
            return value;
        }

        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return RexImpTable.getDefaultValue(type);
        }

        private ParameterExpression genIsNullStatement(RexToLixTranslator translator, ParameterExpression value) {
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, translator.getBlockBuilder().newName(this.getVariableName() + "_isNull"));
            Expression isNullExpression = translator.checkNull(value);
            translator.getBlockBuilder().add(Expressions.declare(16, isNullVariable, isNullExpression));
            return isNullVariable;
        }

        private List<Expression> harmonize(List<Expression> argValueList, RexToLixTranslator translator, RexCall call) {
            int nullCount = 0;
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
            for (RexNode operand : call.getOperands()) {
                RelDataType type = operand.getType();
                type = RexImpTable.toSql(typeFactory, type);
                if (translator.isNullable(operand)) {
                    ++nullCount;
                } else {
                    type = typeFactory.createTypeWithNullability(type, false);
                }
                types.add(type);
            }
            if (RexImpTable.allSame(types)) {
                return argValueList;
            }
            RelDataType type = typeFactory.leastRestrictive(types);
            if (type == null) {
                return argValueList;
            }
            assert (nullCount > 0 == type.isNullable());
            Type javaClass = translator.typeFactory.getJavaClass(type);
            ArrayList<Expression> harmonizedArgValues = new ArrayList<Expression>();
            for (Expression argValue : argValueList) {
                harmonizedArgValues.add(EnumUtils.convert(argValue, javaClass));
            }
            return harmonizedArgValues;
        }

        private List<Expression> unboxIfNecessary(List<Expression> argValueList) {
            List<Expression> unboxValueList = argValueList;
            if (this.nullPolicy == NullPolicy.STRICT || this.nullPolicy == NullPolicy.ANY || this.nullPolicy == NullPolicy.SEMI_STRICT) {
                unboxValueList = argValueList.stream().map(this::unboxExpression).collect(Collectors.toList());
            }
            if (this.nullPolicy == NullPolicy.ARG0 && argValueList.size() > 0) {
                Expression unboxArg0 = this.unboxExpression(unboxValueList.get(0));
                unboxValueList.set(0, unboxArg0);
            }
            return unboxValueList;
        }

        private Expression unboxExpression(Expression argValue) {
            Primitive fromBox = Primitive.ofBox(argValue.getType());
            if (fromBox == null || fromBox == Primitive.VOID) {
                return argValue;
            }
            if (argValue instanceof MethodCallExpression) {
                MethodCallExpression mce = (MethodCallExpression)argValue;
                if (mce.method.getName().equals("valueOf") && mce.expressions.size() == 1) {
                    Expression originArg = mce.expressions.get(0);
                    if (Primitive.of(originArg.type) == fromBox) {
                        return originArg;
                    }
                }
            }
            return NullAs.NOT_POSSIBLE.handle(argValue);
        }

        abstract Expression implementSafe(RexToLixTranslator var1, RexCall var2, List<Expression> var3);
    }

    public static interface RexCallImplementor {
        public RexToLixTranslator.Result implement(RexToLixTranslator var1, RexCall var2, List<RexToLixTranslator.Result> var3);
    }

    private static class LastImplementor
    implements MatchImplementor {
        private LastImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, ParameterExpression row, ParameterExpression rows, ParameterExpression symbols, ParameterExpression i) {
            RexNode node = call.getOperands().get(0);
            String alpha = ((RexPatternFieldRef)call.getOperands().get(0)).getAlpha();
            BinaryExpression lastIndex = Expressions.subtract(Expressions.call((Expression)rows, BuiltInMethod.COLLECTION_SIZE.method, new Expression[0]), Expressions.constant(1));
            if ("*".equals(alpha)) {
                ((EnumerableMatch.PassedRowsInputGetter)translator.inputGetter).setIndex(i);
                RexPatternFieldRef ref = (RexPatternFieldRef)node;
                RexPatternFieldRef newRef = new RexPatternFieldRef(ref.getAlpha(), ref.getIndex(), translator.typeFactory.createTypeWithNullability(ref.getType(), true));
                Expression expression = translator.translate((RexNode)newRef, NullAs.NULL);
                ((EnumerableMatch.PassedRowsInputGetter)translator.inputGetter).setIndex(null);
                return expression;
            }
            ((EnumerableMatch.PassedRowsInputGetter)translator.inputGetter).setIndex(Expressions.call(BuiltInMethod.MATCH_UTILS_LAST_WITH_SYMBOL.method, Expressions.constant(alpha), rows, symbols, i));
            RexPatternFieldRef ref = (RexPatternFieldRef)node;
            RexPatternFieldRef newRef = new RexPatternFieldRef(ref.getAlpha(), ref.getIndex(), translator.typeFactory.createTypeWithNullability(ref.getType(), true));
            Expression expression = translator.translate((RexNode)newRef, NullAs.NULL);
            ((EnumerableMatch.PassedRowsInputGetter)translator.inputGetter).setIndex(null);
            return expression;
        }
    }

    private static class ClassifierImplementor
    implements MatchImplementor {
        private ClassifierImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, ParameterExpression row, ParameterExpression rows, ParameterExpression symbols, ParameterExpression i) {
            return EnumUtils.convert(Expressions.call((Expression)symbols, BuiltInMethod.LIST_GET.method, i), String.class);
        }
    }

    private static class DatetimeArithmeticImplementor
    extends AbstractRexCallImplementor {
        DatetimeArithmeticImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "dateTime_arithmetic";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            RexNode operand0 = call.getOperands().get(0);
            Expression trop0 = argValueList.get(0);
            SqlTypeName typeName1 = call.getOperands().get(1).getType().getSqlTypeName();
            Expression trop1 = argValueList.get(1);
            SqlTypeName typeName = call.getType().getSqlTypeName();
            block0 : switch (operand0.getType().getSqlTypeName()) {
                case DATE: {
                    switch (typeName) {
                        case TIMESTAMP: {
                            trop0 = Expressions.convert_(Expressions.multiply(trop0, Expressions.constant(86400000L)), Long.TYPE);
                            break block0;
                        }
                    }
                    switch (typeName1) {
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            trop1 = Expressions.convert_(Expressions.divide(trop1, Expressions.constant(86400000L)), Integer.TYPE);
                        }
                    }
                    break;
                }
                case TIME: {
                    trop1 = Expressions.convert_(trop1, Integer.TYPE);
                }
            }
            switch (typeName1) {
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    switch (call.getKind()) {
                        case MINUS: {
                            trop1 = Expressions.negate(trop1);
                        }
                    }
                    switch (typeName) {
                        case TIME: {
                            return Expressions.convert_(trop0, Long.TYPE);
                        }
                    }
                    BuiltInMethod method = operand0.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP ? BuiltInMethod.ADD_MONTHS : BuiltInMethod.ADD_MONTHS_INT;
                    return Expressions.call(method.method, trop0, trop1);
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    switch (call.getKind()) {
                        case MINUS: {
                            return this.normalize(typeName, Expressions.subtract(trop0, trop1));
                        }
                    }
                    return this.normalize(typeName, Expressions.add(trop0, trop1));
                }
            }
            switch (call.getKind()) {
                case MINUS: {
                    switch (typeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: {
                            return Expressions.call(BuiltInMethod.SUBTRACT_MONTHS.method, trop0, trop1);
                        }
                    }
                    TimeUnit fromUnit = typeName1 == SqlTypeName.DATE ? TimeUnit.DAY : TimeUnit.MILLISECOND;
                    TimeUnit toUnit = TimeUnit.MILLISECOND;
                    return RexImpTable.multiplyDivide(Expressions.convert_(Expressions.subtract(trop0, trop1), Long.TYPE), fromUnit.multiplier, toUnit.multiplier);
                }
            }
            throw new AssertionError(call);
        }

        private Expression normalize(SqlTypeName typeName, Expression e) {
            switch (typeName) {
                case TIME: {
                    return Expressions.call(BuiltInMethod.FLOOR_MOD.method, e, Expressions.constant(86400000L));
                }
            }
            return e;
        }
    }

    private static class NotImplementor
    extends AbstractRexCallImplementor {
        private AbstractRexCallImplementor implementor;

        private NotImplementor(AbstractRexCallImplementor implementor) {
            super(null, false);
            this.implementor = implementor;
        }

        static AbstractRexCallImplementor of(AbstractRexCallImplementor implementor) {
            return new NotImplementor(implementor);
        }

        @Override
        String getVariableName() {
            return "not";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression expression = this.implementor.implementSafe(translator, call, argValueList);
            return Expressions.not(expression);
        }
    }

    private static class SystemFunctionImplementor
    extends AbstractRexCallImplementor {
        SystemFunctionImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "system_func";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlOperator op = call.getOperator();
            Expression root = translator.getRoot();
            if (op == SqlStdOperatorTable.CURRENT_USER || op == SqlStdOperatorTable.SESSION_USER || op == SqlStdOperatorTable.USER) {
                return Expressions.call(BuiltInMethod.USER.method, root);
            }
            if (op == SqlStdOperatorTable.SYSTEM_USER) {
                return Expressions.call(BuiltInMethod.SYSTEM_USER.method, root);
            }
            if (op == SqlStdOperatorTable.CURRENT_PATH || op == SqlStdOperatorTable.CURRENT_ROLE || op == SqlStdOperatorTable.CURRENT_CATALOG) {
                return Expressions.constant("");
            }
            if (op == SqlStdOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call(BuiltInMethod.CURRENT_TIMESTAMP.method, root);
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call(BuiltInMethod.CURRENT_TIME.method, root);
            }
            if (op == SqlStdOperatorTable.CURRENT_DATE) {
                return Expressions.call(BuiltInMethod.CURRENT_DATE.method, root);
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call(BuiltInMethod.LOCAL_TIMESTAMP.method, root);
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call(BuiltInMethod.LOCAL_TIME.method, root);
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    private static class ItemImplementor
    extends AbstractRexCallImplementor {
        ItemImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "item";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            MethodImplementor implementor = this.getImplementor(call.getOperands().get(0).getType().getSqlTypeName());
            return implementor.implementSafe(translator, call, argValueList);
        }

        private MethodImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case ARRAY: {
                    return new MethodImplementor(BuiltInMethod.ARRAY_ITEM.method, this.nullPolicy, false);
                }
                case MAP: {
                    return new MethodImplementor(BuiltInMethod.MAP_ITEM.method, this.nullPolicy, false);
                }
            }
            return new MethodImplementor(BuiltInMethod.ANY_ITEM.method, this.nullPolicy, false);
        }
    }

    private static class ValueConstructorImplementor
    extends AbstractRexCallImplementor {
        ValueConstructorImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "value_constructor";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlKind kind = call.getOperator().getKind();
            BlockBuilder blockBuilder = translator.getBlockBuilder();
            switch (kind) {
                case MAP_VALUE_CONSTRUCTOR: {
                    Expression map = blockBuilder.append("map", Expressions.new_(LinkedHashMap.class), false);
                    for (int i = 0; i < argValueList.size(); ++i) {
                        Expression key = argValueList.get(i++);
                        Expression value = argValueList.get(i);
                        blockBuilder.add(Expressions.statement(Expressions.call(map, BuiltInMethod.MAP_PUT.method, Expressions.box(key), Expressions.box(value))));
                    }
                    return map;
                }
                case ARRAY_VALUE_CONSTRUCTOR: {
                    Expression lyst = blockBuilder.append("list", Expressions.new_(ArrayList.class), false);
                    for (Expression value : argValueList) {
                        blockBuilder.add(Expressions.statement(Expressions.call(lyst, BuiltInMethod.COLLECTION_ADD.method, Expressions.box(value))));
                    }
                    return lyst;
                }
            }
            throw new AssertionError((Object)("unexpected: " + (Object)((Object)kind)));
        }
    }

    private static class ReinterpretImplementor
    extends AbstractRexCallImplementor {
        ReinterpretImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "reInterpret";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            assert (call.getOperands().size() == 1);
            return argValueList.get(0);
        }
    }

    private static class CastImplementor
    extends AbstractRexCallImplementor {
        CastImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "cast";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            assert (call.getOperands().size() == 1);
            RelDataType sourceType = call.getOperands().get(0).getType();
            RexNode arg = call.getOperands().get(0);
            if (call.getType().equals(sourceType)) {
                return argValueList.get(0);
            }
            if (SqlTypeUtil.equalSansNullability(translator.typeFactory, call.getType(), arg.getType()) && translator.deref(arg) instanceof RexLiteral) {
                return RexToLixTranslator.translateLiteral((RexLiteral)translator.deref(arg), call.getType(), translator.typeFactory, NullAs.NULL);
            }
            RelDataType targetType = this.nullifyType(translator.typeFactory, call.getType(), false);
            return translator.translateCast(sourceType, targetType, argValueList.get(0));
        }

        private RelDataType nullifyType(JavaTypeFactory typeFactory, RelDataType type, boolean nullable) {
            Primitive primitive;
            if (type instanceof RelDataTypeFactoryImpl.JavaType && (primitive = Primitive.ofBox(((RelDataTypeFactoryImpl.JavaType)type).getJavaClass())) != null) {
                return typeFactory.createJavaType(primitive.primitiveClass);
            }
            return typeFactory.createTypeWithNullability(type, nullable);
        }
    }

    private static class CoalesceImplementor
    extends AbstractRexCallImplementor {
        CoalesceImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "coalesce";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementRecurse(translator, argValueList);
        }

        private Expression implementRecurse(RexToLixTranslator translator, List<Expression> argValueList) {
            if (argValueList.size() == 1) {
                return argValueList.get(0);
            }
            return Expressions.condition(translator.checkNotNull(argValueList.get(0)), argValueList.get(0), this.implementRecurse(translator, Util.skip(argValueList)));
        }
    }

    private static class ExtractImplementor
    extends AbstractRexCallImplementor {
        ExtractImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "extract";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            TimeUnitRange timeUnitRange = (TimeUnitRange)((Object)translator.getLiteralValue(argValueList.get(0)));
            TimeUnit unit = timeUnitRange.startUnit;
            Expression operand = argValueList.get(1);
            SqlTypeName sqlTypeName = ((RexNode)call.operands.get(1)).getType().getSqlTypeName();
            block0 : switch (unit) {
                case MILLENNIUM: 
                case CENTURY: 
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: 
                case DOW: 
                case DECADE: 
                case DOY: 
                case ISODOW: 
                case ISOYEAR: 
                case WEEK: {
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            break block0;
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, translator.getRoot()));
                        }
                        case TIMESTAMP: {
                            operand = Expressions.call(BuiltInMethod.FLOOR_DIV.method, operand, Expressions.constant(TimeUnit.DAY.multiplier.longValue()));
                        }
                        case DATE: {
                            return Expressions.call(BuiltInMethod.UNIX_DATE_EXTRACT.method, argValueList.get(0), operand);
                        }
                    }
                    throw new AssertionError((Object)("unexpected " + (Object)((Object)sqlTypeName)));
                }
                case MILLISECOND: 
                case MICROSECOND: 
                case NANOSECOND: {
                    if (sqlTypeName == SqlTypeName.DATE) {
                        return Expressions.constant(0L);
                    }
                    operand = RexImpTable.mod(operand, TimeUnit.MINUTE.multiplier.longValue());
                    return Expressions.multiply(operand, Expressions.constant((long)(1.0 / unit.multiplier.doubleValue())));
                }
                case EPOCH: {
                    switch (sqlTypeName) {
                        case DATE: {
                            operand = Expressions.multiply(operand, Expressions.constant(TimeUnit.DAY.multiplier.longValue()));
                        }
                        case TIMESTAMP: {
                            return Expressions.divide(operand, Expressions.constant(TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, translator.getRoot()));
                            return Expressions.divide(operand, Expressions.constant(TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            throw new AssertionError((Object)("unexpected " + (Object)((Object)sqlTypeName)));
                        }
                    }
                    break;
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    switch (sqlTypeName) {
                        case DATE: {
                            return Expressions.multiply(operand, Expressions.constant(0L));
                        }
                    }
                }
            }
            operand = RexImpTable.mod(operand, RexImpTable.getFactor(unit));
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.subtract(operand, Expressions.constant(1L));
            }
            operand = Expressions.divide(operand, Expressions.constant(unit.multiplier.longValue()));
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.add(operand, Expressions.constant(1L));
            }
            return operand;
        }
    }

    private static class UnaryImplementor
    extends AbstractRexCallImplementor {
        private final ExpressionType expressionType;
        private final String backupMethodName;

        UnaryImplementor(ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
            super(nullPolicy, false);
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        String getVariableName() {
            return "unary_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression argValue = argValueList.get(0);
            Expression e = this.expressionType == ExpressionType.Negate && argValue.type == BigDecimal.class && null != this.backupMethodName ? Expressions.call(argValue, this.backupMethodName, new Expression[0]) : Expressions.makeUnary(this.expressionType, argValue);
            if (e.type.equals(argValue.type)) {
                return e;
            }
            return Expressions.convert_(e, argValue.type);
        }
    }

    private static class BinaryImplementor
    extends AbstractRexCallImplementor {
        private static final List<Primitive> COMP_OP_TYPES = ImmutableList.of(Primitive.BYTE, Primitive.CHAR, Primitive.SHORT, Primitive.INT, Primitive.LONG, Primitive.FLOAT, Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = ImmutableList.of(SqlStdOperatorTable.LESS_THAN, SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlStdOperatorTable.GREATER_THAN, SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        private static final List<SqlBinaryOperator> EQUALS_OPERATORS = ImmutableList.of(SqlStdOperatorTable.EQUALS, SqlStdOperatorTable.NOT_EQUALS);
        public static final String METHOD_POSTFIX_FOR_ANY_TYPE = "Any";
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(NullPolicy nullPolicy, boolean harmonize, ExpressionType expressionType, String backupMethodName) {
            super(nullPolicy, harmonize);
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        String getVariableName() {
            return "binary_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (this.backupMethodName != null) {
                Primitive primitive;
                if (this.anyAnyOperands(call)) {
                    return this.callBackupMethodAnyType(translator, call, argValueList);
                }
                Type type0 = argValueList.get(0).getType();
                Type type1 = argValueList.get(1).getType();
                SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
                RelDataType relDataType0 = call.getOperands().get(0).getType();
                Expression fieldComparator = EnumUtils.generateCollatorExpression(relDataType0.getCollation());
                if (fieldComparator != null) {
                    argValueList.add(fieldComparator);
                }
                if ((primitive = Primitive.ofBoxOr(type0)) == null || type1 == BigDecimal.class || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains((Object)primitive)) {
                    return Expressions.call(SqlFunctions.class, this.backupMethodName, argValueList);
                }
                Primitive boxPrimitive0 = Primitive.ofBox(type0);
                Primitive boxPrimitive1 = Primitive.ofBox(type1);
                if (EQUALS_OPERATORS.contains(op) && boxPrimitive0 != null && boxPrimitive1 != null) {
                    return Expressions.call(SqlFunctions.class, this.backupMethodName, argValueList);
                }
            }
            return Expressions.makeBinary(this.expressionType, argValueList.get(0), argValueList.get(1));
        }

        private boolean anyAnyOperands(RexCall call) {
            for (RexNode operand : call.operands) {
                if (operand.getType().getSqlTypeName() != SqlTypeName.ANY) continue;
                return true;
            }
            return false;
        }

        private Expression callBackupMethodAnyType(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            String backupMethodNameForAnyType = this.backupMethodName + METHOD_POSTFIX_FOR_ANY_TYPE;
            Expression expression0 = this.maybeBox(expressions.get(0));
            Expression expression1 = this.maybeBox(expressions.get(1));
            return Expressions.call(SqlFunctions.class, backupMethodNameForAnyType, new Expression[]{expression0, expression1});
        }

        private Expression maybeBox(Expression expression) {
            Primitive primitive = Primitive.of(expression.getType());
            if (primitive != null) {
                expression = Expressions.box(expression, primitive);
            }
            return expression;
        }
    }

    private static class MethodNameImplementor
    extends AbstractRexCallImplementor {
        protected final String methodName;

        MethodNameImplementor(String methodName, NullPolicy nullPolicy, boolean harmonize) {
            super(nullPolicy, harmonize);
            this.methodName = methodName;
        }

        @Override
        String getVariableName() {
            return "method_name_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return EnumUtils.call(SqlFunctions.class, this.methodName, argValueList);
        }
    }

    private static class JsonValueImplementor
    extends MethodImplementor {
        JsonValueImplementor(Method method) {
            super(method, NullPolicy.ARG0, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            ArrayList<Expression> newOperands = new ArrayList<Expression>();
            newOperands.add(argValueList.get(0));
            newOperands.add(argValueList.get(1));
            List<Expression> leftExprs = Util.skip(argValueList, 2);
            Expression emptyBehavior = Expressions.constant(SqlJsonValueEmptyOrErrorBehavior.NULL);
            Expression defaultValueOnEmpty = Expressions.constant(null);
            Expression errorBehavior = Expressions.constant(SqlJsonValueEmptyOrErrorBehavior.NULL);
            Expression defaultValueOnError = Expressions.constant(null);
            if (leftExprs.size() > 0) {
                for (int i = 0; i < leftExprs.size(); ++i) {
                    Expression expr = leftExprs.get(i);
                    Object exprVal = translator.getLiteralValue(expr);
                    if (exprVal == null) continue;
                    int defaultSymbolIdx = i - 2;
                    if (exprVal == SqlJsonEmptyOrError.EMPTY) {
                        if (defaultSymbolIdx >= 0 && translator.getLiteralValue(leftExprs.get(defaultSymbolIdx)) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                            defaultValueOnEmpty = leftExprs.get(i - 1);
                            emptyBehavior = leftExprs.get(defaultSymbolIdx);
                            continue;
                        }
                        emptyBehavior = leftExprs.get(i - 1);
                        continue;
                    }
                    if (exprVal != SqlJsonEmptyOrError.ERROR) continue;
                    if (defaultSymbolIdx >= 0 && translator.getLiteralValue(leftExprs.get(defaultSymbolIdx)) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                        defaultValueOnError = leftExprs.get(i - 1);
                        errorBehavior = leftExprs.get(defaultSymbolIdx);
                        continue;
                    }
                    errorBehavior = leftExprs.get(i - 1);
                }
            }
            newOperands.add(emptyBehavior);
            newOperands.add(defaultValueOnEmpty);
            newOperands.add(errorBehavior);
            newOperands.add(defaultValueOnError);
            Class<?> clazz = this.method.getDeclaringClass();
            MethodCallExpression expression = EnumUtils.call(clazz, this.method.getName(), newOperands);
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            return EnumUtils.convert(expression, returnType);
        }
    }

    private static class MethodImplementor
    extends AbstractRexCallImplementor {
        protected final Method method;

        MethodImplementor(Method method, NullPolicy nullPolicy, boolean harmonize) {
            super(nullPolicy, harmonize);
            this.method = method;
        }

        @Override
        String getVariableName() {
            return "method_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Class<?> clazz = this.method.getDeclaringClass();
            MethodCallExpression expression = Modifier.isStatic(this.method.getModifiers()) ? EnumUtils.call(clazz, this.method.getName(), argValueList) : EnumUtils.call(clazz, this.method.getName(), Util.skip(argValueList, 1), argValueList.get(0));
            return expression;
        }
    }

    private static class FloorImplementor
    extends MethodNameImplementor {
        final Method timestampMethod;
        final Method dateMethod;

        FloorImplementor(String methodName, Method timestampMethod, Method dateMethod) {
            super(methodName, NullPolicy.STRICT, false);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        String getVariableName() {
            return "floor";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            switch (call.getOperands().size()) {
                case 1: {
                    switch (call.getType().getSqlTypeName()) {
                        case BIGINT: 
                        case INTEGER: 
                        case SMALLINT: 
                        case TINYINT: {
                            return argValueList.get(0);
                        }
                    }
                    return super.implementSafe(translator, call, argValueList);
                }
                case 2: {
                    boolean preFloor;
                    Method floorMethod;
                    Class<Number> type;
                    Expression operand = argValueList.get(0);
                    switch (call.getType().getSqlTypeName()) {
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, translator.getRoot()));
                        }
                        case TIMESTAMP: {
                            type = Long.TYPE;
                            floorMethod = this.timestampMethod;
                            preFloor = true;
                            break;
                        }
                        default: {
                            type = Integer.TYPE;
                            floorMethod = this.dateMethod;
                            preFloor = false;
                        }
                    }
                    TimeUnitRange timeUnitRange = (TimeUnitRange)((Object)translator.getLiteralValue(argValueList.get(1)));
                    switch (timeUnitRange) {
                        case YEAR: 
                        case QUARTER: 
                        case MONTH: 
                        case WEEK: 
                        case DAY: {
                            Expression operand1 = preFloor ? this.call(operand, type, TimeUnit.DAY) : operand;
                            return Expressions.call(floorMethod, translator.getLiteral(argValueList.get(1)), operand1);
                        }
                    }
                    return this.call(operand, type, timeUnitRange.startUnit);
                }
            }
            throw new AssertionError();
        }

        private Expression call(Expression operand, Type type, TimeUnit timeUnit) {
            return Expressions.call(SqlFunctions.class, this.methodName, new Expression[]{EnumUtils.convert(operand, type), EnumUtils.convert(Expressions.constant(timeUnit.multiplier), type)});
        }
    }

    private static class PeriodNameImplementor
    extends MethodNameImplementor {
        private final BuiltInMethod timestampMethod;
        private final BuiltInMethod dateMethod;

        PeriodNameImplementor(String methodName, BuiltInMethod timestampMethod, BuiltInMethod dateMethod) {
            super(methodName, NullPolicy.STRICT, false);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        String getVariableName() {
            return "periodName";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression operand = argValueList.get(0);
            RelDataType type = ((RexNode)call.operands.get(0)).getType();
            switch (type.getSqlTypeName()) {
                case TIMESTAMP: {
                    return this.getExpression(translator, operand, this.timestampMethod);
                }
                case DATE: {
                    return this.getExpression(translator, operand, this.dateMethod);
                }
            }
            throw new AssertionError((Object)("unknown type " + type));
        }

        protected Expression getExpression(RexToLixTranslator translator, Expression operand, BuiltInMethod builtInMethod) {
            MethodCallExpression locale = Expressions.call(BuiltInMethod.LOCALE.method, translator.getRoot());
            return Expressions.call(builtInMethod.method.getDeclaringClass(), builtInMethod.method.getName(), operand, locale);
        }
    }

    private static class TrimImplementor
    extends AbstractRexCallImplementor {
        TrimImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "trim";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            boolean strict = !translator.conformance.allowExtendedTrim();
            Object value = translator.getLiteralValue(argValueList.get(0));
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)value;
            return Expressions.call(BuiltInMethod.TRIM.method, Expressions.constant(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING), Expressions.constant(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING), argValueList.get(1), argValueList.get(2), Expressions.constant(strict));
        }
    }

    static class JsonArrayAggImplementor
    implements AggImplementor {
        private final Method m;

        JsonArrayAggImplementor(Method m3) {
            this.m = m3;
        }

        static Supplier<JsonArrayAggImplementor> supplierFor(Method m3) {
            return () -> new JsonArrayAggImplementor(m3);
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.singletonList(List.class);
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            SqlJsonArrayAggAggFunction function = (SqlJsonArrayAggAggFunction)info.aggregation();
            add.currentBlock().add(Expressions.statement(Expressions.call(this.m, Iterables.concat(Collections.singletonList(add.accumulator().get(0)), add.arguments(), Collections.singletonList(Expressions.constant((Object)function.getNullClause()))))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return Expressions.call(BuiltInMethod.JSONIZE.method, result.accumulator().get(0));
        }
    }

    static class JsonObjectAggImplementor
    implements AggImplementor {
        private final Method m;

        JsonObjectAggImplementor(Method m3) {
            this.m = m3;
        }

        static Supplier<JsonObjectAggImplementor> supplierFor(Method m3) {
            return () -> new JsonObjectAggImplementor(m3);
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.singletonList(Map.class);
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), Expressions.new_(HashMap.class))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            SqlJsonObjectAggAggFunction function = (SqlJsonObjectAggAggFunction)info.aggregation();
            add.currentBlock().add(Expressions.statement(Expressions.call(this.m, Iterables.concat(Collections.singletonList(add.accumulator().get(0)), add.arguments(), Collections.singletonList(Expressions.constant((Object)function.getNullClause()))))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return Expressions.call(BuiltInMethod.JSONIZE.method, result.accumulator().get(0));
        }
    }

    static class RowNumberImplementor
    extends StrictWinAggImplementor {
        RowNumberImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            return Collections.emptyList();
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add(Expressions.subtract(result.index(), result.startIndex()), Expressions.constant(1));
        }
    }

    static class NtileImplementor
    implements WinAggImplementor {
        NtileImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            Expression tiles = winResult.rowTranslator(winResult.index()).translate(rexArgs.get(0), Integer.TYPE);
            BinaryExpression ntile = Expressions.add(Expressions.constant(1), Expressions.divide(Expressions.multiply(tiles, Expressions.subtract(winResult.index(), winResult.startIndex())), winResult.getPartitionRowCount()));
            return ntile;
        }
    }

    public static class LagImplementor
    extends LeadLagImplementor {
        protected LagImplementor() {
            super(false);
        }
    }

    public static class LeadImplementor
    extends LeadLagImplementor {
        protected LeadImplementor() {
            super(true);
        }
    }

    static class LeadLagImplementor
    implements WinAggImplementor {
        private final boolean isLead;

        protected LeadLagImplementor(boolean isLead) {
            this.isLead = isLead;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            ParameterExpression res = Expressions.parameter(0, info.returnType(), result.currentBlock().newName(this.isLead ? "lead" : "lag"));
            RexToLixTranslator currentRowTranslator = winResult.rowTranslator(winResult.computeIndex(Expressions.constant(0), WinAggImplementor.SeekType.SET));
            Expression offset = rexArgs.size() >= 2 ? currentRowTranslator.translate(rexArgs.get(1), Integer.TYPE) : Expressions.constant(1);
            if (!this.isLead) {
                offset = Expressions.negate(offset);
            }
            Expression dstIndex = winResult.computeIndex(offset, WinAggImplementor.SeekType.SET);
            Expression rowInRange = winResult.rowInPartition(dstIndex);
            BlockBuilder thenBlock = result.nestBlock();
            Expression lagResult = winResult.rowTranslator(dstIndex).translate(rexArgs.get(0), res.type);
            thenBlock.add(Expressions.statement(Expressions.assign(res, lagResult)));
            result.exitBlock();
            BlockStatement thenBranch = thenBlock.toBlock();
            Expression defaultValue = rexArgs.size() == 3 ? currentRowTranslator.translate(rexArgs.get(2), res.type) : RexImpTable.getDefaultValue(res.type);
            result.currentBlock().add(Expressions.declare(0, res, null));
            result.currentBlock().add(Expressions.ifThenElse(rowInRange, (Node)thenBranch, (Node)Expressions.statement(Expressions.assign(res, defaultValue))));
            return res;
        }
    }

    static class NthValueImplementor
    implements WinAggImplementor {
        NthValueImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return true;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            ParameterExpression res = Expressions.parameter(0, info.returnType(), result.currentBlock().newName("nth"));
            RexToLixTranslator currentRowTranslator = winResult.rowTranslator(winResult.computeIndex(Expressions.constant(0), WinAggImplementor.SeekType.START));
            Expression dstIndex = winResult.computeIndex(Expressions.subtract(currentRowTranslator.translate(rexArgs.get(1), Integer.TYPE), Expressions.constant(1)), WinAggImplementor.SeekType.START);
            Expression rowInRange = winResult.rowInPartition(dstIndex);
            BlockBuilder thenBlock = result.nestBlock();
            Expression nthValue = winResult.rowTranslator(dstIndex).translate(rexArgs.get(0), res.type);
            thenBlock.add(Expressions.statement(Expressions.assign(res, nthValue)));
            result.exitBlock();
            BlockStatement thenBranch = thenBlock.toBlock();
            Expression defaultValue = RexImpTable.getDefaultValue(res.type);
            result.currentBlock().add(Expressions.declare(0, res, null));
            result.currentBlock().add(Expressions.ifThenElse(rowInRange, (Node)thenBranch, (Node)Expressions.statement(Expressions.assign(res, defaultValue))));
            return res;
        }
    }

    static class LastValueImplementor
    extends FirstLastValueImplementor {
        protected LastValueImplementor() {
            super(WinAggImplementor.SeekType.END);
        }
    }

    static class FirstValueImplementor
    extends FirstLastValueImplementor {
        protected FirstValueImplementor() {
            super(WinAggImplementor.SeekType.START);
        }
    }

    static class FirstLastValueImplementor
    implements WinAggImplementor {
        private final WinAggImplementor.SeekType seekType;

        protected FirstLastValueImplementor(WinAggImplementor.SeekType seekType) {
            this.seekType = seekType;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return true;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            return Expressions.condition(winResult.hasRows(), winResult.rowTranslator(winResult.computeIndex(Expressions.constant(0), this.seekType)).translate(winResult.rexArguments().get(0), info.returnType()), RexImpTable.getDefaultValue(info.returnType()));
        }
    }

    static class DenseRankImplementor
    extends RankImplementor {
        DenseRankImplementor() {
        }

        @Override
        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            return Expressions.add(acc, Expressions.constant(1));
        }
    }

    static class RankImplementor
    extends StrictWinAggImplementor {
        RankImplementor() {
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            Expression acc = add.accumulator().get(0);
            BlockBuilder builder = add.nestBlock();
            add.currentBlock().add(Expressions.ifThen(Expressions.lessThan(add.compareRows(Expressions.subtract(add.currentPosition(), Expressions.constant(1)), add.currentPosition()), Expressions.constant(0)), Expressions.statement(Expressions.assign(acc, this.computeNewRank(acc, add)))));
            add.exitBlock();
            add.currentBlock().add(Expressions.ifThen(Expressions.greaterThan(add.currentPosition(), add.startIndex()), builder.toBlock()));
        }

        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            Expression pos = add.currentPosition();
            if (!add.startIndex().equals(Expressions.constant(0))) {
                pos = Expressions.subtract(pos, add.startIndex());
            }
            return pos;
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add(super.implementNotNullResult(info, result), Expressions.constant(1));
        }
    }

    public static class UserDefinedAggReflectiveImplementor
    extends StrictAggImplementor {
        private final AggregateFunctionImpl afi;

        public UserDefinedAggReflectiveImplementor(AggregateFunctionImpl afi) {
            this.afi = afi;
        }

        @Override
        public List<Type> getNotNullState(AggContext info) {
            if (this.afi.isStatic) {
                return Collections.singletonList(this.afi.accumulatorType);
            }
            return Arrays.asList(this.afi.accumulatorType, this.afi.declaringClass);
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            if (!this.afi.isStatic) {
                reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(1), Expressions.new_(this.afi.declaringClass))));
            }
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(0), Expressions.call(this.afi.isStatic ? null : acc.get(1), this.afi.initMethod, new Expression[0]))));
        }

        @Override
        protected void implementNotNullAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            List<Expression> aggArgs = add.arguments();
            ArrayList<Expression> args = new ArrayList<Expression>(aggArgs.size() + 1);
            args.add(acc.get(0));
            args.addAll(aggArgs);
            add.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(0), Expressions.call(this.afi.isStatic ? null : acc.get(1), this.afi.addMethod, args))));
        }

        @Override
        protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
            List<Expression> acc = result.accumulator();
            return Expressions.call(this.afi.isStatic ? null : acc.get(1), this.afi.resultMethod, acc.get(0));
        }
    }

    static class GroupingImplementor
    implements AggImplementor {
        GroupingImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return ImmutableList.of();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            List<Integer> keys;
            switch (info.aggregation().kind) {
                case GROUPING: {
                    keys = result.call().getArgList();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Expression e = null;
            if (info.groupSets().size() > 1) {
                List<Integer> keyOrdinals = info.keyOrdinals();
                long x = 1L << keys.size() - 1;
                for (int k : keys) {
                    int i = keyOrdinals.indexOf(k);
                    assert (i >= 0);
                    Expression e2 = Expressions.condition(result.keyField(keyOrdinals.size() + i), Expressions.constant(x), Expressions.constant(0L));
                    e = e == null ? e2 : Expressions.add(e, e2);
                    x >>= 1;
                }
            }
            return e != null ? e : Expressions.constant(0, info.returnType());
        }
    }

    static class BitOpImplementor
    extends StrictAggImplementor {
        BitOpImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            Integer initValue = info.aggregation() == SqlStdOperatorTable.BIT_AND ? -1 : 0;
            ConstantExpression start = Expressions.constant(initValue, info.returnType());
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), start)));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            BuiltInMethod builtInMethod;
            Expression acc = add.accumulator().get(0);
            Expression arg = add.arguments().get(0);
            SqlAggFunction aggregation = info.aggregation();
            switch (aggregation.kind) {
                case BIT_AND: {
                    builtInMethod = BuiltInMethod.BIT_AND;
                    break;
                }
                case BIT_OR: {
                    builtInMethod = BuiltInMethod.BIT_OR;
                    break;
                }
                case BIT_XOR: {
                    builtInMethod = BuiltInMethod.BIT_XOR;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown " + aggregation.getName() + ". Only support bit_and, bit_or and bit_xor for bit aggregation function");
                }
            }
            Method method = builtInMethod.method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), method.getName(), acc, Expressions.unbox(arg));
            this.accAdvance(add, acc, next);
        }
    }

    static class FusionImplementor
    extends StrictAggImplementor {
        FusionImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement(Expressions.call(add.accumulator().get(0), BuiltInMethod.COLLECTION_ADDALL.method, add.arguments().get(0))));
        }
    }

    static class IntersectionImplementor
    extends StrictAggImplementor {
        IntersectionImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), Expressions.constant(null))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            BlockBuilder accumulatorIsNull = new BlockBuilder();
            accumulatorIsNull.add(Expressions.statement(Expressions.assign(add.accumulator().get(0), Expressions.new_(ArrayList.class))));
            accumulatorIsNull.add(Expressions.statement(Expressions.call(add.accumulator().get(0), BuiltInMethod.COLLECTION_ADDALL.method, add.arguments().get(0))));
            BlockBuilder accumulatorNotNull = new BlockBuilder();
            accumulatorNotNull.add(Expressions.statement(Expressions.call(add.accumulator().get(0), BuiltInMethod.COLLECTION_RETAIN_ALL.method, add.arguments().get(0))));
            add.currentBlock().add(Expressions.ifThenElse((Expression)Expressions.equal(add.accumulator().get(0), Expressions.constant(null)), (Node)accumulatorIsNull.toBlock(), (Node)accumulatorNotNull.toBlock()));
        }
    }

    static class ListaggImplementor
    extends StrictAggImplementor {
        ListaggImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), NULL_EXPR)));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression accValue = add.accumulator().get(0);
            Expression arg0 = add.arguments().get(0);
            ConstantExpression arg1 = add.arguments().size() == 2 ? add.arguments().get(1) : COMMA_EXPR;
            Expression result = Expressions.condition(Expressions.equal(NULL_EXPR, accValue), arg0, Expressions.call(BuiltInMethod.STRING_CONCAT.method, accValue, Expressions.call(BuiltInMethod.STRING_CONCAT.method, arg1, arg0)));
            add.currentBlock().add(Expressions.statement(Expressions.assign(accValue, result)));
        }
    }

    static class CollectImplementor
    extends StrictAggImplementor {
        CollectImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement(Expressions.call(add.accumulator().get(0), BuiltInMethod.COLLECTION_ADD.method, add.arguments().get(0))));
        }
    }

    static class SingleValueImplementor
    implements AggImplementor {
        SingleValueImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Arrays.asList(Boolean.TYPE, info.returnType());
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(0), Expressions.constant(false))));
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(1), RexImpTable.getDefaultValue(acc.get(1).getType()))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            Expression flag = acc.get(0);
            add.currentBlock().add(Expressions.ifThen(flag, Expressions.throw_(Expressions.new_(IllegalStateException.class, new Expression[]{Expressions.constant("more than one value in agg " + info.aggregation())}))));
            add.currentBlock().add(Expressions.statement(Expressions.assign(flag, Expressions.constant(true))));
            add.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(1), add.arguments().get(0))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return EnumUtils.convert(result.accumulator().get(1), info.returnType());
        }
    }

    static class MinMaxImplementor
    extends StrictAggImplementor {
        MinMaxImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            boolean isMin;
            Expression acc = reset.accumulator().get(0);
            Primitive p = Primitive.of(acc.getType());
            boolean bl = isMin = SqlStdOperatorTable.MIN == info.aggregation();
            Object inf = p == null ? null : (isMin ? p.max : p.min);
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc, Expressions.constant(inf, acc.getType()))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            SqlAggFunction aggregation;
            Expression acc = add.accumulator().get(0);
            Expression arg = add.arguments().get(0);
            Method method = ((aggregation = info.aggregation()) == SqlStdOperatorTable.MIN ? BuiltInMethod.LESSER : BuiltInMethod.GREATER).method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), method.getName(), acc, Expressions.unbox(arg));
            this.accAdvance(add, acc, next);
        }
    }

    static class SumImplementor
    extends StrictAggImplementor {
        SumImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            ConstantExpression start = info.returnType() == BigDecimal.class ? Expressions.constant(BigDecimal.ZERO) : Expressions.constant(0);
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), start)));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression acc = add.accumulator().get(0);
            Expression next = info.returnType() == BigDecimal.class ? Expressions.call(acc, "add", add.arguments().get(0)) : Expressions.add(acc, EnumUtils.convert(add.arguments().get(0), acc.type));
            this.accAdvance(add, acc, next);
        }

        @Override
        public Expression implementNotNullResult(AggContext info, AggResultContext result) {
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountWinImplementor
    extends StrictWinAggImplementor {
        boolean justFrameRowCount;

        CountWinImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            boolean hasNullable = false;
            for (RelDataType relDataType : info.parameterRelTypes()) {
                if (!relDataType.isNullable()) continue;
                hasNullable = true;
                break;
            }
            if (!hasNullable) {
                this.justFrameRowCount = true;
                return Collections.emptyList();
            }
            return super.getNotNullState(info);
        }

        @Override
        public void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            if (this.justFrameRowCount) {
                return;
            }
            add.currentBlock().add(Expressions.statement(Expressions.postIncrementAssign(add.accumulator().get(0))));
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            if (this.justFrameRowCount) {
                return result.getFrameRowCount();
            }
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountImplementor
    extends StrictAggImplementor {
        CountImplementor() {
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement(Expressions.postIncrementAssign(add.accumulator().get(0))));
        }
    }

    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor(x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NULL: 
                        case NOT_POSSIBLE: 
                        case FALSE: 
                        case TRUE: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return EnumUtils.convert(x, Primitive.ofBox((Type)x.getType()).primitiveClass);
                        }
                    }
                }
            }
            switch (this) {
                case NULL: 
                case NOT_POSSIBLE: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call(BuiltInMethod.IS_TRUE.method, x);
                }
                case TRUE: {
                    return Expressions.call(BuiltInMethod.IS_NOT_FALSE.method, x);
                }
                case IS_NULL: {
                    return Expressions.equal(x, NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual(x, NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }
}

