/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.AvaticaSite;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.Helper;
import org.apache.calcite.avatica.InternalProperty;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalcitePreparedStatement;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteStatement;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.BaseQueryable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.DelegatingTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.LongSchemaVersion;
import org.apache.calcite.server.CalciteServer;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.advise.SqlAdvisorValidator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.RelRunner;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Util;

abstract class CalciteConnectionImpl
extends AvaticaConnection
implements CalciteConnection,
QueryProvider {
    public final JavaTypeFactory typeFactory;
    final CalciteSchema rootSchema;
    final Function0<CalcitePrepare> prepareFactory;
    final CalciteServer server = new CalciteServerImpl();
    static final AvaticaConnection.Trojan TROJAN = CalciteConnectionImpl.createTrojan();

    protected CalciteConnectionImpl(Driver driver, AvaticaFactory factory, String url, Properties info, CalciteSchema rootSchema, JavaTypeFactory typeFactory) {
        super(driver, factory, url, info);
        CalciteConnectionConfigImpl cfg = new CalciteConnectionConfigImpl(info);
        this.prepareFactory = driver.prepareFactory;
        if (typeFactory != null) {
            this.typeFactory = typeFactory;
        } else {
            RelDataTypeSystem typeSystem = cfg.typeSystem(RelDataTypeSystem.class, RelDataTypeSystem.DEFAULT);
            if (cfg.conformance().shouldConvertRaggedUnionTypesToVarying()) {
                typeSystem = new DelegatingTypeSystem(typeSystem){

                    @Override
                    public boolean shouldConvertRaggedUnionTypesToVarying() {
                        return true;
                    }
                };
            }
            this.typeFactory = new JavaTypeFactoryImpl(typeSystem);
        }
        this.rootSchema = Objects.requireNonNull(rootSchema != null ? rootSchema : CalciteSchema.createRootSchema(true));
        Preconditions.checkArgument(this.rootSchema.isRoot(), "must be root schema");
        this.properties.put(InternalProperty.CASE_SENSITIVE, cfg.caseSensitive());
        this.properties.put(InternalProperty.UNQUOTED_CASING, cfg.unquotedCasing());
        this.properties.put(InternalProperty.QUOTED_CASING, cfg.quotedCasing());
        this.properties.put(InternalProperty.QUOTING, cfg.quoting());
    }

    CalciteMetaImpl meta() {
        return (CalciteMetaImpl)this.meta;
    }

    @Override
    public CalciteConnectionConfig config() {
        return new CalciteConnectionConfigImpl(this.info);
    }

    @Override
    public CalcitePrepare.Context createPrepareContext() {
        return new ContextImpl(this);
    }

    void init() {
        MaterializationService service = MaterializationService.instance();
        for (CalciteSchema.LatticeEntry e : Schemas.getLatticeEntries(this.rootSchema)) {
            Lattice lattice = e.getLattice();
            for (Lattice.Tile tile : lattice.computeTiles()) {
                service.defineTile(lattice, tile.bitSet(), tile.measures, e.schema, true, true);
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == RelRunner.class) {
            return iface.cast(rel -> {
                try {
                    return this.prepareStatement_(CalcitePrepare.Query.of(rel), 1003, 1007, this.getHoldability());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return super.unwrap(iface);
    }

    @Override
    public CalciteStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return (CalciteStatement)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CalcitePreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CalcitePrepare.Query query = CalcitePrepare.Query.of(sql);
        return this.prepareStatement_(query, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private CalcitePreparedStatement prepareStatement_(CalcitePrepare.Query<?> query, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            CalcitePrepare.CalciteSignature<?> signature = this.parseQuery(query, this.createPrepareContext(), -1L);
            CalcitePreparedStatement calcitePreparedStatement = (CalcitePreparedStatement)this.factory.newPreparedStatement(this, null, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.server.getStatement(calcitePreparedStatement.handle).setSignature(signature);
            return calcitePreparedStatement;
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + query.sql + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> CalcitePrepare.CalciteSignature<T> parseQuery(CalcitePrepare.Query<T> query, CalcitePrepare.Context prepareContext, long maxRowCount) {
        CalcitePrepare.Dummy.push(prepareContext);
        try {
            CalcitePrepare prepare = this.prepareFactory.apply();
            CalcitePrepare.CalciteSignature<T> calciteSignature = prepare.prepareSql(prepareContext, query, (Type)((Object)Object[].class), maxRowCount);
            return calciteSignature;
        }
        finally {
            CalcitePrepare.Dummy.pop(prepareContext);
        }
    }

    @Override
    public AtomicBoolean getCancelFlag(Meta.StatementHandle handle) throws NoSuchStatementException {
        CalciteServerStatement serverStatement = this.server.getStatement(handle);
        return ((CalciteServerStatementImpl)serverStatement).cancelFlag;
    }

    @Override
    public SchemaPlus getRootSchema() {
        return this.rootSchema.plus();
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public Properties getProperties() {
        return this.info;
    }

    @Override
    public <T> Queryable<T> createQuery(Expression expression, Class<T> rowType) {
        return new CalciteQueryable(this, rowType, expression);
    }

    @Override
    public <T> Queryable<T> createQuery(Expression expression, Type rowType) {
        return new CalciteQueryable(this, rowType, expression);
    }

    @Override
    public <T> T execute(Expression expression, Type type) {
        return null;
    }

    @Override
    public <T> T execute(Expression expression, Class<T> type) {
        return null;
    }

    @Override
    public <T> Enumerator<T> executeQuery(Queryable<T> queryable) {
        try {
            CalciteStatement statement = (CalciteStatement)this.createStatement();
            CalcitePrepare.CalciteSignature<T> signature = statement.prepare(queryable);
            return this.enumerable(statement.handle, signature).enumerator();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Enumerable<T> enumerable(Meta.StatementHandle handle, CalcitePrepare.CalciteSignature<T> signature) throws SQLException {
        AtomicBoolean cancelFlag;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        AvaticaStatement statement = this.lookupStatement(handle);
        List<TypedValue> parameterValues = TROJAN.getParameterValues(statement);
        if (MetaImpl.checkParameterValueHasNull(parameterValues)) {
            throw new SQLException("exception while executing query: unbound parameter");
        }
        Ord.forEach(parameterValues, (e, i) -> map.put("?" + i, e.toLocal()));
        map.putAll(signature.internalParameters);
        try {
            cancelFlag = this.getCancelFlag(handle);
        }
        catch (NoSuchStatementException e2) {
            throw new RuntimeException(e2);
        }
        map.put(DataContext.Variable.CANCEL_FLAG.camelName, cancelFlag);
        int queryTimeout = statement.getQueryTimeout();
        if (queryTimeout > 0 && queryTimeout < 2147483) {
            map.put(DataContext.Variable.TIMEOUT.camelName, (long)queryTimeout * 1000L);
        }
        DataContext dataContext = this.createDataContext(map, signature.rootSchema);
        return signature.enumerable(dataContext);
    }

    public DataContext createDataContext(Map<String, Object> parameterValues, CalciteSchema rootSchema) {
        if (this.config().spark()) {
            return new SlimDataContext();
        }
        return new DataContextImpl(this, parameterValues, rootSchema);
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    static class CalciteServerStatementImpl
    implements CalciteServerStatement {
        private final CalciteConnectionImpl connection;
        private Iterator<Object> iterator;
        private Meta.Signature signature;
        private final AtomicBoolean cancelFlag = new AtomicBoolean();

        CalciteServerStatementImpl(CalciteConnectionImpl connection) {
            this.connection = Objects.requireNonNull(connection);
        }

        @Override
        public CalcitePrepare.Context createPrepareContext() {
            return this.connection.createPrepareContext();
        }

        @Override
        public CalciteConnection getConnection() {
            return this.connection;
        }

        @Override
        public void setSignature(Meta.Signature signature) {
            this.signature = signature;
        }

        @Override
        public Meta.Signature getSignature() {
            return this.signature;
        }

        @Override
        public Iterator<Object> getResultSet() {
            return this.iterator;
        }

        @Override
        public void setResultSet(Iterator<Object> iterator) {
            this.iterator = iterator;
        }
    }

    private static class SlimDataContext
    implements DataContext,
    Serializable {
        private SlimDataContext() {
        }

        @Override
        public SchemaPlus getRootSchema() {
            return null;
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return null;
        }

        @Override
        public Object get(String name) {
            return null;
        }
    }

    static class ContextImpl
    implements CalcitePrepare.Context {
        private final CalciteConnectionImpl connection;
        private final CalciteSchema mutableRootSchema;
        private final CalciteSchema rootSchema;

        ContextImpl(CalciteConnectionImpl connection) {
            this.connection = Objects.requireNonNull(connection);
            long now = System.currentTimeMillis();
            LongSchemaVersion schemaVersion = new LongSchemaVersion(now);
            this.mutableRootSchema = connection.rootSchema;
            this.rootSchema = this.mutableRootSchema.createSnapshot(schemaVersion);
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.connection.typeFactory;
        }

        @Override
        public CalciteSchema getRootSchema() {
            return this.rootSchema;
        }

        @Override
        public CalciteSchema getMutableRootSchema() {
            return this.mutableRootSchema;
        }

        @Override
        public List<String> getDefaultSchemaPath() {
            String schemaName;
            try {
                schemaName = this.connection.getSchema();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return schemaName == null ? ImmutableList.of() : ImmutableList.of(schemaName);
        }

        @Override
        public List<String> getObjectPath() {
            return null;
        }

        @Override
        public CalciteConnectionConfig config() {
            return this.connection.config();
        }

        @Override
        public DataContext getDataContext() {
            return this.connection.createDataContext(ImmutableMap.of(), this.rootSchema);
        }

        @Override
        public RelRunner getRelRunner() {
            RelRunner runner;
            try {
                runner = this.connection.unwrap(RelRunner.class);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (runner == null) {
                throw new UnsupportedOperationException();
            }
            return runner;
        }

        @Override
        public CalcitePrepare.SparkHandler spark() {
            boolean enable = this.config().spark();
            return CalcitePrepare.Dummy.getSparkHandler(enable);
        }
    }

    static class DataContextImpl
    implements DataContext {
        private final ImmutableMap<Object, Object> map;
        private final CalciteSchema rootSchema;
        private final QueryProvider queryProvider;
        private final JavaTypeFactory typeFactory;

        DataContextImpl(CalciteConnectionImpl connection, Map<String, Object> parameters, CalciteSchema rootSchema) {
            long localOffset;
            this.queryProvider = connection;
            this.typeFactory = connection.getTypeFactory();
            this.rootSchema = rootSchema;
            Holder<Long> timeHolder = Holder.of(System.currentTimeMillis());
            Hook.CURRENT_TIME.run(timeHolder);
            long time = timeHolder.get();
            TimeZone timeZone = connection.getTimeZone();
            long currentOffset = localOffset = (long)timeZone.getOffset(time);
            String user = "sa";
            String systemUser = System.getProperty("user.name");
            String localeName = connection.config().locale();
            Locale locale = localeName != null ? Util.parseLocale(localeName) : Locale.ROOT;
            Holder<Object[]> streamHolder = Holder.of(new Object[]{System.in, System.out, System.err});
            Hook.STANDARD_STREAMS.run(streamHolder);
            ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
            builder.put(DataContext.Variable.UTC_TIMESTAMP.camelName, time).put(DataContext.Variable.CURRENT_TIMESTAMP.camelName, time + currentOffset).put(DataContext.Variable.LOCAL_TIMESTAMP.camelName, time + localOffset).put(DataContext.Variable.TIME_ZONE.camelName, (Long)((Object)timeZone)).put(DataContext.Variable.USER.camelName, (Long)((Object)"sa")).put(DataContext.Variable.SYSTEM_USER.camelName, (Long)((Object)systemUser)).put(DataContext.Variable.LOCALE.camelName, (Long)((Object)locale)).put(DataContext.Variable.STDIN.camelName, (Long)streamHolder.get()[0]).put(DataContext.Variable.STDOUT.camelName, (Long)streamHolder.get()[1]).put(DataContext.Variable.STDERR.camelName, (Long)streamHolder.get()[2]);
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                Object e = entry.getValue();
                if (e == null) {
                    e = AvaticaSite.DUMMY_VALUE;
                }
                builder.put(entry.getKey(), e);
            }
            this.map = builder.build();
        }

        @Override
        public synchronized Object get(String name) {
            Object o = this.map.get(name);
            if (o == AvaticaSite.DUMMY_VALUE) {
                return null;
            }
            if (o == null && DataContext.Variable.SQL_ADVISOR.camelName.equals(name)) {
                return this.getSqlAdvisor();
            }
            return o;
        }

        private SqlAdvisor getSqlAdvisor() {
            String schemaName;
            CalciteConnectionImpl con = (CalciteConnectionImpl)this.queryProvider;
            try {
                schemaName = con.getSchema();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            ImmutableList<String> schemaPath = schemaName == null ? ImmutableList.of() : ImmutableList.of(schemaName);
            SqlAdvisorValidator validator = new SqlAdvisorValidator(SqlStdOperatorTable.instance(), new CalciteCatalogReader(this.rootSchema, schemaPath, this.typeFactory, con.config()), this.typeFactory, SqlValidator.Config.DEFAULT);
            CalciteConnectionConfig config = con.config();
            SqlParser.Config parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive()).build();
            return new SqlAdvisor(validator, parserConfig);
        }

        @Override
        public SchemaPlus getRootSchema() {
            return this.rootSchema == null ? null : this.rootSchema.plus();
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return this.queryProvider;
        }
    }

    static class RootSchema
    extends AbstractSchema {
        RootSchema() {
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, new Expression[0]);
        }
    }

    private static class CalciteServerImpl
    implements CalciteServer {
        final Map<Integer, CalciteServerStatement> statementMap = new HashMap<Integer, CalciteServerStatement>();

        private CalciteServerImpl() {
        }

        @Override
        public void removeStatement(Meta.StatementHandle h2) {
            this.statementMap.remove(h2.id);
        }

        @Override
        public void addStatement(CalciteConnection connection, Meta.StatementHandle h2) {
            CalciteConnectionImpl c = (CalciteConnectionImpl)connection;
            CalciteServerStatement previous = this.statementMap.put(h2.id, new CalciteServerStatementImpl(c));
            if (previous != null) {
                throw new AssertionError();
            }
        }

        @Override
        public CalciteServerStatement getStatement(Meta.StatementHandle h2) throws NoSuchStatementException {
            CalciteServerStatement statement = this.statementMap.get(h2.id);
            if (statement == null) {
                throw new NoSuchStatementException(h2);
            }
            return statement;
        }
    }

    static class CalciteQueryable<T>
    extends BaseQueryable<T> {
        CalciteQueryable(CalciteConnection connection, Type elementType, Expression expression) {
            super(connection, elementType, expression);
        }

        public CalciteConnection getConnection() {
            return (CalciteConnection)this.provider;
        }
    }
}

