/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.prepare.HeavyDBSqlAdvisorValidator;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;

class HeavyDBSqlAdvisor
extends SqlAdvisor {
    private HeavyDBSqlAdvisorValidator permissionsAwareValidator;

    public HeavyDBSqlAdvisor(HeavyDBSqlAdvisorValidator validator, SqlParser.Config parserConfig) {
        super(validator, parserConfig);
        this.permissionsAwareValidator = validator;
    }

    @Override
    public List<SqlMoniker> getCompletionHints(String sql, int cursor, String[] replaced) {
        List<SqlMoniker> result;
        int wordEnd;
        int wordStart;
        boolean quoted = false;
        for (wordStart = cursor; wordStart > 0 && Character.isJavaIdentifierPart(sql.charAt(wordStart - 1)); --wordStart) {
        }
        if (wordStart > 0 && sql.charAt(wordStart - 1) == '\"') {
            quoted = true;
            --wordStart;
        }
        if (wordStart < 0) {
            return Collections.emptyList();
        }
        for (wordEnd = cursor; wordEnd < sql.length() && Character.isJavaIdentifierPart(sql.charAt(wordEnd)); ++wordEnd) {
        }
        if (quoted && wordEnd < sql.length() && sql.charAt(wordEnd) == '\"') {
            ++wordEnd;
        }
        String word = replaced[0] = sql.substring(wordStart, cursor);
        if (wordStart < wordEnd) {
            sql = sql.substring(0, wordStart) + sql.substring(wordEnd, sql.length());
        }
        List<SqlMoniker> completionHints = HeavyDBSqlAdvisor.stripDatabaseFromTableHints(this.getCompletionHints0(sql, wordStart));
        if (this.permissionsAwareValidator.hasViolatedTablePermissions()) {
            return new ArrayList<SqlMoniker>();
        }
        completionHints = this.applyPermissionsToTableHints(completionHints);
        if (word.length() > 0) {
            result = new ArrayList<SqlMoniker>();
            if (quoted) {
                word = word.substring(1);
                for (SqlMoniker hint : completionHints) {
                    String cname = hint.toString();
                    if (!cname.startsWith(word)) continue;
                    result.add(hint);
                }
            } else {
                for (SqlMoniker hint : completionHints) {
                    String cname = hint.toString();
                    if (cname.length() < word.length() || !cname.substring(0, word.length()).equalsIgnoreCase(word)) continue;
                    result.add(hint);
                }
            }
        } else {
            result = completionHints;
        }
        return result;
    }

    private static List<SqlMoniker> stripDatabaseFromTableHints(List<SqlMoniker> completionHints) {
        ArrayList<SqlMoniker> strippedCompletionHints = new ArrayList<SqlMoniker>();
        for (SqlMoniker hint : completionHints) {
            if (hint.getType() == SqlMonikerType.TABLE && hint.getFullyQualifiedNames().size() == 2) {
                String tableName = hint.getFullyQualifiedNames().get(1);
                strippedCompletionHints.add(new SqlMonikerImpl(tableName, SqlMonikerType.TABLE));
                continue;
            }
            strippedCompletionHints.add(hint);
        }
        return strippedCompletionHints;
    }

    private List<SqlMoniker> applyPermissionsToTableHints(List<SqlMoniker> completionHints) {
        ArrayList<SqlMoniker> completionHintsWithPermissions = new ArrayList<SqlMoniker>();
        for (SqlMoniker hint : completionHints) {
            if (hint.getType() == SqlMonikerType.TABLE) {
                assert (hint.getFullyQualifiedNames().size() == 1);
                if (this.permissionsAwareValidator.tableViolatesPermissions(hint.toString())) continue;
                completionHintsWithPermissions.add(hint);
                continue;
            }
            completionHintsWithPermissions.add(hint);
        }
        return completionHintsWithPermissions;
    }
}

