/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.advise.SqlAdvisorValidator;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Util;

class HeavyDBSqlAdvisorValidator
extends SqlAdvisorValidator {
    private List<String> visibleTables;
    private boolean violatedTablePermissions = false;

    HeavyDBSqlAdvisorValidator(List<String> visibleTables, SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config) {
        super(opTab, catalogReader, typeFactory, config);
        this.visibleTables = visibleTables;
    }

    @Override
    protected void validateGroupClause(SqlSelect select) {
        try {
            SqlNodeList groupList = select.getGroup();
            if (groupList == null) {
                return;
            }
            for (SqlNode groupItem : groupList) {
                SqlValidatorScope groupScope = this.getGroupScope(select);
                groupItem.validate(this, groupScope);
            }
            super.validateGroupClause(select);
        }
        catch (CalciteException e) {
            Util.swallow(e, TRACER);
        }
    }

    @Override
    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        try {
            if (node.getKind() == SqlKind.IDENTIFIER && this.tableViolatesPermissions(node.toString())) {
                this.violatedTablePermissions = true;
            }
            super.validateFrom(node, targetRowType, scope);
        }
        catch (CalciteException e) {
            Util.swallow(e, TRACER);
        }
    }

    boolean tableViolatesPermissions(String tableName) {
        return !tableName.isEmpty() && Character.isAlphabetic(tableName.charAt(0)) && this.visibleTables.stream().noneMatch(visibleTableName -> visibleTableName.equalsIgnoreCase(tableName));
    }

    boolean hasViolatedTablePermissions() {
        return this.violatedTablePermissions;
    }
}

