/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;

public class RelMdNodeTypes
implements MetadataHandler<BuiltInMetadata.NodeTypes> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.NODE_TYPES.method, new RelMdNodeTypes());

    @Override
    public MetadataDef<BuiltInMetadata.NodeTypes> getDef() {
        return BuiltInMetadata.NodeTypes.DEF;
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelNode rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, RelNode.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.getNodeTypes(rel.getCurrentRel());
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelSubset rel, RelMetadataQuery mq) {
        return mq.getNodeTypes(Util.first(rel.getBest(), rel.getOriginal()));
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Union rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Union.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Intersect rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Intersect.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Minus rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Minus.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Filter rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Filter.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Calc rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Calc.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Project rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Project.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Sort rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Sort.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Join rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Join.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Aggregate rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Aggregate.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(TableScan rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, TableScan.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Values rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Values.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(TableModify rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, TableModify.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Exchange rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Exchange.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Sample rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Sample.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Correlate rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Correlate.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Window rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Window.class, mq);
    }

    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(Match rel, RelMetadataQuery mq) {
        return RelMdNodeTypes.getNodeTypes(rel, Match.class, mq);
    }

    private static Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelNode rel, Class<? extends RelNode> c, RelMetadataQuery mq) {
        ArrayListMultimap<Class<? extends RelNode>, RelNode> nodeTypeCount = ArrayListMultimap.create();
        for (RelNode input : rel.getInputs()) {
            Multimap<Class<? extends RelNode>, RelNode> partialNodeTypeCount = mq.getNodeTypes(input);
            if (partialNodeTypeCount == null) {
                return null;
            }
            nodeTypeCount.putAll(partialNodeTypeCount);
        }
        nodeTypeCount.put(c, rel);
        return nodeTypeCount;
    }
}

