/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;

public class SqlTumbleTableFunction
extends SqlWindowTableFunction {
    public SqlTumbleTableFunction() {
        super(SqlKind.TUMBLE.name());
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(3, 4);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType type3;
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        SqlNode operand1 = callBinding.operand(1);
        if (operand1.getKind() != SqlKind.DESCRIPTOR) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand1).getOperandList());
        RelDataType type2 = validator.getValidatedNodeType(callBinding.operand(2));
        if (!SqlTypeUtil.isInterval(type2)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        if (callBinding.getOperandCount() > 3 && !SqlTypeUtil.isInterval(type3 = validator.getValidatedNodeType(callBinding.operand(3)))) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col1, col2 ...), datetime interval[, datetime interval])";
    }
}

