/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.AggChecker;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;

public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;
    private SqlValidatorUtil.GroupAnalyzer groupAnalyzer;
    public final Supplier<Resolved> resolved = Suppliers.memoize(this::resolve)::get;

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select, boolean distinct) {
        super(selectScope);
        this.select = select;
        this.distinct = distinct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolved resolve() {
        assert (this.groupAnalyzer == null) : "resolve already in progress";
        this.groupAnalyzer = new SqlValidatorUtil.GroupAnalyzer();
        try {
            ImmutableList.Builder<ImmutableList<ImmutableBitSet>> builder = ImmutableList.builder();
            if (this.select.getGroup() != null) {
                SqlNodeList groupList = this.select.getGroup();
                for (SqlNode sqlNode : groupList) {
                    SqlValidatorUtil.analyzeGroupItem(this, this.groupAnalyzer, builder, sqlNode);
                }
            }
            TreeMap<ImmutableBitSet, Integer> flatGroupSetCount = Maps.newTreeMap(ImmutableBitSet.COMPARATOR);
            for (List list : Linq4j.product(builder.build())) {
                ImmutableBitSet set = ImmutableBitSet.union(list);
                flatGroupSetCount.put(set, flatGroupSetCount.getOrDefault(set, 0) + 1);
            }
            if (flatGroupSetCount.isEmpty()) {
                flatGroupSetCount.put(ImmutableBitSet.of(), 1);
            }
            Resolved resolved = new Resolved(this.groupAnalyzer.extraExprs, this.groupAnalyzer.groupExprs, flatGroupSetCount.keySet(), flatGroupSetCount, this.groupAnalyzer.groupExprProjection);
            return resolved;
        }
        finally {
            this.groupAnalyzer = null;
        }
    }

    private Pair<ImmutableList<SqlNode>, ImmutableList<SqlNode>> getGroupExprs() {
        if (this.distinct) {
            assert (this.select.isDistinct());
            ImmutableList.Builder groupExprs = ImmutableList.builder();
            SelectScope selectScope = (SelectScope)this.parent;
            for (SqlNode selectItem : selectScope.getExpandedSelectList()) {
                groupExprs.add(SqlUtil.stripAs(selectItem));
            }
            return Pair.of(ImmutableList.of(), groupExprs.build());
        }
        if (this.select.getGroup() != null) {
            if (this.groupAnalyzer != null) {
                return Pair.of(ImmutableList.of(), ImmutableList.copyOf(this.groupAnalyzer.groupExprs));
            }
            Resolved resolved = this.resolved.get();
            return Pair.of(resolved.extraExprList, resolved.groupExprList);
        }
        return Pair.of(ImmutableList.of(), ImmutableList.of());
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        Resolved r = this.resolved.get();
        for (Ord<SqlNode> groupExpr : Ord.zip(r.groupExprList)) {
            if (!((SqlNode)groupExpr.e).equalsDeep(node, Litmus.IGNORE) || !r.isNullable(groupExpr.i)) continue;
            return this.validator.getTypeFactory().createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        Pair<ImmutableList<SqlNode>, ImmutableList<SqlNode>> pair = this.getGroupExprs();
        AggChecker aggChecker = new AggChecker(this.validator, this, (List)pair.left, (List)pair.right, this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public static class Resolved {
        public final ImmutableList<SqlNode> extraExprList;
        public final ImmutableList<SqlNode> groupExprList;
        public final ImmutableBitSet groupSet;
        public final ImmutableList<ImmutableBitSet> groupSets;
        public final Map<ImmutableBitSet, Integer> groupSetCount;
        public final Map<Integer, Integer> groupExprProjection;

        Resolved(List<SqlNode> extraExprList, List<SqlNode> groupExprList, Iterable<ImmutableBitSet> groupSets, Map<ImmutableBitSet, Integer> groupSetCount, Map<Integer, Integer> groupExprProjection) {
            this.extraExprList = ImmutableList.copyOf(extraExprList);
            this.groupExprList = ImmutableList.copyOf(groupExprList);
            this.groupSet = ImmutableBitSet.range(groupExprList.size());
            this.groupSets = ImmutableList.copyOf(groupSets);
            this.groupSetCount = ImmutableMap.copyOf(groupSetCount);
            this.groupExprProjection = ImmutableMap.copyOf(groupExprProjection);
        }

        public boolean isNullable(int i) {
            return i < this.groupExprList.size() && !ImmutableBitSet.allContain(this.groupSets, i);
        }

        public boolean isGroupingExpr(SqlNode operand) {
            return this.lookupGroupingExpr(operand) >= 0;
        }

        public int lookupGroupingExpr(SqlNode operand) {
            for (Ord<SqlNode> groupExpr : Ord.zip(this.groupExprList)) {
                if (!operand.equalsDeep((SqlNode)groupExpr.e, Litmus.IGNORE)) continue;
                return groupExpr.i;
            }
            return -1;
        }
    }
}

