/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.util.BlackholeMap;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.CastingList;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Filterator;
import org.apache.calcite.util.Pair;
import org.slf4j.Logger;

public class Util {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String FILE_TIMESTAMP_FORMAT = "yyyy-MM-dd_HH_mm_ss";
    private static final Pattern JAVA_ID_PATTERN = Pattern.compile("[a-zA-Z_$][a-zA-Z0-9$]*");
    private static final Charset DEFAULT_CHARSET = Charset.forName(CalciteSystemProperty.DEFAULT_CHARSET.value());
    private static final LoadingCache<Class, Map<String, Enum>> ENUM_CONSTANTS = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(Util::enumConstants));

    private Util() {
    }

    public static boolean isSingleValue(SqlCall call) {
        if (call.getOperator() instanceof SqlAggFunction) {
            return true;
        }
        if (call.getOperator() instanceof SqlValuesOperator || call.getOperator() instanceof SqlRowOperator) {
            List<SqlNode> operands = call.getOperandList();
            if (operands.size() == 1) {
                SqlNode operand = operands.get(0);
                if (operand instanceof SqlLiteral) {
                    return true;
                }
                if (operand instanceof SqlCall) {
                    return Util.isSingleValue((SqlCall)operand);
                }
            }
            return false;
        }
        boolean isScalar = true;
        for (SqlNode operand : call.getOperandList()) {
            if (operand instanceof SqlLiteral || operand instanceof SqlCall && Util.isSingleValue((SqlCall)operand)) continue;
            isScalar = false;
            break;
        }
        return isScalar;
    }

    public static void discard(Object o) {
    }

    public static void discard(int i) {
    }

    public static void discard(boolean b) {
    }

    public static void discard(double d) {
    }

    public static void swallow(Throwable e, Logger logger) {
        if (logger != null) {
            logger.debug("Discarding exception", e);
        }
    }

    public static <T> boolean equalShallow(List<? extends T> list0, List<? extends T> list1) {
        if (list0.size() != list1.size()) {
            return false;
        }
        for (int i = 0; i < list0.size(); ++i) {
            if (list0.get(i) == list1.get(i)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static int hash(int i, int j) {
        return i << 4 ^ j;
    }

    @Deprecated
    public static int hash(int h2, Object o) {
        int k = o == null ? 0 : o.hashCode();
        return (h2 << 4 | h2) ^ k;
    }

    @Deprecated
    public static int hashArray(int h2, Object[] a) {
        return h2 ^ Arrays.hashCode(a);
    }

    @Deprecated
    public static int hashCode(double v) {
        long bits = Double.doubleToLongBits(v);
        return (int)(bits ^ bits >>> 32);
    }

    public static <T> Set<T> minus(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty()) {
            return set1;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet<T> set = new HashSet<T>(set1);
        set.removeAll(set2);
        return set;
    }

    public static double nLogN(double d) {
        return d < Math.E ? d : d * Math.log(d);
    }

    public static void print(PrintWriter pw, Object o) {
        Util.print(pw, o, 0);
    }

    public static void print(PrintWriter pw, Object o, int indent) {
        if (o == null) {
            pw.print("null");
            return;
        }
        Class<?> clazz = o.getClass();
        if (o instanceof String) {
            Util.printJavaString(pw, (String)o, true);
        } else if (clazz == Integer.class || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Void.class) {
            pw.print(o.toString());
        } else if (clazz.isArray()) {
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                Util.discard(a);
            }
            int n = Array.getLength(o);
            pw.print("{");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    pw.println(",");
                } else {
                    pw.println();
                }
                for (int j = 0; j < indent; ++j) {
                    pw.print("\t");
                }
                Util.print(pw, Array.get(o, i), indent + 1);
            }
            pw.print("}");
        } else if (o instanceof Iterator) {
            pw.print(clazz.getName());
            Iterator iter = (Iterator)o;
            pw.print(" {");
            int i = 0;
            while (iter.hasNext()) {
                if (i++ > 0) {
                    pw.println(",");
                }
                Util.print(pw, iter.next(), indent + 1);
            }
            pw.print("}");
        } else if (o instanceof Enumeration) {
            pw.print(clazz.getName());
            Enumeration e = (Enumeration)o;
            pw.print(" {");
            int i = 0;
            while (e.hasMoreElements()) {
                if (i++ > 0) {
                    pw.println(",");
                }
                Util.print(pw, e.nextElement(), indent + 1);
            }
            pw.print("}");
        } else {
            pw.print(clazz.getName());
            pw.print(" {");
            Field[] fields = clazz.getFields();
            int printed = 0;
            for (Field field : fields) {
                Object val;
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (printed++ > 0) {
                    pw.println(",");
                } else {
                    pw.println();
                }
                for (int j = 0; j < indent; ++j) {
                    pw.print("\t");
                }
                pw.print(field.getName());
                pw.print("=");
                try {
                    val = field.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                Util.print(pw, val, indent + 1);
            }
            pw.print("}");
        }
    }

    public static void printJavaString(Appendable appendable, String s2, boolean nullMeansNull) {
        try {
            if (s2 == null) {
                if (nullMeansNull) {
                    appendable.append("null");
                }
            } else {
                String s1 = Util.replace(s2, "\\", "\\\\");
                String s22 = Util.replace(s1, "\"", "\\\"");
                String s3 = Util.replace(s22, "\n\r", "\\n");
                String s4 = Util.replace(s3, "\n", "\\n");
                String s5 = Util.replace(s4, "\r", "\\r");
                appendable.append('\"');
                appendable.append(s5);
                appendable.append('\"');
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("The specified appendable should not incur I/O.", ioe);
        }
    }

    public static void println(PrintWriter pw, Object o) {
        Util.print(pw, o, 0);
        pw.println();
    }

    public static String toScientificNotation(BigDecimal bd) {
        int truncateAt = 20;
        String unscaled = bd.unscaledValue().toString();
        if (bd.signum() < 0) {
            unscaled = unscaled.substring(1);
        }
        int len = unscaled.length();
        int scale = bd.scale();
        int e = len - scale - 1;
        StringBuilder ret = new StringBuilder();
        if (bd.signum() < 0) {
            ret.append('-');
        }
        unscaled = unscaled.substring(0, Math.min(20, len));
        ret.append(unscaled.charAt(0));
        if (scale == 0) {
            int i;
            for (i = unscaled.length(); i > 1 && unscaled.charAt(i - 1) == '0'; --i) {
            }
            unscaled = unscaled.substring(0, i);
        }
        if (unscaled.length() > 1) {
            ret.append(".");
            ret.append(unscaled.substring(1));
        }
        ret.append("E");
        ret.append(e);
        return ret.toString();
    }

    public static String replace(String s2, String find, String replace) {
        int found = s2.indexOf(find);
        if (found == -1) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length());
        int start = 0;
        while (true) {
            if (start < found) {
                sb.append(s2.charAt(start));
                ++start;
                continue;
            }
            if (found == s2.length()) break;
            sb.append(replace);
            found = s2.indexOf(find, start += find.length());
            if (found != -1) continue;
            found = s2.length();
        }
        return sb.toString();
    }

    @Deprecated
    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        String fs = System.getProperty("file.separator");
        if (fs.length() == 1) {
            char sep = fs.charAt(0);
            if (sep != '/') {
                path = path.replace(sep, '/');
            }
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
        }
        path = "file://" + path;
        return new URL(path);
    }

    @Deprecated
    public static String getFileTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat(FILE_TIMESTAMP_FORMAT, Locale.ROOT);
        return sdf.format(new Date());
    }

    public static String stripDoubleQuotes(String value) {
        assert (value.charAt(0) == '\"');
        assert (value.charAt(value.length() - 1) == '\"');
        String s5 = value.substring(1, value.length() - 1);
        String s4 = Util.replace(s5, "\\r", "\r");
        String s3 = Util.replace(s4, "\\n", "\n");
        String s2 = Util.replace(s3, "\\\"", "\"");
        String s1 = Util.replace(s2, "\\\\", "\\");
        return s1;
    }

    public static String toJavaId(String s2, int ordinal) {
        if (JAVA_ID_PATTERN.matcher(s2).matches()) {
            return "ID$" + ordinal + "$" + s2;
        }
        StringBuilder buf = new StringBuilder(s2.length() + 10);
        buf.append("ID$");
        buf.append(ordinal);
        buf.append("$");
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '_') {
                buf.append("__");
                continue;
            }
            if (c < '\u007f' && !Character.isISOControl(c) && (i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c))) {
                buf.append(c);
                continue;
            }
            buf.append("_");
            buf.append(Integer.toString(c, 16));
            buf.append("_");
        }
        return buf.toString();
    }

    public static boolean isValidJavaIdentifier(String s2) {
        int codePoint;
        if (s2.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s2.codePointAt(0))) {
            return false;
        }
        for (int i = 0; i < s2.length(); i += Character.charCount(codePoint)) {
            codePoint = s2.codePointAt(i);
            if (Character.isJavaIdentifierPart(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static String toLinux(String s2) {
        return s2.replace("\r\n", "\n");
    }

    @Deprecated
    public static <T> List<T> toList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static boolean isNullOrEmpty(String s2) {
        return null == s2 || s2.length() == 0;
    }

    public static <T> String commaList(List<T> list) {
        return Util.sepList(list, ", ");
    }

    public static <T> String sepList(List<T> list, String sep) {
        int max = list.size() - 1;
        switch (max) {
            case -1: {
                return "";
            }
            case 0: {
                return list.get(0).toString();
            }
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            buf.append(list.get(i));
            if (i == max) {
                return buf.toString();
            }
            buf.append(sep);
            ++i;
        }
    }

    public static Charset getDefaultCharset() {
        return DEFAULT_CHARSET;
    }

    @Deprecated
    public static Error newInternal() {
        return new AssertionError((Object)"(unknown cause)");
    }

    @Deprecated
    public static Error newInternal(String s2) {
        return new AssertionError((Object)s2);
    }

    @Deprecated
    public static Error newInternal(Throwable e) {
        return new AssertionError((Object)e);
    }

    public static Error newInternal(Throwable e, String s2) {
        return new AssertionError("Internal error: " + s2, e);
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Bug.upgrade("Remove when minimum Guava version is 20");
        Objects.requireNonNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static RuntimeException toUnchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    @Deprecated
    public static String getMessages(Throwable t) {
        StringBuilder sb = new StringBuilder();
        for (Throwable curr = t; curr != null; curr = curr.getCause()) {
            String msg;
            String string = msg = curr instanceof CalciteException || curr instanceof SQLException ? curr.getMessage() : curr.toString();
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(msg);
        }
        return sb.toString();
    }

    @Deprecated
    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    @Deprecated
    public static void pre(boolean b, String description) {
        if (!b) {
            throw new AssertionError((Object)("pre-condition failed: " + description));
        }
    }

    @Deprecated
    public static void post(boolean b, String description) {
        if (!b) {
            throw new AssertionError((Object)("post-condition failed: " + description));
        }
    }

    @Deprecated
    public static void permAssert(boolean b, String description) {
        if (!b) {
            throw new AssertionError((Object)("invariant violated: " + description));
        }
    }

    public static RuntimeException needToImplement(Object o) {
        String description = null;
        if (o != null) {
            description = o.getClass().toString() + ": " + o.toString();
        }
        throw new UnsupportedOperationException(description);
    }

    public static <T> T deprecated(T argument, boolean fail) {
        if (fail) {
            throw new UnsupportedOperationException();
        }
        return argument;
    }

    public static boolean contains(String[] a, int length, String s2) {
        for (int i = 0; i < length; ++i) {
            if (!a[i].equals(s2)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String readAllAsString(Reader reader) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        while ((n = reader.read(buf)) != -1) {
            sb.append(buf, 0, n);
        }
        return sb.toString();
    }

    @Deprecated
    public static void squelchJar(JarFile jar) {
        try {
            if (jar != null) {
                jar.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void squelchStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void squelchStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void squelchReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void squelchWriter(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void squelchStmt(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void squelchConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Deprecated
    public static String rtrim(String s2) {
        int n = s2.length() - 1;
        if (n >= 0) {
            if (s2.charAt(n) != ' ') {
                return s2;
            }
            while (--n >= 0) {
                if (s2.charAt(n) == ' ') continue;
                return s2.substring(0, n + 1);
            }
        }
        return "";
    }

    @Deprecated
    public static String rpad(String s2, int len) {
        if (s2.length() >= len) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2);
        while (sb.length() < len) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static <T> String toString(Iterable<T> iterable, String start, String sep, String end) {
        StringBuilder buf = new StringBuilder();
        buf.append(start);
        for (Ord<T> ord : Ord.zip(iterable)) {
            if (ord.i > 0) {
                buf.append(sep);
            }
            buf.append(ord.e);
        }
        buf.append(end);
        return buf.toString();
    }

    public static String lines(Iterable<String> strings) {
        return Util.toString(strings, "", "\n", "");
    }

    public static Iterable<String> tokenize(final String s2, final String delim) {
        return new Iterable<String>(){
            final StringTokenizer t;
            {
                this.t = new StringTokenizer(s2, delim);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return t.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return t.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public static String toPosix(TimeZone tz, boolean verbose) {
        String tzString;
        String patternString;
        Pattern pattern;
        Matcher matcher;
        StringBuilder buf = new StringBuilder();
        buf.append(tz.getDisplayName(false, 0, Locale.ROOT));
        Util.appendPosixTime(buf, tz.getRawOffset());
        int dstSavings = tz.getDSTSavings();
        if (dstSavings == 0) {
            return buf.toString();
        }
        buf.append(tz.getDisplayName(true, 0, Locale.ROOT));
        if (verbose || dstSavings != 3600000) {
            Util.appendPosixTime(buf, dstSavings);
        }
        if (!(matcher = (pattern = Pattern.compile(patternString = ".*,startMode=([0-9]*),startMonth=([0-9]*),startDay=([-0-9]*),startDayOfWeek=([0-9]*),startTime=([0-9]*),startTimeMode=([0-9]*),endMode=([0-9]*),endMonth=([0-9]*),endDay=([-0-9]*),endDayOfWeek=([0-9]*),endTime=([0-9]*),endTimeMode=([0-9]*).*")).matcher(tzString = tz.toString())).matches()) {
            throw new AssertionError((Object)("tz.toString not of expected format: " + tzString));
        }
        int j = 0;
        int startMode = Integer.valueOf(matcher.group(++j));
        int startMonth = Integer.valueOf(matcher.group(++j));
        int startDay = Integer.valueOf(matcher.group(++j));
        int startDayOfWeek = Integer.valueOf(matcher.group(++j));
        int startTime = Integer.valueOf(matcher.group(++j));
        int startTimeMode = Integer.valueOf(matcher.group(++j));
        int endMode = Integer.valueOf(matcher.group(++j));
        int endMonth = Integer.valueOf(matcher.group(++j));
        int endDay = Integer.valueOf(matcher.group(++j));
        int endDayOfWeek = Integer.valueOf(matcher.group(++j));
        int endTime = Integer.valueOf(matcher.group(++j));
        int endTimeMode = Integer.valueOf(matcher.group(++j));
        Util.appendPosixDaylightTransition(tz, buf, startMode, startDay, startMonth, startDayOfWeek, startTime, startTimeMode, verbose, false);
        Util.appendPosixDaylightTransition(tz, buf, endMode, endDay, endMonth, endDayOfWeek, endTime, endTimeMode, verbose, true);
        return buf.toString();
    }

    private static void appendPosixDaylightTransition(TimeZone tz, StringBuilder buf, int mode, int day, int month, int dayOfWeek, int time, int timeMode, boolean verbose, boolean isEnd) {
        buf.append(',');
        int week = day;
        switch (mode) {
            case 1: {
                throw Util.needToImplement(0);
            }
            case 3: {
                switch (day) {
                    case 1: {
                        week = 1;
                        break;
                    }
                    case 8: {
                        week = 2;
                        break;
                    }
                    case 15: {
                        week = 3;
                        break;
                    }
                    case 22: {
                        week = 4;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("POSIX timezone format cannot represent " + tz));
                    }
                }
            }
            case 2: {
                buf.append('M');
                buf.append(month + 1);
                buf.append('.');
                if (week == -1) {
                    week = 5;
                }
                buf.append(week);
                buf.append('.');
                buf.append(dayOfWeek - 1);
                break;
            }
            case 4: {
                throw Util.needToImplement(0);
            }
            default: {
                throw new AssertionError((Object)("unexpected value: " + mode));
            }
        }
        switch (timeMode) {
            case 0: {
                break;
            }
            case 1: {
                if (!isEnd) break;
                time += tz.getDSTSavings();
                break;
            }
            case 2: {
                time += tz.getRawOffset();
                if (!isEnd) break;
                time += tz.getDSTSavings();
            }
        }
        if (verbose || time != 0x6DDD00) {
            buf.append('/');
            Util.appendPosixTime(buf, time);
        }
    }

    private static void appendPosixTime(StringBuilder buf, int millis) {
        if (millis < 0) {
            buf.append('-');
            millis = -millis;
        }
        int hours = millis / 3600000;
        buf.append(hours);
        if ((millis -= hours * 3600000) == 0) {
            return;
        }
        buf.append(':');
        int minutes = millis / 60000;
        if (minutes < 10) {
            buf.append('0');
        }
        buf.append(minutes);
        if ((millis -= minutes * 60000) == 0) {
            return;
        }
        buf.append(':');
        int seconds = millis / 1000;
        if (seconds < 10) {
            buf.append('0');
        }
        buf.append(seconds);
    }

    public static Locale parseLocale(String localeString) {
        String[] strings = localeString.split("_");
        switch (strings.length) {
            case 1: {
                return new Locale(strings[0]);
            }
            case 2: {
                return new Locale(strings[0], strings[1]);
            }
            case 3: {
                return new Locale(strings[0], strings[1], strings[2]);
            }
        }
        throw new AssertionError((Object)("bad locale string '" + localeString + "'"));
    }

    public static <E> List<E> cast(List<? super E> list, Class<E> clazz) {
        return new CastingList<E>(list, clazz);
    }

    public static <E> Iterator<E> cast(final Iterator<?> iter, final Class<E> clazz) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                return clazz.cast(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static <E> Iterable<E> cast(Iterable<? super E> iterable, Class<E> clazz) {
        return () -> Util.cast(iterable.iterator(), clazz);
    }

    public static <E> Iterable<E> filter(Iterable<?> iterable, Class<E> includeFilter) {
        return () -> new Filterator(iterable.iterator(), includeFilter);
    }

    public static <E> Collection<E> filter(final Collection<?> collection, final Class<E> includeFilter) {
        return new AbstractCollection<E>(){
            private int size = -1;

            @Override
            public Iterator<E> iterator() {
                return new Filterator(collection.iterator(), includeFilter);
            }

            @Override
            public int size() {
                if (this.size == -1) {
                    int s2 = 0;
                    for (Object e : this) {
                        ++s2;
                    }
                    this.size = s2;
                }
                return this.size;
            }
        };
    }

    public static <E> List<E> filter(List<?> list, Class<E> includeFilter) {
        ArrayList<E> result = new ArrayList<E>();
        for (Object o : list) {
            if (!includeFilter.isInstance(o)) continue;
            result.add(includeFilter.cast(o));
        }
        return result;
    }

    public static Map<String, String> toMap(Properties properties) {
        return properties;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, Object ... keyValues) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1 + keyValues.length);
        map.put(key, value);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    public static <E extends Enum<E>> Error unexpected(E value) {
        return new AssertionError((Object)("Was not expecting value '" + value + "' for enumeration '" + value.getDeclaringClass().getName() + "' in this context"));
    }

    public static <T extends Enum<T>> Map<String, T> enumConstants(Class<T> clazz) {
        Enum[] ts = (Enum[])clazz.getEnumConstants();
        if (ts == null) {
            throw new AssertionError((Object)"not an enum type");
        }
        ImmutableMap.Builder<String, Enum> builder = ImmutableMap.builder();
        for (Enum t : ts) {
            builder.put(t.name(), t);
        }
        return builder.build();
    }

    public static synchronized <T extends Enum<T>> T enumVal(Class<T> clazz, String name) {
        return (T)((Enum)clazz.cast(ENUM_CONSTANTS.getUnchecked(clazz).get(name)));
    }

    public static synchronized <T extends Enum<T>> T enumVal(T default_, String name) {
        Class<T> clazz = default_.getDeclaringClass();
        Enum t = (Enum)clazz.cast(ENUM_CONSTANTS.getUnchecked(clazz).get(name));
        if (t == null) {
            return default_;
        }
        return (T)t;
    }

    public static <E> List<E> quotientList(final List<E> list, final int n, final int k) {
        if (n <= 0 || k < 0 || k >= n) {
            throw new IllegalArgumentException("n must be positive; k must be between 0 and n - 1");
        }
        final int size = (list.size() + n - k - 1) / n;
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return list.get(index * n + k);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <E> List<Pair<E, E>> pairs(List<E> list) {
        return Pair.zip(Util.quotientList(list, 2, 0), Util.quotientList(list, 2, 1));
    }

    public static <T> T first(T v0, T v1) {
        return v0 != null ? v0 : v1;
    }

    public static double first(Double v0, double v1) {
        return v0 != null ? v0 : v1;
    }

    public static float first(Float v0, float v1) {
        return v0 != null ? v0.floatValue() : v1;
    }

    public static int first(Integer v0, int v1) {
        return v0 != null ? v0 : v1;
    }

    public static long first(Long v0, long v1) {
        return v0 != null ? v0 : v1;
    }

    public static boolean first(Boolean v0, boolean v1) {
        return v0 != null ? v0 : v1;
    }

    public static short first(Short v0, short v1) {
        return v0 != null ? v0 : v1;
    }

    public static char first(Character v0, char v1) {
        return v0 != null ? v0.charValue() : v1;
    }

    public static byte first(Byte v0, byte v1) {
        return v0 != null ? v0 : v1;
    }

    public static <T> Iterable<T> orEmpty(Iterable<T> v0) {
        return v0 != null ? v0 : ImmutableList.of();
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> skipLast(List<E> list) {
        return Util.skipLast(list, 1);
    }

    public static <E> List<E> skipLast(List<E> list, int n) {
        return list.subList(0, list.size() - n);
    }

    public static <E> List<E> last(List<E> list, int n) {
        return list.subList(list.size() - n, list.size());
    }

    public static <E> List<E> skip(List<E> list) {
        return Util.skip(list, 1);
    }

    public static <E> List<E> skip(List<E> list, int fromIndex) {
        return fromIndex == 0 ? list : list.subList(fromIndex, list.size());
    }

    public static List<Integer> range(final int end) {
        return new AbstractList<Integer>(){

            @Override
            public int size() {
                return end;
            }

            @Override
            public Integer get(int index) {
                return index;
            }
        };
    }

    public static List<Integer> range(final int start, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public int size() {
                return end - start;
            }

            @Override
            public Integer get(int index) {
                return start + index;
            }
        };
    }

    public static <E> boolean isDistinct(List<E> list) {
        return Util.firstDuplicate(list) < 0;
    }

    public static <E> int firstDuplicate(List<E> list) {
        int size = list.size();
        if (size < 2) {
            return -1;
        }
        if (size < 15) {
            for (int i = 1; i < size; ++i) {
                E e = list.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    E e1 = list.get(j);
                    if (!Objects.equals(e, e1)) continue;
                    return i;
                }
            }
            return -1;
        }
        HashMap<E, String> set = new HashMap<E, String>(size);
        for (E e : list) {
            if (set.put(e, "") == null) continue;
            return set.size();
        }
        return -1;
    }

    public static <E> List<E> distinctList(List<E> list) {
        if (Util.isDistinct(list)) {
            return list;
        }
        return ImmutableList.copyOf(new LinkedHashSet<E>(list));
    }

    public static <E> List<E> distinctList(Iterable<E> keys) {
        List list;
        if (keys instanceof Set) {
            return ImmutableList.copyOf(keys);
        }
        if (keys instanceof List && Util.isDistinct(list = (List)keys)) {
            return list;
        }
        return ImmutableList.copyOf(Sets.newLinkedHashSet(keys));
    }

    public static <E> boolean intersects(Collection<E> c0, Collection<E> c1) {
        for (E e : c1) {
            if (!c0.contains(e)) continue;
            return true;
        }
        return false;
    }

    public static int findMatch(List<String> strings, String seek, boolean caseSensitive) {
        if (caseSensitive) {
            return strings.indexOf(seek);
        }
        for (int i = 0; i < strings.size(); ++i) {
            String s2 = strings.get(i);
            if (!s2.equalsIgnoreCase(seek)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matches(boolean caseSensitive, String s0, String s1) {
        return caseSensitive ? s1.equals(s0) : s1.equalsIgnoreCase(s0);
    }

    public static <E> boolean startsWith(List<E> list0, List<E> list1) {
        if (list0 == list1) {
            return true;
        }
        int size = list1.size();
        if (list0.size() < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects.equals(list0.get(i), list1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static String listToString(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (String s2 : list) {
            if (b.length() > 0) {
                b.append(".");
            }
            b.append('\"');
            b.append(s2.replace("\"", "\"\""));
            b.append('\"');
        }
        return b.toString();
    }

    public static List<String> stringToList(String s2) {
        if (s2.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        StringBuilder b = new StringBuilder();
        int i = 0;
        do {
            char c;
            if ((c = s2.charAt(i)) != '\"') {
                throw new IllegalArgumentException();
            }
            while (true) {
                if ((c = s2.charAt(++i)) == '\"') {
                    if (i == s2.length() - 1 || (c = s2.charAt(++i)) == '.') break;
                    if (c != '\"') {
                        throw new IllegalArgumentException();
                    }
                }
                b.append(c);
            }
            builder.add(b.toString());
            b.setLength(0);
        } while (++i < s2.length());
        return builder.build();
    }

    public static String human(double d) {
        if (d == 0.0) {
            return "0";
        }
        if (d < 0.0) {
            return "-" + Util.human(-d);
        }
        int digitCount = (int)Math.floor(Math.log10(d));
        switch (digitCount) {
            case 0: 
            case 1: 
            case 2: {
                return Integer.toString((int)d);
            }
            case 3: 
            case 4: 
            case 5: {
                return Util.digits3(Math.round(d / 10.0), digitCount % 3) + "K";
            }
            case 6: 
            case 7: 
            case 8: {
                return Util.digits3(Math.round(d / 10000.0), digitCount % 3) + "M";
            }
            case 9: 
            case 10: 
            case 11: {
                return Util.digits3(Math.round(d / 1.0E7), digitCount % 3) + "G";
            }
        }
        return Double.toString(d);
    }

    private static String digits3(long x, int z) {
        String s2 = Long.toString(x);
        switch (z) {
            case 0: {
                return s2.charAt(0) + "." + s2.substring(1, 3);
            }
            case 1: {
                return s2.substring(0, 2) + "." + s2.substring(2, 3);
            }
        }
        return s2.substring(0, 3);
    }

    public static <K, V> Map<K, V> asIndexMapJ(Collection<V> values, java.util.function.Function<V, K> function) {
        final Collection entries = Collections2.transform(values, v -> Pair.of(function.apply(v), v));
        final AbstractSet entrySet = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return entries.iterator();
            }

            @Override
            public int size() {
                return entries.size();
            }
        };
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return entrySet;
            }
        };
    }

    @Deprecated
    public static <K, V> Map<K, V> asIndexMap(Collection<V> values, Function<V, K> function) {
        return Util.asIndexMapJ(values, function::apply);
    }

    public static void debugCode(PrintStream out, String code) {
        out.println();
        StringReader sr = new StringReader(code);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            int i = 1;
            while ((line = br.readLine()) != null) {
                out.print("/*");
                String number = Integer.toString(i);
                if (number.length() < 4) {
                    Spaces.append(out, 4 - number.length());
                }
                out.print(number);
                out.print(" */ ");
                out.println(line);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static <E> List<List<E>> immutableCopy(Iterable<? extends Iterable<E>> lists) {
        int n = 0;
        for (Iterable<E> list : lists) {
            if (list instanceof ImmutableList) continue;
            ++n;
        }
        if (n == 0) {
            return ImmutableList.copyOf(lists);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Iterable<E> list : lists) {
            builder.add(ImmutableList.copyOf(list));
        }
        return builder.build();
    }

    public static PrintWriter printWriter(OutputStream out) {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    public static PrintWriter printWriter(File file) throws FileNotFoundException {
        return Util.printWriter(new FileOutputStream(file));
    }

    public static BufferedReader reader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public static BufferedReader reader(File file) throws FileNotFoundException {
        return Util.reader(new FileInputStream(file));
    }

    public static Calendar calendar() {
        return Calendar.getInstance(DateTimeUtils.UTC_ZONE, Locale.ROOT);
    }

    public static Calendar calendar(long millis) {
        Calendar calendar = Util.calendar();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList::builder, ImmutableList.Builder::add, (t, u) -> {
            t.addAll((Iterable)u.build());
            return t;
        }, ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <X> UnaryOperator<X> andThen(UnaryOperator<X> op1, UnaryOperator<X> op2) {
        return op1.andThen(op2)::apply;
    }

    public static <F, T> List<T> transform(List<F> list, java.util.function.Function<F, T> function) {
        if (list instanceof RandomAccess) {
            return new RandomAccessTransformingList<F, T>(list, function);
        }
        return new TransformingList<F, T>(list, function);
    }

    public static <E> Iterable<E> filter(Iterable<E> iterable, Predicate<E> predicate) {
        return () -> Util.filter(iterable.iterator(), predicate);
    }

    public static <E> Iterator<E> filter(Iterator<E> iterator, Predicate<E> predicate) {
        return new FilteringIterator<E>(iterator, predicate);
    }

    public static <E> List<E> select(final List<E> list, final List<Integer> ordinals) {
        return new AbstractList<E>(){

            @Override
            public int size() {
                return ordinals.size();
            }

            @Override
            public E get(int index) {
                return list.get((Integer)ordinals.get(index));
            }
        };
    }

    public static <K, V> Map<K, V> blackholeMap() {
        return BlackholeMap.of();
    }

    private static class FilteringIterator<T>
    implements Iterator<T> {
        private static final Object DUMMY = new Object();
        final Iterator<? extends T> iterator;
        private final Predicate<T> predicate;
        T current;

        FilteringIterator(Iterator<? extends T> iterator, Predicate<T> predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
            this.current = this.moveNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != DUMMY;
        }

        @Override
        public T next() {
            T t = this.current;
            this.current = this.moveNext();
            return t;
        }

        protected T moveNext() {
            while (this.iterator.hasNext()) {
                T t = this.iterator.next();
                if (!this.predicate.test(t)) continue;
                return t;
            }
            return (T)DUMMY;
        }
    }

    private static class RandomAccessTransformingList<F, T>
    extends TransformingList<F, T>
    implements RandomAccess {
        RandomAccessTransformingList(List<F> list, java.util.function.Function<F, T> function) {
            super(list, function);
        }
    }

    private static class TransformingList<F, T>
    extends AbstractList<T> {
        private final java.util.function.Function<F, T> function;
        private final List<F> list;

        TransformingList(List<F> list, java.util.function.Function<F, T> function) {
            this.function = function;
            this.list = list;
        }

        @Override
        public T get(int i) {
            return this.function.apply(this.list.get(i));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        @Nonnull
        public Iterator<T> iterator() {
            return this.listIterator();
        }
    }

    public static class OverFinder
    extends SqlBasicVisitor<Void> {
        public static final OverFinder INSTANCE = new OverFinder();

        @Override
        public Void visit(SqlCall call) {
            if (call.getKind() == SqlKind.OVER) {
                throw FoundOne.NULL;
            }
            return (Void)super.visit(call);
        }
    }

    public static class FoundOne
    extends ControlFlowException {
        private final Object node;
        public static final FoundOne NULL = new FoundOne((Object)null);

        public FoundOne(Object node) {
            this.node = node;
        }

        public Object getNode() {
            return this.node;
        }
    }
}

