/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.thrift.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;

public class TChunkData
extends TUnion<TChunkData, _Fields> {
    private static final TStruct STRUCT_DESC = new TStruct("TChunkData");
    private static final TField DATA_BUFFER_FIELD_DESC = new TField("data_buffer", 11, 1);
    private static final TField INDEX_BUFFER_FIELD_DESC = new TField("index_buffer", 11, 2);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TChunkData() {
    }

    public TChunkData(_Fields setField, Object value) {
        super(setField, value);
    }

    public TChunkData(TChunkData other) {
        super(other);
    }

    @Override
    public TChunkData deepCopy() {
        return new TChunkData(this);
    }

    public static TChunkData data_buffer(ByteBuffer value) {
        TChunkData x = new TChunkData();
        x.setData_buffer(value);
        return x;
    }

    public static TChunkData data_buffer(byte[] value) {
        TChunkData x = new TChunkData();
        x.setData_buffer(ByteBuffer.wrap((byte[])value.clone()));
        return x;
    }

    public static TChunkData index_buffer(ByteBuffer value) {
        TChunkData x = new TChunkData();
        x.setIndex_buffer(value);
        return x;
    }

    public static TChunkData index_buffer(byte[] value) {
        TChunkData x = new TChunkData();
        x.setIndex_buffer(ByteBuffer.wrap((byte[])value.clone()));
        return x;
    }

    @Override
    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case DATA_BUFFER: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type java.nio.ByteBuffer for field 'data_buffer', but got " + value.getClass().getSimpleName());
            }
            case INDEX_BUFFER: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type java.nio.ByteBuffer for field 'index_buffer', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + setField);
            }
        }
    }

    @Override
    protected Object standardSchemeReadValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case DATA_BUFFER: {
                    if (field.type == TChunkData.DATA_BUFFER_FIELD_DESC.type) {
                        ByteBuffer data_buffer = iprot.readBinary();
                        return data_buffer;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    return null;
                }
                case INDEX_BUFFER: {
                    if (field.type == TChunkData.INDEX_BUFFER_FIELD_DESC.type) {
                        ByteBuffer index_buffer = iprot.readBinary();
                        return index_buffer;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip(iprot, field.type);
        return null;
    }

    @Override
    protected void standardSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case DATA_BUFFER: {
                ByteBuffer data_buffer = (ByteBuffer)this.value_;
                oprot.writeBinary(data_buffer);
                return;
            }
            case INDEX_BUFFER: {
                ByteBuffer index_buffer = (ByteBuffer)this.value_;
                oprot.writeBinary(index_buffer);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    @Override
    protected Object tupleSchemeReadValue(TProtocol iprot, short fieldID) throws TException {
        _Fields setField = _Fields.findByThriftId(fieldID);
        if (setField != null) {
            switch (setField) {
                case DATA_BUFFER: {
                    ByteBuffer data_buffer = iprot.readBinary();
                    return data_buffer;
                }
                case INDEX_BUFFER: {
                    ByteBuffer index_buffer = iprot.readBinary();
                    return index_buffer;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        throw new TProtocolException("Couldn't find a field with field id " + fieldID);
    }

    @Override
    protected void tupleSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case DATA_BUFFER: {
                ByteBuffer data_buffer = (ByteBuffer)this.value_;
                oprot.writeBinary(data_buffer);
                return;
            }
            case INDEX_BUFFER: {
                ByteBuffer index_buffer = (ByteBuffer)this.value_;
                oprot.writeBinary(index_buffer);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    @Override
    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case DATA_BUFFER: {
                return DATA_BUFFER_FIELD_DESC;
            }
            case INDEX_BUFFER: {
                return INDEX_BUFFER_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + setField);
    }

    @Override
    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    @Override
    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public byte[] getData_buffer() {
        this.setData_buffer(TBaseHelper.rightSize(this.bufferForData_buffer()));
        ByteBuffer b = this.bufferForData_buffer();
        return b == null ? null : b.array();
    }

    public ByteBuffer bufferForData_buffer() {
        if (this.getSetField() == _Fields.DATA_BUFFER) {
            return TBaseHelper.copyBinary((ByteBuffer)this.getFieldValue());
        }
        throw new RuntimeException("Cannot get field 'data_buffer' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setData_buffer(byte[] value) {
        this.setData_buffer(ByteBuffer.wrap((byte[])value.clone()));
    }

    public void setData_buffer(ByteBuffer value) {
        this.setField_ = _Fields.DATA_BUFFER;
        this.value_ = Objects.requireNonNull(value, "_Fields.DATA_BUFFER");
    }

    public byte[] getIndex_buffer() {
        this.setIndex_buffer(TBaseHelper.rightSize(this.bufferForIndex_buffer()));
        ByteBuffer b = this.bufferForIndex_buffer();
        return b == null ? null : b.array();
    }

    public ByteBuffer bufferForIndex_buffer() {
        if (this.getSetField() == _Fields.INDEX_BUFFER) {
            return TBaseHelper.copyBinary((ByteBuffer)this.getFieldValue());
        }
        throw new RuntimeException("Cannot get field 'index_buffer' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setIndex_buffer(byte[] value) {
        this.setIndex_buffer(ByteBuffer.wrap((byte[])value.clone()));
    }

    public void setIndex_buffer(ByteBuffer value) {
        this.setField_ = _Fields.INDEX_BUFFER;
        this.value_ = Objects.requireNonNull(value, "_Fields.INDEX_BUFFER");
    }

    public boolean isSetData_buffer() {
        return this.setField_ == _Fields.DATA_BUFFER;
    }

    public boolean isSetIndex_buffer() {
        return this.setField_ == _Fields.INDEX_BUFFER;
    }

    public boolean equals(Object other) {
        if (other instanceof TChunkData) {
            return this.equals((TChunkData)other);
        }
        return false;
    }

    public boolean equals(TChunkData other) {
        return other != null && this.getSetField() == other.getSetField() && this.getFieldValue().equals(other.getFieldValue());
    }

    @Override
    public int compareTo(TChunkData other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)this.getSetField(), (Comparable)other.getSetField());
        if (lastComparison == 0) {
            return TBaseHelper.compareTo(this.getFieldValue(), other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        Object setField = this.getSetField();
        if (setField != null) {
            list.add(setField.getThriftFieldId());
            Object value = this.getFieldValue();
            if (value instanceof TEnum) {
                list.add(((TEnum)this.getFieldValue()).getValue());
            } else {
                list.add(value);
            }
        }
        return list.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DATA_BUFFER, new FieldMetaData("data_buffer", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.INDEX_BUFFER, new FieldMetaData("index_buffer", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TChunkData.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DATA_BUFFER(1, "data_buffer"),
        INDEX_BUFFER(2, "index_buffer");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DATA_BUFFER;
                }
                case 2: {
                    return INDEX_BUFFER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

