/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.parser;

import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TEncodingType;
import ai.heavy.thrift.server.TTableDetails;
import com.google.common.collect.ImmutableList;
import com.mapd.calcite.parser.HeavyDBParserOptions;
import com.mapd.calcite.parser.HeavyDBSchema;
import com.mapd.calcite.parser.HeavyDBSerializer;
import com.mapd.calcite.parser.HeavyDBSqlOperatorTable;
import com.mapd.calcite.parser.HeavyDBTable;
import com.mapd.calcite.parser.HeavyDBTypeSystem;
import com.mapd.calcite.parser.HeavyDBUser;
import com.mapd.calcite.parser.HeavyDBView;
import com.mapd.common.SockTransportProperties;
import com.mapd.metadata.MetaConnect;
import com.mapd.parser.extension.ddl.ExtendedSqlParser;
import com.mapd.parser.extension.ddl.JsonSerializableDdl;
import com.mapd.parser.hint.HeavyDBHintStrategyTable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.HeavyDBPlanner;
import org.apache.calcite.prepare.SqlIdentifierCapturer;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.externalize.HeavyDBRelWriterImpl;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeavyDBParser {
    public static final ThreadLocal<HeavyDBParser> CURRENT_PARSER = new ThreadLocal();
    private static final EnumSet<SqlKind> SCALAR = EnumSet.of(SqlKind.SCALAR_QUERY, SqlKind.SELECT);
    private static final EnumSet<SqlKind> EXISTS = EnumSet.of(SqlKind.EXISTS);
    private static final EnumSet<SqlKind> DELETE = EnumSet.of(SqlKind.DELETE);
    private static final EnumSet<SqlKind> UPDATE = EnumSet.of(SqlKind.UPDATE);
    private static final EnumSet<SqlKind> IN = EnumSet.of(SqlKind.IN);
    private static final EnumSet<SqlKind> ARRAY_VALUE = EnumSet.of(SqlKind.ARRAY_VALUE_CONSTRUCTOR);
    private static final EnumSet<SqlKind> OTHER_FUNCTION = EnumSet.of(SqlKind.OTHER_FUNCTION);
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyDBParser.class);
    private final Supplier<HeavyDBSqlOperatorTable> dbSqlOperatorTable;
    private final String dataDir;
    private int callCount = 0;
    private final int dbPort;
    private HeavyDBUser dbUser;
    private SockTransportProperties sock_transport_properties = null;
    private static Map<String, Boolean> SubqueryCorrMemo = new ConcurrentHashMap<String, Boolean>();
    private static final Context DB_CONNECTION_CONTEXT = new Context(){
        HeavyDBTypeSystem myTypeSystem = new HeavyDBTypeSystem();
        CalciteConnectionConfig config = new CalciteConnectionConfigImpl(new Properties()){
            {
                super(x0);
                this.properties.put(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(false));
                this.properties.put(CalciteConnectionProperty.CONFORMANCE.camelName(), String.valueOf(SqlConformanceEnum.LENIENT));
            }

            @Override
            public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
                return (T)myTypeSystem;
            }

            @Override
            public boolean caseSensitive() {
                return false;
            }

            @Override
            public SqlConformance conformance() {
                return SqlConformanceEnum.LENIENT;
            }
        };

        @Override
        public <C> C unwrap(Class<C> aClass) {
            if (aClass.isInstance(this.config)) {
                return aClass.cast(this.config);
            }
            return null;
        }
    };

    public HeavyDBParser(String dataDir, Supplier<HeavyDBSqlOperatorTable> dbSqlOperatorTable, int dbPort, SockTransportProperties skT) {
        this.dataDir = dataDir;
        this.dbSqlOperatorTable = dbSqlOperatorTable;
        this.dbPort = dbPort;
        this.sock_transport_properties = skT;
    }

    public void clearMemo() {
        SubqueryCorrMemo.clear();
    }

    private HeavyDBPlanner getPlanner() {
        return this.getPlanner(true, false, false);
    }

    private boolean isCorrelated(SqlNode expression) {
        String queryString = expression.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        Boolean isCorrelatedSubquery = SubqueryCorrMemo.get(queryString);
        if (null != isCorrelatedSubquery) {
            return isCorrelatedSubquery;
        }
        try {
            HeavyDBParser parser = new HeavyDBParser(this.dataDir, this.dbSqlOperatorTable, this.dbPort, this.sock_transport_properties);
            HeavyDBParserOptions options = new HeavyDBParserOptions();
            parser.setUser(this.dbUser);
            parser.processSql(expression, options);
        }
        catch (Exception e) {
            SubqueryCorrMemo.put(queryString, true);
            return true;
        }
        SubqueryCorrMemo.put(queryString, false);
        return false;
    }

    private boolean isHashJoinableType(TColumnType type) {
        switch (type.getCol_type().type) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return true;
            }
            case STR: {
                return type.col_type.encoding == TEncodingType.DICT;
            }
        }
        return false;
    }

    private boolean isColumnHashJoinable(List<String> joinColumnIdentifier, MetaConnect mc) {
        try {
            TTableDetails tableDetails = mc.get_table_details(joinColumnIdentifier.get(0));
            return null != tableDetails.row_desc.stream().filter(c -> c.col_name.toLowerCase(Locale.ROOT).equals(((String)joinColumnIdentifier.get(1)).toLowerCase(Locale.ROOT)) && this.isHashJoinableType((TColumnType)c)).findFirst().orElse(null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private HeavyDBPlanner getPlanner(final boolean allowSubQueryExpansion, final boolean isWatchdogEnabled, final boolean isDistributedMode) {
        HeavyDBUser user = new HeavyDBUser(this.dbUser.getUser(), this.dbUser.getSession(), this.dbUser.getDB(), -1, ImmutableList.of());
        final MetaConnect mc = new MetaConnect(this.dbPort, this.dataDir, user, this, this.sock_transport_properties);
        BiPredicate<SqlNode, SqlNode> expandPredicate = new BiPredicate<SqlNode, SqlNode>(){

            @Override
            public boolean test(SqlNode root, SqlNode expression) {
                if (!allowSubQueryExpansion) {
                    return false;
                }
                if (expression.isA(EXISTS) || expression.isA(IN)) {
                    if (expression.isA(IN)) {
                        SqlCall outerSelectCall;
                        if (expression instanceof SqlCall && (outerSelectCall = (SqlCall)expression).getOperandList().size() == 2 && outerSelectCall.getOperandList().get(1) instanceof SqlSelect) {
                            JoinOperatorChecker joinOperatorChecker;
                            SqlSelect innerSelectCall = (SqlSelect)outerSelectCall.getOperandList().get(1);
                            if (innerSelectCall.hasWhere() && (joinOperatorChecker = new JoinOperatorChecker()).containsExpression(innerSelectCall.getWhere())) {
                                return true;
                            }
                            if (isDistributedMode) {
                                return false;
                            }
                            boolean hasHashJoinableExpression = false;
                            if (isWatchdogEnabled) {
                                HashMap<String, String> tableAliasMap = new HashMap<String, String>();
                                if (root instanceof SqlSelect) {
                                    HeavyDBParser.this.tableAliasFinder(((SqlSelect)root).getFrom(), tableAliasMap);
                                }
                                HeavyDBParser.this.tableAliasFinder(innerSelectCall.getFrom(), tableAliasMap);
                                if (outerSelectCall.getOperandList().get(0) instanceof SqlIdentifier && innerSelectCall.getSelectList().get(0) instanceof SqlIdentifier) {
                                    SqlIdentifier outerColIdentifier = (SqlIdentifier)outerSelectCall.getOperandList().get(0);
                                    SqlIdentifier innerColIdentifier = (SqlIdentifier)innerSelectCall.getSelectList().get(0);
                                    if (tableAliasMap.containsKey(outerColIdentifier.names.get(0)) && tableAliasMap.containsKey(innerColIdentifier.names.get(0))) {
                                        String outerTableName = (String)tableAliasMap.get(outerColIdentifier.names.get(0));
                                        String innerTableName = (String)tableAliasMap.get(innerColIdentifier.names.get(0));
                                        if (HeavyDBParser.this.isColumnHashJoinable(ImmutableList.of(outerTableName, outerColIdentifier.names.get(1)), mc) && HeavyDBParser.this.isColumnHashJoinable(ImmutableList.of(innerTableName, innerColIdentifier.names.get(1)), mc)) {
                                            hasHashJoinableExpression = true;
                                        }
                                    }
                                }
                                if (!hasHashJoinableExpression) {
                                    return false;
                                }
                            }
                        }
                        if (root instanceof SqlSelect) {
                            SqlSelect selectCall = (SqlSelect)root;
                            if (new ExpressionListedInSelectClauseChecker().containsExpression(selectCall, expression)) {
                                return false;
                            }
                            if (null != selectCall.getWhere() && new ExpressionListedAsChildOROperatorChecker().containsExpression(selectCall.getWhere(), expression)) {
                                return false;
                            }
                            if (null != selectCall.getHaving() && new ExpressionListedAsChildOROperatorChecker().containsExpression(selectCall.getHaving(), expression)) {
                                return false;
                            }
                        }
                    }
                    return true;
                }
                if (expression.isA(SCALAR) && HeavyDBParser.this.isCorrelated(expression)) {
                    SqlCall call;
                    SqlSelect select = null;
                    if (expression instanceof SqlCall && (call = (SqlCall)expression).getOperator().equals(SqlStdOperatorTable.SCALAR_QUERY)) {
                        expression = call.getOperandList().get(0);
                    }
                    if (expression instanceof SqlSelect) {
                        select = (SqlSelect)expression;
                    }
                    if (null != select && (null != select.getFetch() || null != select.getOffset() || null != select.getOrderList() && select.getOrderList().size() != 0)) {
                        throw new CalciteException("Correlated sub-queries with ordering not supported.", null);
                    }
                    return true;
                }
                return false;
            }
        };
        HeavyDBSchema defaultSchema = new HeavyDBSchema(this.dataDir, this, this.dbPort, this.dbUser, this.sock_transport_properties, this.dbUser.getDB());
        SchemaPlus rootSchema = Frameworks.createRootSchema(true);
        SchemaPlus defaultSchemaPlus = rootSchema.add(this.dbUser.getDB(), defaultSchema);
        for (String db : mc.getDatabases()) {
            if (db.equalsIgnoreCase(this.dbUser.getDB())) continue;
            rootSchema.add(db, new HeavyDBSchema(this.dataDir, this, this.dbPort, this.dbUser, this.sock_transport_properties, db));
        }
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(defaultSchemaPlus).operatorTable(this.dbSqlOperatorTable.get()).parserConfig(SqlParser.configBuilder().setConformance(SqlConformanceEnum.LENIENT).setUnquotedCasing(Casing.UNCHANGED).setCaseSensitive(false).setIdentifierMaxLength(512).setParserFactory(ExtendedSqlParser.FACTORY).build()).sqlToRelConverterConfig(SqlToRelConverter.configBuilder().withExpandPredicate(expandPredicate).withInSubQueryThreshold(Integer.MAX_VALUE).withHintStrategyTable(HeavyDBHintStrategyTable.HINT_STRATEGY_TABLE).build()).typeSystem(this.createTypeSystem()).context(DB_CONNECTION_CONTEXT).build();
        HeavyDBPlanner planner = new HeavyDBPlanner(config);
        planner.setRestrictions(this.dbUser.getRestrictions());
        return planner;
    }

    public void setUser(HeavyDBUser dbUser) {
        this.dbUser = dbUser;
    }

    public Pair<String, SqlIdentifierCapturer> process(String sql, HeavyDBParserOptions parserOptions) throws SqlParseException, ValidationException, RelConversionException {
        HeavyDBPlanner planner = this.getPlanner(true, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
        SqlNode sqlNode = this.parseSql(sql, parserOptions.isLegacySyntax(), planner);
        String res = this.processSql(sqlNode, parserOptions);
        SqlIdentifierCapturer capture = this.captureIdentifiers(sqlNode);
        return new Pair<String, SqlIdentifierCapturer>(res, capture);
    }

    public String buildRATreeAndPerformQueryOptimization(String query, HeavyDBParserOptions parserOptions) throws IOException {
        HeavyDBSchema schema = new HeavyDBSchema(this.dataDir, this, this.dbPort, this.dbUser, this.sock_transport_properties, this.dbUser.getDB());
        HeavyDBPlanner planner = this.getPlanner(true, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
        planner.setFilterPushDownInfo(parserOptions.getFilterPushDownInfo());
        RelRoot optRel = planner.buildRATreeAndPerformQueryOptimization(query, schema);
        optRel = this.replaceIsTrue(planner.getTypeFactory(), optRel);
        return HeavyDBSerializer.toString(optRel.project());
    }

    public String processSql(String sql, HeavyDBParserOptions parserOptions) throws SqlParseException, ValidationException, RelConversionException {
        ++this.callCount;
        HeavyDBPlanner planner = this.getPlanner(true, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
        SqlNode sqlNode = this.parseSql(sql, parserOptions.isLegacySyntax(), planner);
        return this.processSql(sqlNode, parserOptions);
    }

    public String processSql(SqlNode sqlNode, HeavyDBParserOptions parserOptions) throws SqlParseException, ValidationException, RelConversionException {
        ++this.callCount;
        if (sqlNode instanceof JsonSerializableDdl) {
            return ((JsonSerializableDdl)((Object)sqlNode)).toJsonString();
        }
        if (sqlNode instanceof SqlDdl) {
            return sqlNode.toString();
        }
        HeavyDBPlanner planner = this.getPlanner(true, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
        planner.advanceToValidate();
        RelRoot sqlRel = this.convertSqlToRelNode(sqlNode, planner, parserOptions);
        RelNode project = sqlRel.project();
        if (project == null) {
            throw new RuntimeException("Cannot convert the sql to AST");
        }
        if (parserOptions.isExplainDetail()) {
            StringWriter sw = new StringWriter();
            HeavyDBRelWriterImpl planWriter = new HeavyDBRelWriterImpl(new PrintWriter(sw), SqlExplainLevel.EXPPLAN_ATTRIBUTES, false);
            project.explain(planWriter);
            return sw.toString();
        }
        if (parserOptions.isExplain()) {
            return RelOptUtil.toString(sqlRel.project());
        }
        return HeavyDBSerializer.toString(project);
    }

    public HeavyDBPlanner.CompletionResult getCompletionHints(String sql, int cursor, List<String> visible_tables) {
        return this.getPlanner().getCompletionHints(sql, cursor, visible_tables);
    }

    public HashSet<ImmutableList<String>> resolveSelectIdentifiers(SqlIdentifierCapturer capturer) {
        HashSet<ImmutableList<String>> resolved = new HashSet<ImmutableList<String>>();
        for (ImmutableList<String> names : capturer.selects) {
            HeavyDBSchema schema = new HeavyDBSchema(this.dataDir, this, this.dbPort, this.dbUser, this.sock_transport_properties, (String)names.get(1));
            HeavyDBTable table = (HeavyDBTable)schema.getTable((String)names.get(0));
            if (null == table) {
                throw new RuntimeException("table/view not found: " + (String)names.get(0));
            }
            if (table instanceof HeavyDBView) {
                HeavyDBView view = (HeavyDBView)table;
                resolved.addAll(this.resolveSelectIdentifiers(view.getAccessedObjects()));
                continue;
            }
            resolved.add(names);
        }
        return resolved;
    }

    private String getTableName(SqlNode node) {
        if (node.isA(EnumSet.of(SqlKind.AS))) {
            node = ((SqlCall)node).getOperandList().get(1);
        }
        if (node instanceof SqlIdentifier) {
            SqlIdentifier id = (SqlIdentifier)node;
            return (String)id.names.get(id.names.size() - 1);
        }
        return null;
    }

    private SqlSelect rewriteSimpleUpdateAsSelect(SqlUpdate update) {
        SqlCall selectExprCall;
        SqlNode where = update.getCondition();
        if (update.getSourceExpressionList().size() != 1) {
            return null;
        }
        if (!(update.getSourceExpressionList().get(0) instanceof SqlSelect)) {
            return null;
        }
        SqlSelect inner = (SqlSelect)update.getSourceExpressionList().get(0);
        if (null != inner.getGroup() || null != inner.getFetch() || null != inner.getOffset() || null != inner.getOrderList() && inner.getOrderList().size() != 0 || null != inner.getGroup() && inner.getGroup().size() != 0 || null == this.getTableName(inner.getFrom())) {
            return null;
        }
        if (!this.isCorrelated(inner)) {
            return null;
        }
        final String updateTableName = this.getTableName(update.getTargetTable());
        if (null != where) {
            where = where.accept(new SqlShuttle(){

                @Override
                public SqlNode visit(SqlIdentifier id) {
                    if (id.isSimple()) {
                        id = new SqlIdentifier(Arrays.asList(updateTableName, id.getSimple()), id.getParserPosition());
                    }
                    return id;
                }
            });
        }
        SqlJoin join = new SqlJoin(SqlParserPos.ZERO, update.getTargetTable(), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), SqlLiteral.createSymbol(JoinType.LEFT, SqlParserPos.ZERO), inner.getFrom(), SqlLiteral.createSymbol(JoinConditionType.ON, SqlParserPos.ZERO), inner.getWhere());
        SqlNode select0 = inner.getSelectList().get(0);
        boolean wrapInSingleValue = true;
        if (select0 instanceof SqlCall && Util.isSingleValue(selectExprCall = (SqlCall)select0)) {
            wrapInSingleValue = false;
        }
        if (wrapInSingleValue) {
            if (select0.isA(EnumSet.of(SqlKind.AS))) {
                select0 = ((SqlCall)select0).getOperandList().get(0);
            }
            select0 = new SqlBasicCall(SqlStdOperatorTable.SINGLE_VALUE, new SqlNode[]{select0}, SqlParserPos.ZERO);
        }
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(select0);
        selectList.add(new SqlBasicCall(SqlStdOperatorTable.AS, new SqlNode[]{new SqlBasicCall(new SqlUnresolvedFunction(new SqlIdentifier("OFFSET_IN_FRAGMENT", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), new SqlNode[0], SqlParserPos.ZERO), new SqlIdentifier("EXPR$DELETE_OFFSET_IN_FRAGMENT", SqlParserPos.ZERO)}, SqlParserPos.ZERO));
        SqlNodeList groupBy = new SqlNodeList(SqlParserPos.ZERO);
        groupBy.add(new SqlIdentifier("EXPR$DELETE_OFFSET_IN_FRAGMENT", SqlParserPos.ZERO));
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, null, selectList, join, where, groupBy, null, null, null, null, null, null);
        return select;
    }

    private LogicalTableModify getDummyUpdate(SqlUpdate update) throws SqlParseException, ValidationException, RelConversionException {
        SqlIdentifier targetTable = (SqlIdentifier)update.getTargetTable();
        String targetTableName = targetTable.toString();
        HeavyDBPlanner planner = this.getPlanner();
        String dummySql = "DELETE FROM " + targetTableName;
        SqlNode dummyNode = planner.parse(dummySql);
        dummyNode = planner.validate(dummyNode);
        RelRoot dummyRoot = planner.rel(dummyNode);
        LogicalTableModify dummyModify = (LogicalTableModify)dummyRoot.rel;
        return dummyModify;
    }

    private RelRoot rewriteUpdateAsSelect(SqlUpdate update, HeavyDBParserOptions parserOptions) throws SqlParseException, ValidationException, RelConversionException {
        boolean applyRexCast;
        Object targetTable;
        SqlNode updateTargetTable;
        boolean hasInClause;
        final int[] correlatedQueriesCount = new int[1];
        SqlBasicVisitor<Void> correlatedQueriesCounter = new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                if (call.isA(SCALAR) && (call instanceof SqlBasicCall && call.operandCount() == 1 && !((SqlNode)call.operand(0)).isA(SCALAR) || !(call instanceof SqlBasicCall)) && HeavyDBParser.this.isCorrelated(call)) {
                    correlatedQueriesCount[0] = correlatedQueriesCount[0] + 1;
                }
                return (Void)super.visit(call);
            }
        };
        update.accept(correlatedQueriesCounter);
        if (correlatedQueriesCount[0] > 1) {
            throw new CalciteException("table modifications with multiple correlated sub-queries not supported.", null);
        }
        boolean allowSubqueryDecorrelation = true;
        SqlNode updateCondition = update.getCondition();
        if (null != updateCondition && (hasInClause = new FindSqlOperator().containsSqlOperator(updateCondition, SqlKind.IN)) && null != (updateTargetTable = update.getTargetTable()) && updateTargetTable instanceof SqlIdentifier) {
            MetaConnect mc;
            TTableDetails updateTargetTableDetails;
            targetTable = (SqlIdentifier)updateTargetTable;
            if (((SqlIdentifier)targetTable).names.size() == 2 && null != (updateTargetTableDetails = (mc = new MetaConnect(this.dbPort, this.dataDir, this.dbUser, this, this.sock_transport_properties, (String)((SqlIdentifier)targetTable).names.get(0))).get_table_details((String)((SqlIdentifier)targetTable).names.get(1))) && updateTargetTableDetails.is_temporary) {
                allowSubqueryDecorrelation = false;
            }
        }
        SqlNodeList sourceExpression = new SqlNodeList(SqlParserPos.ZERO);
        LogicalTableModify dummyModify = this.getDummyUpdate(update);
        targetTable = dummyModify.getTable();
        RelDataType targetTableType = targetTable.getRowType();
        SqlSelect select = this.rewriteSimpleUpdateAsSelect(update);
        boolean bl = applyRexCast = null == select;
        if (null == select) {
            for (int i = 0; i < update.getSourceExpressionList().size(); ++i) {
                SqlNode targetColumn = update.getTargetColumnList().get(i);
                SqlNode expression = update.getSourceExpressionList().get(i);
                if (!(targetColumn instanceof SqlIdentifier)) {
                    throw new RuntimeException("Unknown identifier type!");
                }
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                RelDataType fieldType = targetTableType.getField((String)id.names.get(id.names.size() - 1), false, false).getType();
                if (expression.isA(ARRAY_VALUE) && null != fieldType.getComponentType()) {
                    SqlDataTypeSpec elementType = new SqlDataTypeSpec(new SqlBasicTypeNameSpec(fieldType.getComponentType().getSqlTypeName(), fieldType.getPrecision(), fieldType.getScale(), null == fieldType.getCharset() ? null : fieldType.getCharset().name(), SqlParserPos.ZERO), SqlParserPos.ZERO);
                    SqlCall array_expression = (SqlCall)expression;
                    ArrayList values = new ArrayList();
                    for (SqlNode value : array_expression.getOperandList()) {
                        if (value.isA(EnumSet.of(SqlKind.LITERAL))) {
                            SqlBasicCall casted_value = new SqlBasicCall(SqlStdOperatorTable.CAST, new SqlNode[]{value, elementType}, value.getParserPosition());
                            values.add(casted_value);
                            continue;
                        }
                        values.add(value);
                    }
                    expression = new SqlBasicCall(HeavyDBSqlOperatorTable.ARRAY_VALUE_CONSTRUCTOR, values.toArray(new SqlNode[0]), expression.getParserPosition());
                }
                sourceExpression.add(expression);
            }
            sourceExpression.add(new SqlBasicCall(SqlStdOperatorTable.AS, new SqlNode[]{new SqlBasicCall(new SqlUnresolvedFunction(new SqlIdentifier("OFFSET_IN_FRAGMENT", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), new SqlNode[0], SqlParserPos.ZERO), new SqlIdentifier("EXPR$DELETE_OFFSET_IN_FRAGMENT", SqlParserPos.ZERO)}, SqlParserPos.ZERO));
            select = new SqlSelect(SqlParserPos.ZERO, null, sourceExpression, update.getTargetTable(), update.getCondition(), null, null, null, null, null, null, null);
        }
        HeavyDBPlanner planner = this.getPlanner(allowSubqueryDecorrelation, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
        SqlNode node = null;
        try {
            node = planner.parse(select.toSqlString(CalciteSqlDialect.DEFAULT).getSql());
            node = planner.validate(node);
        }
        catch (Exception e) {
            HEAVYDBLOGGER.error("Error processing UPDATE rewrite, rewritten stmt was: " + select.toSqlString(CalciteSqlDialect.DEFAULT).getSql());
            throw e;
        }
        RelRoot root = planner.rel(node);
        Project project = (LogicalProject)root.project();
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        RexBuilder builder = new RexBuilder(planner.getTypeFactory());
        for (Object n : update.getTargetColumnList()) {
            if (n instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)n;
                fields.add((String)id.names.get(id.names.size() - 1));
                continue;
            }
            throw new RuntimeException("Unknown identifier type!");
        }
        int idx = 0;
        for (RexNode exp : project.getProjects()) {
            if (applyRexCast && idx + 1 < project.getProjects().size()) {
                RelDataType expectedFieldType = targetTableType.getField((String)fields.get(idx), false, false).getType();
                boolean is_array_kind = exp.isA(ARRAY_VALUE);
                boolean is_func_kind = exp.isA(OTHER_FUNCTION);
                if (!(exp.getType().equals(expectedFieldType) || is_array_kind || is_func_kind)) {
                    exp = builder.makeCast(expectedFieldType, exp);
                }
            }
            nodes.add(exp);
            ++idx;
        }
        ArrayList<RexNode> inputs = new ArrayList<RexNode>();
        int n = 0;
        for (int i = 0; i < fields.size(); ++i) {
            inputs.add(new RexInputRef(n, project.getRowType().getFieldList().get(n).getType()));
            ++n;
        }
        fields.add("EXPR$DELETE_OFFSET_IN_FRAGMENT");
        inputs.add(new RexInputRef(n, project.getRowType().getFieldList().get(n).getType()));
        project = project.copy(project.getTraitSet(), project.getInput(), nodes, project.getRowType());
        LogicalTableModify modify = LogicalTableModify.create((RelOptTable)targetTable, dummyModify.getCatalogReader(), project, TableModify.Operation.UPDATE, fields, inputs, true);
        return RelRoot.of(modify, SqlKind.UPDATE);
    }

    RelRoot queryToRelNode(String sql, HeavyDBParserOptions parserOptions) throws SqlParseException, ValidationException, RelConversionException {
        HeavyDBPlanner planner = this.getPlanner(true, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
        SqlNode sqlNode = this.parseSql(sql, parserOptions.isLegacySyntax(), planner);
        return this.convertSqlToRelNode(sqlNode, planner, parserOptions);
    }

    RelRoot convertSqlToRelNode(SqlNode sqlNode, HeavyDBPlanner HeavyDBPlanner2, HeavyDBParserOptions parserOptions) throws SqlParseException, ValidationException, RelConversionException {
        SqlNode node = sqlNode;
        HeavyDBPlanner planner = HeavyDBPlanner2;
        boolean allowCorrelatedSubQueryExpansion = true;
        boolean patchUpdateToDelete = false;
        if (node.isA(DELETE)) {
            SqlDelete sqlDelete = (SqlDelete)node;
            node = new SqlUpdate(node.getParserPosition(), sqlDelete.getTargetTable(), SqlNodeList.EMPTY, SqlNodeList.EMPTY, sqlDelete.getCondition(), sqlDelete.getSourceSelect(), sqlDelete.getAlias());
            patchUpdateToDelete = true;
        }
        if (node.isA(UPDATE)) {
            SqlUpdate update = (SqlUpdate)node;
            update = (SqlUpdate)planner.validate(update);
            RelRoot root = this.rewriteUpdateAsSelect(update, parserOptions);
            if (patchUpdateToDelete) {
                LogicalTableModify modify = (LogicalTableModify)root.rel;
                try {
                    Field f = TableModify.class.getDeclaredField("operation");
                    f.setAccessible(true);
                    f.set(modify, (Object)TableModify.Operation.DELETE);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                root = RelRoot.of(modify, SqlKind.DELETE);
            }
            return root;
        }
        if (parserOptions.isLegacySyntax()) {
            planner.close();
            planner = this.getPlanner(allowCorrelatedSubQueryExpansion, parserOptions.isWatchdogEnabled(), parserOptions.isDistributedMode());
            node = this.parseSql(node.toSqlString(CalciteSqlDialect.DEFAULT).toString(), false, planner);
        }
        SqlNode validateR = planner.validate(node);
        planner.setFilterPushDownInfo(parserOptions.getFilterPushDownInfo());
        boolean foundView = false;
        SqlIdentifierCapturer capturer = this.captureIdentifiers(sqlNode);
        for (ImmutableList<String> names : capturer.selects) {
            HeavyDBSchema schema = new HeavyDBSchema(this.dataDir, this, this.dbPort, this.dbUser, this.sock_transport_properties, (String)names.get(1));
            HeavyDBTable table = (HeavyDBTable)schema.getTable((String)names.get(0));
            if (null == table) {
                throw new RuntimeException("table/view not found: " + (String)names.get(0));
            }
            if (!(table instanceof HeavyDBView)) continue;
            foundView = true;
        }
        RelRoot relRootNode = planner.getRelRoot(validateR);
        relRootNode = this.replaceIsTrue(planner.getTypeFactory(), relRootNode);
        RelNode rootNode = planner.optimizeRATree(relRootNode.project(), parserOptions.isViewOptimizeEnabled(), foundView);
        planner.close();
        return new RelRoot(rootNode, relRootNode.validatedRowType, relRootNode.kind, relRootNode.fields, relRootNode.collation, Collections.emptyList());
    }

    private RelRoot replaceIsTrue(final RelDataTypeFactory typeFactory, RelRoot root) {
        final RexShuttle callShuttle = new RexShuttle(){
            RexBuilder builder;
            {
                this.builder = new RexBuilder(typeFactory);
            }

            @Override
            public RexNode visitCall(RexCall call) {
                if ((call = (RexCall)super.visitCall(call)).getKind() == SqlKind.IS_TRUE) {
                    return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, this.builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, call.getOperands().get(0)), call.getOperands().get(0));
                }
                if (call.getKind() == SqlKind.IS_NOT_TRUE) {
                    return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, this.builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, call.getOperands().get(0)), this.builder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, call.getOperands().get(0)));
                }
                if (call.getKind() == SqlKind.IS_FALSE) {
                    return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, this.builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, call.getOperands().get(0)), this.builder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, call.getOperands().get(0)));
                }
                if (call.getKind() == SqlKind.IS_NOT_FALSE) {
                    return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, this.builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, call.getOperands().get(0)), call.getOperands().get(0));
                }
                return call;
            }
        };
        RelNode node = root.rel.accept(new RelShuttleImpl(){

            @Override
            protected RelNode visitChild(RelNode parent, int i, RelNode child) {
                RelNode node = super.visitChild(parent, i, child);
                return node.accept(callShuttle);
            }
        });
        return new RelRoot(node, root.validatedRowType, root.kind, root.fields, root.collation, Collections.emptyList());
    }

    private SqlNode parseSql(String sql, boolean legacy_syntax, Planner planner) throws SqlParseException {
        SqlNode parseR = null;
        try {
            parseR = planner.parse(sql);
            HEAVYDBLOGGER.debug(" node is \n" + parseR.toString());
        }
        catch (SqlParseException ex) {
            HEAVYDBLOGGER.error("failed to parse SQL '" + sql + "' \n" + ex.toString());
            throw ex;
        }
        if (!legacy_syntax) {
            return parseR;
        }
        RelDataTypeFactory typeFactory = planner.getTypeFactory();
        SqlSelect select_node = null;
        if (parseR instanceof SqlSelect) {
            select_node = (SqlSelect)parseR;
            this.desugar(select_node, typeFactory);
        } else if (parseR instanceof SqlOrderBy) {
            SqlOrderBy order_by_node = (SqlOrderBy)parseR;
            if (order_by_node.query instanceof SqlSelect) {
                select_node = (SqlSelect)order_by_node.query;
                SqlOrderBy new_order_by_node = this.desugar(select_node, order_by_node, typeFactory);
                if (new_order_by_node != null) {
                    return new_order_by_node;
                }
            } else if (order_by_node.query instanceof SqlWith) {
                SqlWith old_with_node = (SqlWith)order_by_node.query;
                if (old_with_node.body instanceof SqlSelect) {
                    select_node = (SqlSelect)old_with_node.body;
                    this.desugar(select_node, typeFactory);
                }
            }
        } else if (parseR instanceof SqlWith) {
            SqlWith old_with_node = (SqlWith)parseR;
            if (old_with_node.body instanceof SqlSelect) {
                select_node = (SqlSelect)old_with_node.body;
                this.desugar(select_node, typeFactory);
            }
        }
        return parseR;
    }

    private void desugar(SqlSelect select_node, RelDataTypeFactory typeFactory) {
        this.desugar(select_node, null, typeFactory);
    }

    private SqlNode expandCase(SqlCase old_case_node, RelDataTypeFactory typeFactory) {
        SqlNode candidate_value_operand;
        SqlNode new_value_operand;
        SqlNode candidate_else_operand;
        SqlNode newCall;
        SqlNodeList newWhenList = new SqlNodeList(old_case_node.getWhenOperands().getParserPosition());
        SqlNodeList newThenList = new SqlNodeList(old_case_node.getThenOperands().getParserPosition());
        HashMap<String, SqlNode> id_to_expr = new HashMap<String, SqlNode>();
        for (SqlNode node : old_case_node.getWhenOperands()) {
            newCall = this.expand(node, id_to_expr, typeFactory);
            if (null != newCall) {
                newWhenList.add(newCall);
                continue;
            }
            newWhenList.add(node);
        }
        for (SqlNode node : old_case_node.getThenOperands()) {
            newCall = this.expand(node, id_to_expr, typeFactory);
            if (null != newCall) {
                newThenList.add(newCall);
                continue;
            }
            newThenList.add(node);
        }
        SqlNode new_else_operand = old_case_node.getElseOperand();
        if (null != new_else_operand && null != (candidate_else_operand = this.expand(old_case_node.getElseOperand(), id_to_expr, typeFactory))) {
            new_else_operand = candidate_else_operand;
        }
        if (null != (new_value_operand = old_case_node.getValueOperand()) && null != (candidate_value_operand = this.expand(old_case_node.getValueOperand(), id_to_expr, typeFactory))) {
            new_value_operand = candidate_value_operand;
        }
        SqlCase newCaseNode = SqlCase.createSwitched(old_case_node.getParserPosition(), new_value_operand, newWhenList, newThenList, new_else_operand);
        return newCaseNode;
    }

    private SqlOrderBy desugar(SqlSelect select_node, SqlOrderBy order_by_node, RelDataTypeFactory typeFactory) {
        SqlNode having;
        HEAVYDBLOGGER.debug("desugar: before: " + select_node.toString());
        this.desugarExpression(select_node.getFrom(), typeFactory);
        this.desugarExpression(select_node.getWhere(), typeFactory);
        SqlNodeList select_list = select_node.getSelectList();
        SqlNodeList new_select_list = new SqlNodeList(select_list.getParserPosition());
        HashMap<String, SqlNode> id_to_expr = new HashMap<String, SqlNode>();
        for (SqlNode proj : select_list) {
            if (!(proj instanceof SqlBasicCall)) {
                if (proj instanceof SqlCase) {
                    new_select_list.add(this.expandCase((SqlCase)proj, typeFactory));
                    continue;
                }
                new_select_list.add(proj);
                continue;
            }
            assert (proj instanceof SqlBasicCall);
            SqlBasicCall proj_call = (SqlBasicCall)proj;
            if (proj_call.operands.length > 0) {
                for (int i = 0; i < proj_call.operands.length; ++i) {
                    if (!(proj_call.operand(i) instanceof SqlCase)) continue;
                    SqlNode new_op = this.expandCase((SqlCase)proj_call.operand(i), typeFactory);
                    proj_call.setOperand(i, new_op);
                }
            }
            new_select_list.add(this.expand(proj_call, id_to_expr, typeFactory));
        }
        select_node.setSelectList(new_select_list);
        SqlNodeList group_by_list = select_node.getGroup();
        if (group_by_list != null) {
            select_node.setGroupBy(this.expand(group_by_list, id_to_expr, typeFactory));
        }
        if ((having = select_node.getHaving()) != null) {
            this.expand(having, id_to_expr, typeFactory);
        }
        SqlOrderBy new_order_by_node = null;
        if (order_by_node != null && order_by_node.orderList != null && order_by_node.orderList.size() > 0) {
            SqlNodeList new_order_by_list = this.expand(order_by_node.orderList, id_to_expr, typeFactory);
            new_order_by_node = new SqlOrderBy(order_by_node.getParserPosition(), select_node, new_order_by_list, order_by_node.offset, order_by_node.fetch);
        }
        HEAVYDBLOGGER.debug("desugar:  after: " + select_node.toString());
        return new_order_by_node;
    }

    private void desugarExpression(SqlNode node, RelDataTypeFactory typeFactory) {
        if (node instanceof SqlSelect) {
            this.desugar((SqlSelect)node, typeFactory);
            return;
        }
        if (!(node instanceof SqlBasicCall)) {
            return;
        }
        SqlBasicCall basic_call = (SqlBasicCall)node;
        for (SqlNode operator : basic_call.getOperands()) {
            if (operator instanceof SqlOrderBy) {
                this.desugarExpression(((SqlOrderBy)operator).query, typeFactory);
                continue;
            }
            this.desugarExpression(operator, typeFactory);
        }
    }

    private SqlNode expand(SqlNode node, Map<String, SqlNode> id_to_expr, RelDataTypeFactory typeFactory) {
        HEAVYDBLOGGER.debug("expand: " + node.toString());
        if (node instanceof SqlBasicCall) {
            SqlBasicCall node_call = (SqlBasicCall)node;
            SqlNode[] operands = node_call.getOperands();
            for (int i = 0; i < operands.length; ++i) {
                node_call.setOperand(i, this.expand(operands[i], id_to_expr, typeFactory));
            }
            SqlNode expanded_string_function = this.expandStringFunctions(node_call, typeFactory);
            if (expanded_string_function != null) {
                return expanded_string_function;
            }
            SqlNode expanded_variance = this.expandVariance(node_call, typeFactory);
            if (expanded_variance != null) {
                return expanded_variance;
            }
            SqlNode expanded_covariance = this.expandCovariance(node_call, typeFactory);
            if (expanded_covariance != null) {
                return expanded_covariance;
            }
            SqlNode expanded_correlation = this.expandCorrelation(node_call, typeFactory);
            if (expanded_correlation != null) {
                return expanded_correlation;
            }
        }
        if (node instanceof SqlSelect) {
            SqlSelect select_node = (SqlSelect)node;
            this.desugar(select_node, typeFactory);
        }
        return node;
    }

    private SqlNodeList expand(SqlNodeList group_by_list, Map<String, SqlNode> id_to_expr, RelDataTypeFactory typeFactory) {
        SqlNodeList new_group_by_list = new SqlNodeList(new SqlParserPos(-1, -1));
        for (SqlNode group_by : group_by_list) {
            if (!(group_by instanceof SqlIdentifier)) {
                new_group_by_list.add(this.expand(group_by, id_to_expr, typeFactory));
                continue;
            }
            SqlIdentifier group_by_id = (SqlIdentifier)group_by;
            if (id_to_expr.containsKey(group_by_id.toString())) {
                new_group_by_list.add(id_to_expr.get(group_by_id.toString()));
                continue;
            }
            new_group_by_list.add(group_by);
        }
        return new_group_by_list;
    }

    private SqlNode expandStringFunctions(SqlBasicCall proj_call, RelDataTypeFactory typeFactory) {
        int operandCount = proj_call.operandCount();
        if (proj_call.getOperator().isName("MID", false) || proj_call.getOperator().isName("SUBSTR", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object primary_operand = proj_call.operand(0);
                Object from_operand = proj_call.operand(1);
                return SqlStdOperatorTable.SUBSTRING.createCall(pos, new SqlNode[]{primary_operand, from_operand});
            }
            if (operandCount == 3) {
                Object primary_operand = proj_call.operand(0);
                Object from_operand = proj_call.operand(1);
                Object for_operand = proj_call.operand(2);
                return SqlStdOperatorTable.SUBSTRING.createCall(pos, new SqlNode[]{primary_operand, from_operand, for_operand});
            }
            return null;
        }
        if (proj_call.getOperator().isName("CONTAINS", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object primary = proj_call.operand(0);
                Object pattern = proj_call.operand(1);
                if (pattern instanceof SqlLiteral) {
                    SqlLiteral literalPattern = (SqlLiteral)pattern;
                    String sPattern = literalPattern.getValueAs(String.class);
                    SqlCharStringLiteral withWildcards = SqlLiteral.createCharString("%" + sPattern + "%", pos);
                    return SqlStdOperatorTable.LIKE.createCall(pos, new SqlNode[]{primary, withWildcards});
                }
            }
            return null;
        }
        if (proj_call.getOperator().isName("ENDSWITH", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object primary = proj_call.operand(0);
                Object pattern = proj_call.operand(1);
                if (pattern instanceof SqlLiteral) {
                    SqlLiteral literalPattern = (SqlLiteral)pattern;
                    String sPattern = literalPattern.getValueAs(String.class);
                    SqlCharStringLiteral withWildcards = SqlLiteral.createCharString("%" + sPattern, pos);
                    return SqlStdOperatorTable.LIKE.createCall(pos, new SqlNode[]{primary, withWildcards});
                }
            }
            return null;
        }
        if (proj_call.getOperator().isName("LCASE", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 1) {
                Object primary = proj_call.operand(0);
                return SqlStdOperatorTable.LOWER.createCall(pos, new SqlNode[]{primary});
            }
            return null;
        }
        if (proj_call.getOperator().isName("LEFT", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object primary = proj_call.operand(0);
                SqlNumericLiteral start = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
                Object count = proj_call.operand(1);
                return SqlStdOperatorTable.SUBSTRING.createCall(pos, new SqlNode[]{primary, start, count});
            }
            return null;
        }
        if (proj_call.getOperator().isName("LEN", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 1) {
                Object primary = proj_call.operand(0);
                return SqlStdOperatorTable.CHARACTER_LENGTH.createCall(pos, new SqlNode[]{primary});
            }
            return null;
        }
        if (proj_call.getOperator().isName("MAX", false) || proj_call.getOperator().isName("MIN", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object arg1 = proj_call.operand(0);
                Object arg2 = proj_call.operand(1);
                SqlNodeList whenList = new SqlNodeList(pos);
                SqlNodeList thenList = new SqlNodeList(pos);
                SqlNodeList elseClause = new SqlNodeList(pos);
                if (proj_call.getOperator().isName("MAX", false)) {
                    whenList.add(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL.createCall(pos, new SqlNode[]{arg1, arg2}));
                } else {
                    whenList.add(SqlStdOperatorTable.LESS_THAN_OR_EQUAL.createCall(pos, new SqlNode[]{arg1, arg2}));
                }
                thenList.add((SqlNode)arg1);
                elseClause.add((SqlNode)arg2);
                SqlNode caseIdentifier = null;
                return SqlCase.createSwitched(pos, caseIdentifier, whenList, thenList, elseClause);
            }
            return null;
        }
        if (proj_call.getOperator().isName("RIGHT", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object primary = proj_call.operand(0);
                Object count = proj_call.operand(1);
                if (count instanceof SqlNumericLiteral) {
                    SqlNumericLiteral numericCount = (SqlNumericLiteral)count;
                    if (numericCount.intValue(true) > 0) {
                        SqlNumericLiteral negativeCount = SqlNumericLiteral.createNegative(numericCount, pos);
                        return SqlStdOperatorTable.SUBSTRING.createCall(pos, new SqlNode[]{primary, negativeCount});
                    }
                    SqlNumericLiteral zero = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
                    return SqlStdOperatorTable.SUBSTRING.createCall(pos, new SqlNode[]{primary, zero, zero});
                }
                return SqlStdOperatorTable.SUBSTRING.createCall(pos, new SqlNode[]{primary, count});
            }
            return null;
        }
        if (proj_call.getOperator().isName("SPACE", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 1) {
                Object count = proj_call.operand(0);
                SqlFunction fn_repeat = new SqlFunction("REPEAT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
                SqlCharStringLiteral space = SqlLiteral.createCharString(" ", pos);
                return fn_repeat.createCall(pos, new SqlNode[]{space, count});
            }
            return null;
        }
        if (proj_call.getOperator().isName("SPLIT", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 3) {
                Object primary = proj_call.operand(0);
                Object delimeter = proj_call.operand(1);
                Object count = proj_call.operand(2);
                SqlFunction fn_split = new SqlFunction("SPLIT_PART", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
                return fn_split.createCall(pos, new SqlNode[]{primary, delimeter, count});
            }
            return null;
        }
        if (proj_call.getOperator().isName("STARTSWITH", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 2) {
                Object primary = proj_call.operand(0);
                Object pattern = proj_call.operand(1);
                if (pattern instanceof SqlLiteral) {
                    SqlLiteral literalPattern = (SqlLiteral)pattern;
                    String sPattern = literalPattern.getValueAs(String.class);
                    SqlCharStringLiteral withWildcards = SqlLiteral.createCharString(sPattern + "%", pos);
                    return SqlStdOperatorTable.LIKE.createCall(pos, new SqlNode[]{primary, withWildcards});
                }
            }
            return null;
        }
        if (proj_call.getOperator().isName("UCASE", false)) {
            SqlParserPos pos = proj_call.getParserPosition();
            if (operandCount == 1) {
                Object primary = proj_call.operand(0);
                return SqlStdOperatorTable.UPPER.createCall(pos, new SqlNode[]{primary});
            }
            return null;
        }
        return null;
    }

    private SqlNode expandVariance(SqlBasicCall proj_call, RelDataTypeFactory typeFactory) {
        boolean flt;
        boolean sqrt;
        boolean biased;
        if (proj_call.operandCount() != 1) {
            return null;
        }
        if (proj_call.getOperator().isName("STDDEV_POP", false)) {
            biased = true;
            sqrt = true;
            flt = false;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("STDDEV_POP_FLOAT")) {
            biased = true;
            sqrt = true;
            flt = true;
        } else if (proj_call.getOperator().isName("STDDEV_SAMP", false) || proj_call.getOperator().getName().equalsIgnoreCase("STDDEV")) {
            biased = false;
            sqrt = true;
            flt = false;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("STDDEV_SAMP_FLOAT") || proj_call.getOperator().getName().equalsIgnoreCase("STDDEV_FLOAT")) {
            biased = false;
            sqrt = true;
            flt = true;
        } else if (proj_call.getOperator().isName("VAR_POP", false)) {
            biased = true;
            sqrt = false;
            flt = false;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("VAR_POP_FLOAT")) {
            biased = true;
            sqrt = false;
            flt = true;
        } else if (proj_call.getOperator().isName("VAR_SAMP", false) || proj_call.getOperator().getName().equalsIgnoreCase("VARIANCE")) {
            biased = false;
            sqrt = false;
            flt = false;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("VAR_SAMP_FLOAT") || proj_call.getOperator().getName().equalsIgnoreCase("VARIANCE_FLOAT")) {
            biased = false;
            sqrt = false;
            flt = true;
        } else {
            return null;
        }
        Object operand = proj_call.operand(0);
        SqlParserPos pos = proj_call.getParserPosition();
        SqlNode expanded_proj_call = this.expandVariance(pos, (SqlNode)operand, biased, sqrt, flt, typeFactory);
        HEAVYDBLOGGER.debug("Expanded select_list SqlCall: " + proj_call.toString());
        HEAVYDBLOGGER.debug("to : " + expanded_proj_call.toString());
        return expanded_proj_call;
    }

    private SqlNode expandVariance(SqlParserPos pos, SqlNode operand, boolean biased, boolean sqrt, boolean flt, RelDataTypeFactory typeFactory) {
        SqlCall div;
        SqlCall denominator1;
        SqlCall arg = SqlStdOperatorTable.CAST.createCall(pos, operand, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        SqlCall argSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg, arg);
        SqlCall sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquared);
        SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
        SqlCall sumSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, sum, sum);
        SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
        SqlLiteral nul = SqlLiteral.createNull(pos);
        SqlNumericLiteral zero = SqlLiteral.createExactNumeric("0", pos);
        SqlCall countEqZero = SqlStdOperatorTable.EQUALS.createCall(pos, count, zero);
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        whenList.add(countEqZero);
        thenList.add(nul);
        SqlCall int_denominator = SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList, thenList, count);
        SqlCall denominator = SqlStdOperatorTable.CAST.createCall(pos, int_denominator, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        SqlCall avgSumSquared = SqlStdOperatorTable.DIVIDE.createCall(pos, sumSquared, denominator);
        SqlCall diff = SqlStdOperatorTable.MINUS.createCall(pos, sumArgSquared, avgSumSquared);
        if (biased) {
            denominator1 = denominator;
        } else {
            SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
            SqlCall countEqOne = SqlStdOperatorTable.EQUALS.createCall(pos, count, one);
            SqlCall countMinusOne = SqlStdOperatorTable.MINUS.createCall(pos, count, one);
            SqlNodeList whenList1 = new SqlNodeList(pos);
            SqlNodeList thenList1 = new SqlNodeList(pos);
            whenList1.add(countEqOne);
            thenList1.add(nul);
            SqlCall int_denominator1 = SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList1, thenList1, countMinusOne);
            denominator1 = SqlStdOperatorTable.CAST.createCall(pos, int_denominator1, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        }
        SqlCall result = div = SqlStdOperatorTable.DIVIDE.createCall(pos, diff, denominator1);
        if (sqrt) {
            SqlNumericLiteral half = SqlLiteral.createExactNumeric("0.5", pos);
            result = SqlStdOperatorTable.POWER.createCall(pos, div, half);
        }
        return SqlStdOperatorTable.CAST.createCall(pos, result, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
    }

    private SqlNode expandCovariance(SqlBasicCall proj_call, RelDataTypeFactory typeFactory) {
        boolean flt;
        boolean pop;
        if (proj_call.operandCount() != 2) {
            return null;
        }
        if (proj_call.getOperator().isName("COVAR_POP", false)) {
            pop = true;
            flt = false;
        } else if (proj_call.getOperator().isName("COVAR_SAMP", false)) {
            pop = false;
            flt = false;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("COVAR_POP_FLOAT")) {
            pop = true;
            flt = true;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("COVAR_SAMP_FLOAT")) {
            pop = false;
            flt = true;
        } else {
            return null;
        }
        Object operand0 = proj_call.operand(0);
        Object operand1 = proj_call.operand(1);
        SqlParserPos pos = proj_call.getParserPosition();
        SqlNode expanded_proj_call = this.expandCovariance(pos, (SqlNode)operand0, (SqlNode)operand1, pop, flt, typeFactory);
        HEAVYDBLOGGER.debug("Expanded select_list SqlCall: " + proj_call.toString());
        HEAVYDBLOGGER.debug("to : " + expanded_proj_call.toString());
        return expanded_proj_call;
    }

    private SqlNode expandCovariance(SqlParserPos pos, SqlNode operand0, SqlNode operand1, boolean pop, boolean flt, RelDataTypeFactory typeFactory) {
        SqlCall arg0 = SqlStdOperatorTable.CAST.createCall(operand0.getParserPosition(), operand0, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        SqlCall arg1 = SqlStdOperatorTable.CAST.createCall(operand1.getParserPosition(), operand1, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        SqlCall mulArg = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg0, arg1);
        SqlCall avgArg1 = SqlStdOperatorTable.AVG.createCall(pos, arg1);
        if (pop) {
            SqlCall avgMulArg = SqlStdOperatorTable.AVG.createCall(pos, mulArg);
            SqlCall avgArg0 = SqlStdOperatorTable.AVG.createCall(pos, arg0);
            SqlCall mulAvgAvg = SqlStdOperatorTable.MULTIPLY.createCall(pos, avgArg0, avgArg1);
            SqlCall covarPop = SqlStdOperatorTable.MINUS.createCall(pos, avgMulArg, mulAvgAvg);
            return SqlStdOperatorTable.CAST.createCall(pos, covarPop, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        }
        SqlCall sumMulArg = SqlStdOperatorTable.SUM.createCall(pos, mulArg);
        SqlCall sumArg0 = SqlStdOperatorTable.SUM.createCall(pos, arg0);
        SqlCall mulSumAvg = SqlStdOperatorTable.MULTIPLY.createCall(pos, sumArg0, avgArg1);
        SqlCall sub = SqlStdOperatorTable.MINUS.createCall(pos, sumMulArg, mulSumAvg);
        SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, operand0);
        SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
        SqlCall countEqOne = SqlStdOperatorTable.EQUALS.createCall(pos, count, one);
        SqlCall countMinusOne = SqlStdOperatorTable.MINUS.createCall(pos, count, one);
        SqlLiteral nul = SqlLiteral.createNull(pos);
        SqlNodeList whenList1 = new SqlNodeList(pos);
        SqlNodeList thenList1 = new SqlNodeList(pos);
        whenList1.add(countEqOne);
        thenList1.add(nul);
        SqlCall int_denominator = SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList1, thenList1, countMinusOne);
        SqlCall denominator = SqlStdOperatorTable.CAST.createCall(pos, int_denominator, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
        SqlCall covarSamp = SqlStdOperatorTable.DIVIDE.createCall(pos, sub, denominator);
        return SqlStdOperatorTable.CAST.createCall(pos, covarSamp, SqlTypeUtil.convertTypeToSpec(typeFactory.createSqlType(flt ? SqlTypeName.FLOAT : SqlTypeName.DOUBLE)));
    }

    private SqlNode expandCorrelation(SqlBasicCall proj_call, RelDataTypeFactory typeFactory) {
        boolean flt;
        if (proj_call.operandCount() != 2) {
            return null;
        }
        if (proj_call.getOperator().isName("CORR", false) || proj_call.getOperator().getName().equalsIgnoreCase("CORRELATION")) {
            flt = false;
        } else if (proj_call.getOperator().getName().equalsIgnoreCase("CORR_FLOAT") || proj_call.getOperator().getName().equalsIgnoreCase("CORRELATION_FLOAT")) {
            flt = true;
        } else {
            return null;
        }
        Object operand0 = proj_call.operand(0);
        Object operand1 = proj_call.operand(1);
        SqlParserPos pos = proj_call.getParserPosition();
        SqlNode covariance = this.expandCovariance(pos, (SqlNode)operand0, (SqlNode)operand1, true, flt, typeFactory);
        SqlNode stddev0 = this.expandVariance(pos, (SqlNode)operand0, true, true, flt, typeFactory);
        SqlNode stddev1 = this.expandVariance(pos, (SqlNode)operand1, true, true, flt, typeFactory);
        SqlCall mulStddev = SqlStdOperatorTable.MULTIPLY.createCall(pos, stddev0, stddev1);
        SqlNumericLiteral zero = SqlLiteral.createExactNumeric("0.0", pos);
        SqlCall mulStddevEqZero = SqlStdOperatorTable.EQUALS.createCall(pos, mulStddev, zero);
        SqlLiteral nul = SqlLiteral.createNull(pos);
        SqlNodeList whenList1 = new SqlNodeList(pos);
        SqlNodeList thenList1 = new SqlNodeList(pos);
        whenList1.add(mulStddevEqZero);
        thenList1.add(nul);
        SqlCall denominator = SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList1, thenList1, mulStddev);
        SqlCall expanded_proj_call = SqlStdOperatorTable.DIVIDE.createCall(pos, covariance, denominator);
        HEAVYDBLOGGER.debug("Expanded select_list SqlCall: " + proj_call.toString());
        HEAVYDBLOGGER.debug("to : " + expanded_proj_call.toString());
        return expanded_proj_call;
    }

    public SqlIdentifierCapturer captureIdentifiers(String sql, boolean legacy_syntax) throws SqlParseException {
        try {
            HeavyDBPlanner planner = this.getPlanner();
            SqlNode node = this.parseSql(sql, legacy_syntax, planner);
            return this.captureIdentifiers(node);
        }
        catch (Error | Exception e) {
            HEAVYDBLOGGER.error("Error parsing sql: " + sql, e);
            return new SqlIdentifierCapturer();
        }
    }

    public SqlIdentifierCapturer captureIdentifiers(SqlNode node) throws SqlParseException {
        try {
            SqlIdentifierCapturer capturer = new SqlIdentifierCapturer();
            capturer.scan(node);
            capturer.selects = this.addDbContextIfMissing(capturer.selects);
            capturer.updates = this.addDbContextIfMissing(capturer.updates);
            capturer.deletes = this.addDbContextIfMissing(capturer.deletes);
            capturer.inserts = this.addDbContextIfMissing(capturer.inserts);
            return capturer;
        }
        catch (Error | Exception e) {
            HEAVYDBLOGGER.error("Error parsing sql: " + node, e);
            return new SqlIdentifierCapturer();
        }
    }

    private Set<ImmutableList<String>> addDbContextIfMissing(Set<ImmutableList<String>> names) {
        HashSet<ImmutableList<String>> result = new HashSet<ImmutableList<String>>();
        for (ImmutableList<String> name : names) {
            if (name.size() == 1) {
                result.add((ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(name)).add(this.dbUser.getDB())).build());
                continue;
            }
            result.add(name);
        }
        return result;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void updateMetaData(String schema, String table) {
        HEAVYDBLOGGER.debug("schema :" + schema + " table :" + table);
        HeavyDBSchema db = new HeavyDBSchema(this.dataDir, this, this.dbPort, null, this.sock_transport_properties, schema);
        db.updateMetaData(schema, table);
    }

    protected RelDataTypeSystem createTypeSystem() {
        HeavyDBTypeSystem typeSystem = new HeavyDBTypeSystem();
        return typeSystem;
    }

    public void tableAliasFinder(SqlNode sqlNode, final Map<String, String> tableAliasMap) {
        SqlBasicVisitor<Void> aliasCollector = new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                SqlBasicCall basicCall;
                if (call instanceof SqlBasicCall && (basicCall = (SqlBasicCall)call).getKind() == SqlKind.AS && basicCall.operand(0) instanceof SqlIdentifier) {
                    SqlIdentifier colNameIdentifier = (SqlIdentifier)basicCall.operand(0);
                    String tblName = colNameIdentifier.names.size() == 1 ? (String)colNameIdentifier.names.get(0) : (String)colNameIdentifier.names.get(1);
                    tableAliasMap.put(((SqlNode)basicCall.operand(1)).toString(), tblName);
                }
                return (Void)super.visit(call);
            }
        };
        sqlNode.accept(aliasCollector);
    }

    private static class FindSqlOperator
    extends SqlBasicVisitor<Void> {
        private SqlKind targetKind;

        private FindSqlOperator() {
        }

        @Override
        public Void visit(SqlCall call) {
            SqlBasicCall basicCall;
            if (call instanceof SqlBasicCall && (basicCall = (SqlBasicCall)call).getKind().equals((Object)this.targetKind)) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visit(call);
        }

        boolean containsSqlOperator(SqlNode node, SqlKind operatorKind) {
            try {
                this.targetKind = operatorKind;
                node.accept(this);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }

    private static class JoinOperatorChecker
    extends SqlBasicVisitor<Void> {
        Set<SqlBasicCall> targetCalls = new HashSet<SqlBasicCall>();

        private JoinOperatorChecker() {
        }

        public boolean isEqualityJoinOperator(SqlBasicCall basicCall) {
            return null != basicCall && basicCall.operands.length == 2 && (basicCall.getKind() == SqlKind.EQUALS || basicCall.getKind() == SqlKind.NOT_EQUALS) && basicCall.operand(0) instanceof SqlIdentifier && basicCall.operand(1) instanceof SqlIdentifier;
        }

        @Override
        public Void visit(SqlCall call) {
            if (call instanceof SqlBasicCall) {
                this.targetCalls.add((SqlBasicCall)call);
            }
            for (SqlNode node : call.getOperandList()) {
                if (null == node || this.targetCalls.contains(node)) continue;
                node.accept(this);
            }
            return (Void)super.visit(call);
        }

        boolean containsExpression(SqlNode node) {
            try {
                if (null != node) {
                    node.accept(this);
                    for (SqlBasicCall basicCall : this.targetCalls) {
                        if (!this.isEqualityJoinOperator(basicCall)) continue;
                        throw Util.FoundOne.NULL;
                    }
                }
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }

    private static class ExpressionListedAsChildOROperatorChecker
    extends SqlBasicVisitor<Void> {
        SqlNode targetExpression;

        private ExpressionListedAsChildOROperatorChecker() {
        }

        @Override
        public Void visit(SqlCall call) {
            SqlBasicCall basicCall;
            if (call instanceof SqlBasicCall && (basicCall = (SqlBasicCall)call).getKind() == SqlKind.OR) {
                String targetString = this.targetExpression.toString();
                for (SqlNode listedOperand : basicCall.operands) {
                    if (!listedOperand.toString().contains(targetString)) continue;
                    throw Util.FoundOne.NULL;
                }
            }
            return (Void)super.visit(call);
        }

        boolean containsExpression(SqlNode node, SqlNode targetExpression) {
            try {
                this.targetExpression = targetExpression;
                node.accept(this);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }

    private static class ExpressionListedInSelectClauseChecker
    extends SqlBasicVisitor<Void> {
        SqlNode targetExpression;

        private ExpressionListedInSelectClauseChecker() {
        }

        @Override
        public Void visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                SqlSelect selectNode = (SqlSelect)call;
                String targetString = this.targetExpression.toString();
                for (SqlNode listedNode : selectNode.getSelectList()) {
                    if (!listedNode.toString().contains(targetString)) continue;
                    throw Util.FoundOne.NULL;
                }
            }
            return (Void)super.visit(call);
        }

        boolean containsExpression(SqlNode node, SqlNode targetExpression) {
            try {
                this.targetExpression = targetExpression;
                node.accept(this);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }
}

