/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import com.mapd.parser.extension.ddl.heavydb.HeavyDBOptionsMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlCreateModel
extends SqlCreate {
    public final SqlIdentifier modelType;
    public final SqlIdentifier name;
    public final SqlNode query;
    private final HeavyDBOptionsMap options;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE MODEL", SqlKind.OTHER_DDL);

    protected SqlCreateModel(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier modelType, SqlIdentifier name, HeavyDBOptionsMap withOptions, SqlNode query) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.modelType = Objects.requireNonNull(modelType);
        this.name = Objects.requireNonNull(name);
        this.options = withOptions;
        this.query = query;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.modelType, this.name, this.query);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("MODEL");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        writer.keyword("OF TYPE");
        this.modelType.unparse(writer, leftPrec, rightPrec);
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.query != null) {
            writer.keyword("AS");
            writer.newlineAndIndent();
            this.query.unparse(writer, 0, 0);
        }
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        jsonBuilder.put(map, "command", "CREATE_MODEL");
        jsonBuilder.put(map, "type", this.modelType.toString());
        jsonBuilder.put(map, "name", this.name.toString());
        if (this.query != null) {
            SqlWriterConfig c = SqlPrettyWriter.config().withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withSelectListItemsOnSeparateLines(false).withWhereListItemsOnSeparateLines(false).withValuesListNewline(false);
            SqlPrettyWriter writer = new SqlPrettyWriter(c);
            this.query.unparse(writer, 0, 0);
            jsonBuilder.put(map, "query", writer.toString());
        }
        jsonBuilder.put(map, "replace", this.getReplace());
        jsonBuilder.put(map, "ifNotExists", this.ifNotExists);
        map.put("options", this.options);
        Map<String, Object> payload = jsonBuilder.map();
        payload.put("payload", map);
        return jsonBuilder.toJsonString(payload);
    }
}

