/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.server;

import ai.heavy.thrift.calciteserver.CalciteServer;
import com.mapd.common.SockTransportProperties;
import com.mapd.parser.server.CalciteServerHandler;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteServerWrapper
implements Runnable {
    private static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(CalciteServerWrapper.class);
    private final CalciteServerHandler handler;
    private final CalciteServer.Processor processor;
    private TServer server;
    private int heavyDBPort = 6274;
    private String dataDir = "data/";
    private int calcitePort = 6279;
    private boolean shutdown = false;
    private SockTransportProperties server_skT_;

    public CalciteServerWrapper() {
        this.handler = new CalciteServerHandler(this.heavyDBPort, this.dataDir, null, null, "");
        this.processor = new CalciteServer.Processor<CalciteServerHandler>(this.handler);
    }

    public CalciteServerWrapper(int calcitePort, int heavyDBPort, String dataDir, String extensionFunctionsAstFile, SockTransportProperties client_skT, SockTransportProperties server_skT) {
        this.handler = new CalciteServerHandler(heavyDBPort, dataDir, extensionFunctionsAstFile, client_skT, "");
        this.processor = new CalciteServer.Processor<CalciteServerHandler>(this.handler);
        this.calcitePort = calcitePort;
        this.heavyDBPort = heavyDBPort;
        this.server_skT_ = server_skT;
    }

    public CalciteServerWrapper(int calcitePort, int heavyDBPort, String dataDir, String extensionFunctionsAstFile, SockTransportProperties client_skT, SockTransportProperties server_skT, String userDefinedFunctionsFile) {
        this.handler = new CalciteServerHandler(heavyDBPort, dataDir, extensionFunctionsAstFile, client_skT, userDefinedFunctionsFile);
        this.processor = new CalciteServer.Processor<CalciteServerHandler>(this.handler);
        this.calcitePort = calcitePort;
        this.heavyDBPort = heavyDBPort;
        this.server_skT_ = server_skT;
    }

    private void startServer(CalciteServer.Processor processor) {
        try {
            TServerTransport serverTransport = this.server_skT_.openServerTransport(this.calcitePort);
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(processor));
            HEAVYDBLOGGER.debug("Starting a threaded pool server... Listening on port " + this.calcitePort + " HEAVY.AI on port " + this.heavyDBPort);
            this.handler.setServer(this.server);
            this.server.serve();
            this.shutdown = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            HEAVYDBLOGGER.error(" Calcite server Failed to start ");
            this.shutdown = true;
        }
    }

    public void stopServer() {
        this.server.stop();
        this.shutdown = true;
    }

    @Override
    public void run() {
        this.startServer(this.processor);
    }

    boolean shutdown() {
        return this.shutdown;
    }
}

