/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.server;

import com.mapd.parser.server.ExtensionFunction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtensionFunctionSignatureParser {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(ExtensionFunctionSignatureParser.class);
    private static String OS = System.getProperty("os.name").toLowerCase();

    ExtensionFunctionSignatureParser() {
    }

    private static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    static Map<String, ExtensionFunction> parse(String file_path) throws IOException {
        String line;
        File file = new File(file_path);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Pattern s2 = Pattern.compile("\\| ([\\` ]|used)+ ([\\w]+) '([\\w<>]+) \\((.*)\\)'");
        HashMap<String, ExtensionFunction> sigs = new HashMap<String, ExtensionFunction>();
        while ((line = bufferedReader.readLine()) != null) {
            Matcher m3 = s2.matcher(line);
            if (!m3.find()) continue;
            String name = m3.group(2);
            String ret = m3.group(3);
            String cs_param_list = m3.group(4);
            sigs.put(name, ExtensionFunctionSignatureParser.toSignature(ret, cs_param_list, false));
        }
        return sigs;
    }

    static Map<String, ExtensionFunction> parseUdfAst(String file_path) throws IOException {
        String line;
        File file = new File(file_path);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Pattern s2 = Pattern.compile("([<>:\\w]+) ([:\\w]+)(?:\\(\\))?\\((.*)\\)");
        HashMap<String, ExtensionFunction> sigs = new HashMap<String, ExtensionFunction>();
        while ((line = bufferedReader.readLine()) != null) {
            Matcher m3 = s2.matcher(line);
            if (!m3.find()) continue;
            String name = m3.group(2);
            String ret = m3.group(1);
            String cs_param_list = m3.group(3);
            if (cs_param_list.isEmpty()) continue;
            sigs.put(name, ExtensionFunctionSignatureParser.toSignature(ret, cs_param_list, true));
        }
        return sigs;
    }

    static Map<String, ExtensionFunction> parseFromString(String udf_string) throws IOException {
        return ExtensionFunctionSignatureParser.parseFromString(udf_string, true);
    }

    static Map<String, ExtensionFunction> parseFromString(String udf_string, boolean is_row_func) throws IOException {
        String line;
        StringReader stringReader = new StringReader(udf_string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        Pattern r = Pattern.compile("([\\w]+)\\s+'([\\w]+)\\s*\\((.*)\\)'");
        HashMap<String, ExtensionFunction> sigs = new HashMap<String, ExtensionFunction>();
        while ((line = bufferedReader.readLine()) != null) {
            Matcher m3 = r.matcher(line);
            if (!m3.find()) continue;
            String name = m3.group(1);
            String ret = m3.group(2);
            String cs_param_list = m3.group(3);
            sigs.put(name, ExtensionFunctionSignatureParser.toSignature(ret, cs_param_list, is_row_func));
        }
        return sigs;
    }

    static String signaturesToJson(Map<String, ExtensionFunction> sigs) {
        ArrayList<String> json_sigs = new ArrayList<String>();
        if (sigs != null) {
            for (Map.Entry<String, ExtensionFunction> sig : sigs.entrySet()) {
                if (!sig.getValue().isRowUdf()) continue;
                json_sigs.add(sig.getValue().toJson(sig.getKey()));
            }
        }
        return "[" + ExtensionFunctionSignatureParser.join(json_sigs, ",") + "]";
    }

    private static ExtensionFunction toSignature(String ret, String cs_param_list, boolean has_variable_name) {
        return ExtensionFunctionSignatureParser.toSignature(ret, cs_param_list, has_variable_name, true);
    }

    private static ExtensionFunction toSignature(String ret, String cs_param_list, boolean has_variable_name, boolean is_row_func) {
        String[] params = cs_param_list.split(",");
        ArrayList<ExtensionFunction.ExtArgumentType> args = new ArrayList<ExtensionFunction.ExtArgumentType>();
        String uses_manager = "false";
        ArrayList<Map<String, String>> annotations = new ArrayList<Map<String, String>>();
        for (String param : params) {
            ExtensionFunction.ExtArgumentType arg_type;
            if (param.contains("RowFunctionManager")) {
                uses_manager = "true";
                continue;
            }
            if (has_variable_name) {
                String[] full_param = param.trim().split("\\s+");
                if (full_param.length > 0) {
                    if (full_param[0].trim().compareTo("const") == 0) {
                        assert (full_param.length > 1);
                        arg_type = ExtensionFunctionSignatureParser.deserializeType(full_param[1].trim());
                    } else {
                        arg_type = ExtensionFunctionSignatureParser.deserializeType(full_param[0].trim());
                    }
                } else {
                    arg_type = ExtensionFunctionSignatureParser.deserializeType(full_param[0]);
                }
            } else {
                arg_type = ExtensionFunctionSignatureParser.deserializeType(param.trim());
            }
            annotations.add(Collections.EMPTY_MAP);
            if (arg_type == ExtensionFunction.ExtArgumentType.Void) continue;
            args.add(arg_type);
        }
        assert (is_row_func);
        annotations.add(Collections.singletonMap("uses_manager", uses_manager));
        return new ExtensionFunction(args, ExtensionFunctionSignatureParser.deserializeType(ret), annotations);
    }

    private static ExtensionFunction.ExtArgumentType deserializeType(String type_name) {
        String const_prefix = "const ";
        String std_namespace_prefix = "std::";
        if (type_name.startsWith("const ")) {
            return ExtensionFunctionSignatureParser.deserializeType(type_name.substring("const ".length()));
        }
        if (type_name.startsWith("std::")) {
            return ExtensionFunctionSignatureParser.deserializeType(type_name.substring("std::".length()));
        }
        if (type_name.equals("bool") || type_name.equals("_Bool")) {
            return ExtensionFunction.ExtArgumentType.Bool;
        }
        if (type_name.equals("int8_t") || type_name.equals("char") || type_name.equals("int8")) {
            return ExtensionFunction.ExtArgumentType.Int8;
        }
        if (type_name.equals("int16_t") || type_name.equals("short") || type_name.equals("int16")) {
            return ExtensionFunction.ExtArgumentType.Int16;
        }
        if (type_name.equals("int32_t") || type_name.equals("int") || type_name.equals("int32") || ExtensionFunctionSignatureParser.isWindows() && type_name.equals("long")) {
            return ExtensionFunction.ExtArgumentType.Int32;
        }
        if (type_name.equals("int64_t") || type_name.equals("size_t") || type_name.equals("int64")) {
            return ExtensionFunction.ExtArgumentType.Int64;
        }
        if (!ExtensionFunctionSignatureParser.isWindows() && type_name.equals("long") || ExtensionFunctionSignatureParser.isWindows() && type_name.equals("long long")) {
            return ExtensionFunction.ExtArgumentType.Int64;
        }
        if (type_name.equals("float") || type_name.equals("float32")) {
            return ExtensionFunction.ExtArgumentType.Float;
        }
        if (type_name.equals("double") || type_name.equals("float64")) {
            return ExtensionFunction.ExtArgumentType.Double;
        }
        if (type_name.isEmpty() || type_name.equals("void")) {
            return ExtensionFunction.ExtArgumentType.Void;
        }
        if (type_name.endsWith(" *")) {
            return ExtensionFunctionSignatureParser.pointerType(ExtensionFunctionSignatureParser.deserializeType(type_name.substring(0, type_name.length() - 2)));
        }
        if (type_name.endsWith("*")) {
            return ExtensionFunctionSignatureParser.pointerType(ExtensionFunctionSignatureParser.deserializeType(type_name.substring(0, type_name.length() - 1)));
        }
        if (type_name.endsWith("&")) {
            return ExtensionFunctionSignatureParser.deserializeType(type_name.substring(0, type_name.length() - 1).trim());
        }
        if (type_name.equals("Array<bool>")) {
            return ExtensionFunction.ExtArgumentType.ArrayBool;
        }
        if (type_name.equals("Array<int8_t>") || type_name.equals("Array<char>")) {
            return ExtensionFunction.ExtArgumentType.ArrayInt8;
        }
        if (type_name.equals("Array<int16_t>") || type_name.equals("Array<short>")) {
            return ExtensionFunction.ExtArgumentType.ArrayInt16;
        }
        if (type_name.equals("Array<int32_t>") || type_name.equals("Array<int>")) {
            return ExtensionFunction.ExtArgumentType.ArrayInt32;
        }
        if (type_name.equals("Array<int64_t>") || type_name.equals("Array<size_t>") || type_name.equals("Array<long>")) {
            return ExtensionFunction.ExtArgumentType.ArrayInt64;
        }
        if (type_name.equals("Array<float>")) {
            return ExtensionFunction.ExtArgumentType.ArrayFloat;
        }
        if (type_name.equals("Array<double>")) {
            return ExtensionFunction.ExtArgumentType.ArrayDouble;
        }
        if (type_name.equals("Array<bool>")) {
            return ExtensionFunction.ExtArgumentType.ArrayBool;
        }
        if (type_name.equals("Array<TextEncodingDict>")) {
            return ExtensionFunction.ExtArgumentType.ArrayTextEncodingDict;
        }
        if (type_name.equals("Array<TextEncodingNone>")) {
            return ExtensionFunction.ExtArgumentType.ArrayTextEncodingNone;
        }
        if (type_name.equals("TextEncodingDict")) {
            return ExtensionFunction.ExtArgumentType.TextEncodingDict;
        }
        if (type_name.equals("RowFunctionManager")) {
            return ExtensionFunction.ExtArgumentType.Void;
        }
        if (type_name.equals("Timestamp")) {
            return ExtensionFunction.ExtArgumentType.Timestamp;
        }
        if (type_name.equals("TextEncodingNone")) {
            return ExtensionFunction.ExtArgumentType.TextEncodingNone;
        }
        if (type_name.equals("Column<int8_t>") || type_name.equals("Column<char>")) {
            return ExtensionFunction.ExtArgumentType.ColumnInt8;
        }
        if (type_name.equals("Column<int16_t>") || type_name.equals("Column<short>")) {
            return ExtensionFunction.ExtArgumentType.ColumnInt16;
        }
        if (type_name.equals("Column<int32_t>") || type_name.equals("Column<int>")) {
            return ExtensionFunction.ExtArgumentType.ColumnInt32;
        }
        if (type_name.equals("Column<int64_t>") || type_name.equals("Column<size_t>") || type_name.equals("Column<long>")) {
            return ExtensionFunction.ExtArgumentType.ColumnInt64;
        }
        if (type_name.equals("Column<float>")) {
            return ExtensionFunction.ExtArgumentType.ColumnFloat;
        }
        if (type_name.equals("Column<double>")) {
            return ExtensionFunction.ExtArgumentType.ColumnDouble;
        }
        if (type_name.equals("Column<TextEncodingDict>")) {
            return ExtensionFunction.ExtArgumentType.ColumnTextEncodingDict;
        }
        if (type_name.equals("Column<Timestamp>")) {
            return ExtensionFunction.ExtArgumentType.ColumnTimestamp;
        }
        if (type_name.equals("Cursor")) {
            return ExtensionFunction.ExtArgumentType.Cursor;
        }
        if (type_name.equals("GeoPoint")) {
            return ExtensionFunction.ExtArgumentType.GeoPoint;
        }
        if (type_name.equals("GeoMultiPoint")) {
            return ExtensionFunction.ExtArgumentType.GeoMultiPoint;
        }
        if (type_name.equals("GeoLineString")) {
            return ExtensionFunction.ExtArgumentType.GeoLineString;
        }
        if (type_name.equals("GeoMultiLineString")) {
            return ExtensionFunction.ExtArgumentType.GeoMultiLineString;
        }
        if (type_name.equals("GeoPolygon")) {
            return ExtensionFunction.ExtArgumentType.GeoPolygon;
        }
        if (type_name.equals("GeoMultiPolygon")) {
            return ExtensionFunction.ExtArgumentType.GeoMultiPolygon;
        }
        if (type_name.equals("ColumnList<int8_t>") || type_name.equals("ColumnList<char>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListInt8;
        }
        if (type_name.equals("ColumnList<int16_t>") || type_name.equals("ColumnList<short>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListInt16;
        }
        if (type_name.equals("ColumnList<int32_t>") || type_name.equals("ColumnList<int>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListInt32;
        }
        if (type_name.equals("ColumnList<int64_t>") || type_name.equals("ColumnList<size_t>") || type_name.equals("ColumnList<long>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListInt64;
        }
        if (type_name.equals("ColumnList<float>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListFloat;
        }
        if (type_name.equals("ColumnList<double>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListDouble;
        }
        if (type_name.equals("ColumnList<TextEncodingDict>")) {
            return ExtensionFunction.ExtArgumentType.ColumnListTextEncodingDict;
        }
        HEAVYDBLOGGER.info("ExtensionfunctionSignatureParser::deserializeType: unknown type_name=`" + type_name + "`");
        return ExtensionFunction.ExtArgumentType.Void;
    }

    private static ExtensionFunction.ExtArgumentType pointerType(ExtensionFunction.ExtArgumentType targetType) {
        switch (targetType) {
            case Bool: {
                return ExtensionFunction.ExtArgumentType.PBool;
            }
            case Int8: {
                return ExtensionFunction.ExtArgumentType.PInt8;
            }
            case Int16: {
                return ExtensionFunction.ExtArgumentType.PInt16;
            }
            case Int32: {
                return ExtensionFunction.ExtArgumentType.PInt32;
            }
            case Int64: {
                return ExtensionFunction.ExtArgumentType.PInt64;
            }
            case Float: {
                return ExtensionFunction.ExtArgumentType.PFloat;
            }
            case Double: {
                return ExtensionFunction.ExtArgumentType.PDouble;
            }
        }
        assert (false);
        return null;
    }

    static String join(List<String> strs, String sep) {
        StringBuilder sb = new StringBuilder();
        if (strs.isEmpty()) {
            return "";
        }
        sb.append(strs.get(0));
        for (int i = 1; i < strs.size(); ++i) {
            sb.append(sep).append(strs.get(i));
        }
        return sb.toString();
    }
}

