/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.mapd.calcite.parser.HeavyDBTable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;

class CalciteSqlValidator
extends SqlValidatorImpl {
    CalciteSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, JavaTypeFactory typeFactory, SqlValidator.Config config) {
        super(opTab, catalogReader, typeFactory, config);
    }

    @Override
    protected RelDataType getLogicalSourceRowType(RelDataType sourceRowType, SqlInsert insert) {
        RelDataType superType = super.getLogicalSourceRowType(sourceRowType, insert);
        return ((JavaTypeFactory)this.typeFactory).toSql(superType);
    }

    @Override
    protected RelDataType getLogicalTargetRowType(RelDataType targetRowType, SqlInsert insert) {
        RelDataType superType = super.getLogicalTargetRowType(targetRowType, insert);
        return ((JavaTypeFactory)this.typeFactory).toSql(superType);
    }

    @Override
    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (includeSystemVars || !this.isSystemColumn(exp, scope)) {
            super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
        }
    }

    private boolean isSystemColumn(SqlNode exp, SelectScope scope) {
        if (exp instanceof SqlIdentifier) {
            SqlValidatorTable sqlValidatorTable;
            SqlIdentifier columnId = (SqlIdentifier)exp;
            if (columnId.names != null && columnId.names.size() == 2 && (sqlValidatorTable = scope.fullyQualify((SqlIdentifier)columnId).namespace.getTable()) != null) {
                HeavyDBTable table = sqlValidatorTable.unwrap(HeavyDBTable.class);
                return table.isSystemColumn((String)columnId.names.get(1));
            }
        }
        return false;
    }

    @Override
    protected void checkTypeAssignment(SqlValidatorScope sourceScope, SqlValidatorTable table, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
    }
}

