/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableSet;
import com.mapd.calcite.parser.HeavyDBParserOptions;
import com.mapd.calcite.parser.HeavyDBSchema;
import com.mapd.calcite.parser.ProjectProjectRemoveRule;
import com.mapd.calcite.rel.rules.FilterTableFunctionMultiInputTransposeRule;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.HeavyDBSqlAdvisor;
import org.apache.calcite.prepare.HeavyDBSqlAdvisorValidator;
import org.apache.calcite.prepare.PlannerImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.externalize.HeavyDBRelJsonReader;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.DynamicFilterJoinRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.InjectFilterRule;
import org.apache.calcite.rel.rules.OuterJoinOptViaNullRejectionRule;
import org.apache.calcite.rel.rules.Restriction;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyDBPlanner
extends PlannerImpl {
    FrameworkConfig config;
    private List<HeavyDBParserOptions.FilterPushDownInfo> filterPushDownInfo = new ArrayList<HeavyDBParserOptions.FilterPushDownInfo>();
    private List<Restriction> restrictions = null;
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyDBPlanner.class);

    public HeavyDBPlanner(FrameworkConfig config) {
        super(config);
        this.config = config;
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        while (schema.getParentSchema() != null) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    private CalciteCatalogReader createCatalogReader() {
        CalciteConnectionConfig connectionConfig;
        SchemaPlus rootSchema = HeavyDBPlanner.rootSchema(this.config.getDefaultSchema());
        Context context = this.config.getContext();
        if (context != null) {
            connectionConfig = context.unwrap(CalciteConnectionConfig.class);
        } else {
            Properties properties = new Properties();
            properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(this.config.getParserConfig().caseSensitive()));
            connectionConfig = new CalciteConnectionConfigImpl(properties);
        }
        return new CalciteCatalogReader(CalciteSchema.from(rootSchema), CalciteSchema.from(this.config.getDefaultSchema()).path(null), this.getTypeFactory(), connectionConfig);
    }

    public void advanceToValidate() {
        try {
            String dummySql = "SELECT 1";
            super.parse(dummySql);
        }
        catch (SqlParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void ready() {
        try {
            Method readyMethod = this.getClass().getSuperclass().getDeclaredMethod("ready", new Class[0]);
            readyMethod.setAccessible(true);
            readyMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompletionResult getCompletionHints(String sql, int cursor, List<String> visibleTables) {
        this.ready();
        SqlValidator.Config validatorConfig = SqlValidator.Config.DEFAULT;
        validatorConfig = validatorConfig.withSqlConformance(SqlConformanceEnum.LENIENT);
        HeavyDBSqlAdvisorValidator advisor_validator = new HeavyDBSqlAdvisorValidator(visibleTables, this.config.getOperatorTable(), this.createCatalogReader(), this.getTypeFactory(), validatorConfig);
        HeavyDBSqlAdvisor advisor = new HeavyDBSqlAdvisor(advisor_validator, this.config.getParserConfig());
        String[] replaced = new String[1];
        int adjusted_cursor = cursor < 0 ? sql.length() : cursor;
        List<SqlMoniker> hints = ((SqlAdvisor)advisor).getCompletionHints(sql, adjusted_cursor, replaced);
        return new CompletionResult(hints, replaced[0]);
    }

    public static HepPlanner getHepPlanner(HepProgram hepProgram, boolean doNotEliminateSharedNodesInQueryPlanDag) {
        if (doNotEliminateSharedNodesInQueryPlanDag) {
            return new HepPlanner(hepProgram, null, true, Functions.ignore2(), RelOptCostImpl.FACTORY);
        }
        return new HepPlanner(hepProgram);
    }

    @Override
    public RelRoot rel(SqlNode sql) {
        return super.rel(sql);
    }

    public RelRoot getRelRoot(SqlNode sqlNode) {
        return super.rel(sqlNode);
    }

    public RelNode optimizeRATree(RelNode rootNode, boolean viewOptimizationEnabled, boolean foundView) {
        boolean needsSecondOptPhase;
        HepProgramBuilder firstOptPhaseProgram = HepProgram.builder();
        firstOptPhaseProgram.addRuleInstance(CoreRules.AGGREGATE_MERGE).addRuleInstance(new OuterJoinOptViaNullRejectionRule(RelFactories.LOGICAL_BUILDER)).addRuleInstance(CoreRules.AGGREGATE_UNION_TRANSPOSE).addRuleInstance(CoreRules.JOIN_PUSH_EXPRESSIONS);
        if (!viewOptimizationEnabled) {
            firstOptPhaseProgram.addRuleInstance(CoreRules.FILTER_PROJECT_TRANSPOSE).addRuleInstance(FilterTableFunctionMultiInputTransposeRule.Config.DEFAULT.toRule()).addRuleInstance(CoreRules.FILTER_PROJECT_TRANSPOSE);
        } else {
            if (foundView) {
                firstOptPhaseProgram.addRuleInstance(CoreRules.JOIN_PROJECT_BOTH_TRANSPOSE_INCLUDE_OUTER);
                firstOptPhaseProgram.addRuleInstance(CoreRules.FILTER_MERGE);
            }
            firstOptPhaseProgram.addRuleInstance(CoreRules.FILTER_PROJECT_TRANSPOSE);
            firstOptPhaseProgram.addRuleInstance(FilterTableFunctionMultiInputTransposeRule.Config.DEFAULT.toRule());
            firstOptPhaseProgram.addRuleInstance(CoreRules.FILTER_PROJECT_TRANSPOSE);
            if (foundView) {
                firstOptPhaseProgram.addRuleInstance(CoreRules.PROJECT_MERGE);
                firstOptPhaseProgram.addRuleInstance(ProjectProjectRemoveRule.INSTANCE);
            }
        }
        HepProgram firstOptPhase = firstOptPhaseProgram.build();
        HepPlanner firstPlanner = HeavyDBPlanner.getHepPlanner(firstOptPhase, true);
        firstPlanner.setRoot(rootNode);
        RelNode firstOptimizedPlanRoot = firstPlanner.findBestExp();
        boolean hasRLSFilter = null != this.restrictions && !this.restrictions.isEmpty();
        boolean bl = needsSecondOptPhase = hasRLSFilter || !this.filterPushDownInfo.isEmpty();
        if (needsSecondOptPhase) {
            HepProgramBuilder secondOptPhaseProgram = HepProgram.builder();
            if (hasRLSFilter) {
                InjectFilterRule injectFilterRule = InjectFilterRule.Config.DEFAULT.toRule(this.restrictions);
                secondOptPhaseProgram.addRuleInstance(injectFilterRule);
            }
            if (!this.filterPushDownInfo.isEmpty()) {
                DynamicFilterJoinRule dynamicFilterJoinRule = new DynamicFilterJoinRule(true, RelFactories.LOGICAL_BUILDER, FilterJoinRule.TRUE_PREDICATE, this.filterPushDownInfo);
                secondOptPhaseProgram.addRuleInstance(dynamicFilterJoinRule);
            }
            HepProgram secondOptPhase = secondOptPhaseProgram.build();
            HepPlanner secondPlanner = HeavyDBPlanner.getHepPlanner(secondOptPhase, true);
            secondPlanner.setRoot(firstOptimizedPlanRoot);
            RelNode secondOptimizedPlanRoot = secondPlanner.findBestExp();
            if (!this.filterPushDownInfo.isEmpty()) {
                this.filterPushDownInfo.clear();
            }
            return secondOptimizedPlanRoot;
        }
        return firstOptimizedPlanRoot;
    }

    private RelRoot applyInjectFilterRule(RelRoot root, List<Restriction> restrictions) {
        InjectFilterRule injectFilterRule = InjectFilterRule.Config.DEFAULT.toRule(restrictions);
        HepProgram program = HepProgram.builder().addRuleInstance(injectFilterRule).build();
        HepPlanner prePlanner = HeavyDBPlanner.getHepPlanner(program, false);
        prePlanner.setRoot(root.rel);
        RelNode rootRelNode = prePlanner.findBestExp();
        return root.withRel(rootRelNode);
    }

    private RelRoot applyFilterPushdown(RelRoot root) {
        if (this.filterPushDownInfo.isEmpty()) {
            return root;
        }
        DynamicFilterJoinRule dynamicFilterJoinRule = new DynamicFilterJoinRule(true, RelFactories.LOGICAL_BUILDER, FilterJoinRule.TRUE_PREDICATE, this.filterPushDownInfo);
        HepProgram program = HepProgram.builder().addRuleInstance(dynamicFilterJoinRule).build();
        HepPlanner prePlanner = HeavyDBPlanner.getHepPlanner(program, false);
        prePlanner.setRoot(root.rel);
        RelNode rootRelNode = prePlanner.findBestExp();
        this.filterPushDownInfo.clear();
        return root.withRel(rootRelNode);
    }

    private RelRoot applyOptimizationsRules(RelRoot root, ImmutableSet<RelOptRule> rules) {
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        for (RelOptRule rule : rules) {
            programBuilder.addRuleInstance(rule);
        }
        HepPlanner hepPlanner = HeavyDBPlanner.getHepPlanner(programBuilder.build(), false);
        hepPlanner.setRoot(root.rel);
        return root.withRel(hepPlanner.findBestExp());
    }

    public RelRoot buildRATreeAndPerformQueryOptimization(String query, HeavyDBSchema schema) throws IOException {
        this.ready();
        RexBuilder builder = new RexBuilder(this.getTypeFactory());
        RelOptCluster cluster = RelOptCluster.create(new VolcanoPlanner(), builder);
        CalciteCatalogReader catalogReader = this.createCatalogReader();
        HeavyDBRelJsonReader reader = new HeavyDBRelJsonReader(cluster, catalogReader, schema);
        RelRoot relR = RelRoot.of(reader.read(query), SqlKind.SELECT);
        if (this.restrictions != null) {
            relR = this.applyInjectFilterRule(relR, this.restrictions);
        }
        OuterJoinOptViaNullRejectionRule outerJoinOptRule = new OuterJoinOptViaNullRejectionRule(RelFactories.LOGICAL_BUILDER);
        relR = this.applyOptimizationsRules(relR, ImmutableSet.of(CoreRules.AGGREGATE_MERGE, outerJoinOptRule));
        relR = this.applyFilterPushdown(relR);
        relR = this.applyOptimizationsRules(relR, ImmutableSet.of(CoreRules.JOIN_PROJECT_BOTH_TRANSPOSE_INCLUDE_OUTER, CoreRules.FILTER_REDUCE_EXPRESSIONS, ProjectProjectRemoveRule.INSTANCE, CoreRules.PROJECT_FILTER_TRANSPOSE));
        relR = this.applyOptimizationsRules(relR, ImmutableSet.of(CoreRules.PROJECT_MERGE));
        relR = this.applyOptimizationsRules(relR, ImmutableSet.of(CoreRules.FILTER_PROJECT_TRANSPOSE, CoreRules.PROJECT_REMOVE));
        return RelRoot.of(relR.project(), relR.kind);
    }

    public void setFilterPushDownInfo(List<HeavyDBParserOptions.FilterPushDownInfo> filterPushDownInfo) {
        this.filterPushDownInfo = filterPushDownInfo;
    }

    public void setRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    public static class CompletionResult {
        public List<SqlMoniker> hints;
        public String replaced;

        CompletionResult(List<SqlMoniker> hints, String replaced) {
            this.hints = hints;
            this.replaced = replaced;
        }
    }
}

