/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.parser.SqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlIdentifierCapturer {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(SqlIdentifierCapturer.class);
    private static final Map<Class<?>, Set<Method>> GETTERS_CACHE = new ConcurrentHashMap();
    private IdentityHashMap<SqlNode, SqlNode> visitedNodes = new IdentityHashMap();
    private Stack<Set<ImmutableList<String>>> currentList = new Stack();
    public Set<ImmutableList<String>> selects = new HashSet<ImmutableList<String>>();
    public Set<ImmutableList<String>> inserts = new HashSet<ImmutableList<String>>();
    public Set<ImmutableList<String>> updates = new HashSet<ImmutableList<String>>();
    public Set<ImmutableList<String>> deletes = new HashSet<ImmutableList<String>>();
    private final Set<ImmutableList<String>> ignore = new HashSet<ImmutableList<String>>();

    public SqlIdentifierCapturer() {
        this.currentList.push(this.ignore);
    }

    public void scan(SqlNode root) {
        if (null == root) {
            return;
        }
        if (root instanceof SqlLiteral || root instanceof SqlDataTypeSpec) {
            return;
        }
        if (null != this.visitedNodes.put(root, root)) {
            return;
        }
        if (root instanceof SqlNodeList) {
            SqlNodeList snl = (SqlNodeList)root;
            for (SqlNode node : snl) {
                this.scan(node);
            }
            return;
        }
        if (root instanceof SqlIdentifier) {
            this.currentList.peek().add(((SqlIdentifier)root).names.reverse());
            return;
        }
        if (root instanceof SqlBasicCall) {
            SqlBasicCall call = (SqlBasicCall)root;
            if (call.getOperator().getKind() == SqlKind.ARGUMENT_ASSIGNMENT) {
                if (call.operandCount() == 0) {
                    return;
                }
                if (call.getOperands()[0].getKind() == SqlKind.CURSOR) {
                    SqlBasicCall cursor_call = (SqlBasicCall)call.getOperands()[0];
                    if (cursor_call.operandCount() == 0) {
                        return;
                    }
                    this.scan(cursor_call.getOperands()[0]);
                    return;
                }
                return;
            }
            if (call.getOperator().getKind() == SqlKind.AS) {
                this.scan(call.getOperands()[0]);
                return;
            }
        }
        if (root instanceof SqlOrderBy) {
            this.scan(((SqlOrderBy)root).fetch);
            this.scan(((SqlOrderBy)root).offset);
            this.scan(((SqlOrderBy)root).query);
            return;
        }
        boolean needsPop = false;
        if (root instanceof SqlSelect) {
            this.currentList.push(this.selects);
            this.scan(((SqlSelect)root).getFrom());
            this.currentList.pop();
            this.currentList.push(this.ignore);
            needsPop = true;
        } else if (root instanceof SqlInsert) {
            this.currentList.push(this.inserts);
            this.scan(((SqlInsert)root).getTargetTable());
            this.currentList.pop();
            this.currentList.push(this.ignore);
            needsPop = true;
        } else if (root instanceof SqlUpdate) {
            this.currentList.push(this.updates);
            this.scan(((SqlUpdate)root).getTargetTable());
            this.currentList.pop();
            this.currentList.push(this.ignore);
            needsPop = true;
        } else if (root instanceof SqlDelete) {
            this.currentList.push(this.deletes);
            this.scan(((SqlDelete)root).getTargetTable());
            this.currentList.pop();
            this.currentList.push(this.ignore);
            needsPop = true;
        } else if (root instanceof SqlJoin) {
            this.currentList.push(this.ignore);
            this.scan(((SqlJoin)root).getCondition());
            this.currentList.pop();
        }
        Set<Method> methods = this.getRelevantGetters(root);
        for (Method m3 : methods) {
            Object value = null;
            try {
                value = m3.invoke((Object)root, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value instanceof SqlNode[]) {
                SqlNode[] nodes = (SqlNode[])value;
                for (SqlNode node : nodes) {
                    this.scan(node);
                }
                continue;
            }
            if (value instanceof SqlNode) {
                this.scan((SqlNode)value);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            for (Object vobj : (Collection)value) {
                if (!(vobj instanceof SqlNode)) continue;
                this.scan((SqlNode)vobj);
            }
        }
        if (root instanceof SqlWith) {
            SqlWith with = (SqlWith)root;
            for (SqlNode node : with.withList) {
                SqlWithItem item = (SqlWithItem)node;
                this.selects.remove(item.name.names.reverse());
            }
        }
        if (needsPop) {
            this.currentList.pop();
        }
    }

    Set<Method> getRelevantGetters(Object obj) {
        Class<?> root = obj.getClass();
        Set<Method> methods = GETTERS_CACHE.get(root);
        if (null != methods) {
            return methods;
        }
        methods = new HashSet<Method>();
        while (root != null && root != SqlNode.class) {
            for (Method m3 : root.getDeclaredMethods()) {
                Class<?> returnType;
                if (m3.getParameterTypes().length > 0 || !Modifier.isPublic(m3.getModifiers()) || !SqlNode.class.isAssignableFrom(returnType = m3.getReturnType()) && SqlNode[].class != returnType && !Collection.class.isAssignableFrom(returnType)) continue;
                methods.add(m3);
            }
            root = root.getSuperclass();
        }
        GETTERS_CACHE.put(obj.getClass(), methods);
        return methods;
    }

    public String toString() {
        String out = "";
        out = out + " Selects: " + this.selects + "\n";
        out = out + " Inserts: " + this.inserts + "\n";
        out = out + " Updates: " + this.updates + "\n";
        out = out + " Deletes: " + this.deletes + "\n";
        out = out + " Ignore : " + this.ignore + "\n";
        return out;
    }

    public static void main(String[] args) throws Exception {
        String sql = "UPDATE sales set f=(SELECT max(r.num) from report as r)";
        sql = "INSER INTO sales (a, b, c ) VALUES(10, (SELECT max(foo) from bob), 0)";
        sql = "SELECT * FROM sales a left outer join (select (select max(id) from rupert) from report2) r on a.id=(select max(r.di) from test)";
        SqlParser parser = SqlParser.create(sql);
        SqlIdentifierCapturer capturer = new SqlIdentifierCapturer();
        capturer.scan(parser.parseQuery());
        System.out.println(capturer.selects);
        System.out.println(capturer.inserts);
        System.out.println(capturer.updates);
        System.out.println(capturer.deletes);
        System.out.println(capturer.ignore);
    }
}

