/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.profile;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.profile.Profiler;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.PartiallyOrderedSet;
import org.apache.calcite.util.Util;

public class SimpleProfiler
implements Profiler {
    @Override
    public Profiler.Profile profile(Iterable<List<Comparable>> rows, List<Profiler.Column> columns, Collection<ImmutableBitSet> initialGroups) {
        Util.discard(initialGroups);
        return new Run(columns).profile(rows);
    }

    public static double surprise(double expected, double actual) {
        if (expected == actual) {
            return 0.0;
        }
        double sum = expected + actual;
        if (sum <= 0.0) {
            return 1.0;
        }
        return Math.abs(expected - actual) / sum;
    }

    static class Space
    implements Comparable<Space> {
        final ImmutableBitSet columnOrdinals;
        final ImmutableSortedSet<Profiler.Column> columns;
        int nullCount;
        final SortedSet<FlatLists.ComparableList<Comparable>> values = new TreeSet<FlatLists.ComparableList<Comparable>>();
        boolean unique;
        final BitSet dependencies = new BitSet();
        final Set<ImmutableBitSet> dependents = new HashSet<ImmutableBitSet>();

        Space(ImmutableBitSet columnOrdinals, Iterable<Profiler.Column> columns) {
            this.columnOrdinals = columnOrdinals;
            this.columns = ImmutableSortedSet.copyOf(columns);
        }

        public int hashCode() {
            return this.columnOrdinals.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Space && this.columnOrdinals.equals(((Space)o).columnOrdinals);
        }

        @Override
        public int compareTo(@Nonnull Space o) {
            return this.columnOrdinals.equals(o.columnOrdinals) ? 0 : (this.columnOrdinals.contains(o.columnOrdinals) ? 1 : -1);
        }

        public double cardinality() {
            return this.values.size() + (this.nullCount > 0 ? 1 : 0);
        }
    }

    static class Run {
        private final List<Profiler.Column> columns;
        final List<Space> spaces = new ArrayList<Space>();
        final List<Space> singletonSpaces;
        final List<Profiler.Statistic> statistics = new ArrayList<Profiler.Statistic>();
        final PartiallyOrderedSet.Ordering<Space> ordering = (e1, e2) -> e2.columnOrdinals.contains(e1.columnOrdinals);
        final PartiallyOrderedSet<Space> results = new PartiallyOrderedSet<Space>(this.ordering);
        final PartiallyOrderedSet<Space> keyResults = new PartiallyOrderedSet<Space>(this.ordering);
        private final List<ImmutableBitSet> keyOrdinalLists = new ArrayList<ImmutableBitSet>();

        Run(List<Profiler.Column> columns) {
            for (Ord<Profiler.Column> column : Ord.zip(columns)) {
                if (((Profiler.Column)column.e).ordinal == column.i) continue;
                throw new IllegalArgumentException();
            }
            this.columns = columns;
            this.singletonSpaces = new ArrayList<Object>(Collections.nCopies(columns.size(), null));
            for (ImmutableBitSet ordinals : ImmutableBitSet.range(columns.size()).powerSet()) {
                Space space = new Space(ordinals, this.toColumns(ordinals));
                this.spaces.add(space);
                if (ordinals.cardinality() != 1) continue;
                this.singletonSpaces.set(ordinals.nth(0), space);
            }
        }

        Profiler.Profile profile(Iterable<List<Comparable>> rows) {
            ArrayList<Comparable> values = new ArrayList<Comparable>();
            int rowCount = 0;
            for (List<Comparable> row : rows) {
                ++rowCount;
                block5: for (Space space : this.spaces) {
                    values.clear();
                    for (Profiler.Column column : space.columns) {
                        Comparable value = row.get(column.ordinal);
                        values.add(value);
                        if (value != NullSentinel.INSTANCE) continue;
                        ++space.nullCount;
                        continue block5;
                    }
                    space.values.add(FlatLists.ofComparable(values));
                }
            }
            HashMap<ImmutableBitSet, Profiler.Distribution> distributions = new HashMap<ImmutableBitSet, Profiler.Distribution>();
            for (Space space : this.spaces) {
                double expectedCardinality;
                ImmutableSortedSet<Comparable> valueSet;
                int nullCount;
                if (space.values.size() == rowCount && !this.containsKey(space.columnOrdinals, false)) {
                    this.statistics.add(new Profiler.Unique(space.columns));
                    space.unique = true;
                    this.keyOrdinalLists.add(space.columnOrdinals);
                }
                int nonMinimal = 0;
                block8: for (Space s2 : this.results.getDescendants(space)) {
                    Space s1;
                    if (s2.cardinality() != space.cardinality()) continue;
                    ImmutableBitSet dependents = space.columnOrdinals.except(s2.columnOrdinals);
                    for (int i : s2.columnOrdinals) {
                        s1 = this.singletonSpaces.get(i);
                        Iterator<ImmutableBitSet> rest = s2.columnOrdinals.clear(i);
                        for (ImmutableBitSet dependent : s1.dependents) {
                            if (!((ImmutableBitSet)((Object)rest)).contains(dependent)) continue;
                            ++nonMinimal;
                            continue block8;
                        }
                    }
                    for (int dependent : dependents) {
                        s1 = this.singletonSpaces.get(dependent);
                        for (ImmutableBitSet d : s1.dependents) {
                            if (!s2.columnOrdinals.contains(d)) continue;
                            ++nonMinimal;
                            continue block8;
                        }
                    }
                    space.dependencies.or(dependents.toBitSet());
                    for (int d : dependents) {
                        this.singletonSpaces.get((int)d).dependents.add(s2.columnOrdinals);
                    }
                }
                if (space.columns.size() == 1) {
                    nullCount = space.nullCount;
                    valueSet = ImmutableSortedSet.copyOf(Iterables.transform(space.values, Iterables::getOnlyElement));
                } else {
                    nullCount = -1;
                    valueSet = null;
                }
                double cardinality = space.cardinality();
                switch (space.columns.size()) {
                    case 0: {
                        expectedCardinality = 1.0;
                        break;
                    }
                    case 1: {
                        expectedCardinality = rowCount;
                        break;
                    }
                    default: {
                        expectedCardinality = rowCount;
                        for (Profiler.Column column : space.columns) {
                            Profiler.Distribution d1 = (Profiler.Distribution)distributions.get(ImmutableBitSet.of(column.ordinal));
                            Profiler.Distribution d2 = (Profiler.Distribution)distributions.get(space.columnOrdinals.clear(column.ordinal));
                            double d = Lattice.getRowCount((double)rowCount, d1.cardinality, d2.cardinality);
                            expectedCardinality = Math.min(expectedCardinality, d);
                        }
                    }
                }
                boolean minimal = nonMinimal == 0 && !space.unique && !this.containsKey(space.columnOrdinals, true);
                Profiler.Distribution distribution = new Profiler.Distribution(space.columns, valueSet, cardinality, nullCount, expectedCardinality, minimal);
                this.statistics.add(distribution);
                distributions.put(space.columnOrdinals, distribution);
                if (!distribution.minimal) continue;
                this.results.add(space);
            }
            for (Space s3 : this.singletonSpaces) {
                for (ImmutableBitSet dependent : s3.dependents) {
                    if (this.containsKey(dependent, false) || this.hasNull(dependent)) continue;
                    this.statistics.add(new Profiler.FunctionalDependency(this.toColumns(dependent), Iterables.getOnlyElement(s3.columns)));
                }
            }
            return new Profiler.Profile(this.columns, new Profiler.RowCount(rowCount), Iterables.filter(this.statistics, Profiler.FunctionalDependency.class), Iterables.filter(this.statistics, Profiler.Distribution.class), Iterables.filter(this.statistics, Profiler.Unique.class));
        }

        private boolean containsKey(ImmutableBitSet ordinals, boolean strict) {
            for (ImmutableBitSet keyOrdinals : this.keyOrdinalLists) {
                if (!ordinals.contains(keyOrdinals)) continue;
                return !strict || !keyOrdinals.equals(ordinals);
            }
            return false;
        }

        private boolean hasNull(ImmutableBitSet columnOrdinals) {
            for (Integer columnOrdinal : columnOrdinals) {
                if (this.singletonSpaces.get((int)columnOrdinal.intValue()).nullCount <= 0) continue;
                return true;
            }
            return false;
        }

        private ImmutableSortedSet<Profiler.Column> toColumns(Iterable<Integer> ordinals) {
            return ImmutableSortedSet.copyOf(Iterables.transform(ordinals, this.columns::get));
        }
    }
}

