/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.externalize.HeavyDBRelJson;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.Pair;

public class HeavyDBRelJsonWriter
implements RelWriter {
    private final EscapedStringJsonBuilder jsonBuilder;
    private final HeavyDBRelJson relJson;
    private final Map<RelNode, String> relIdMap = new IdentityHashMap<RelNode, String>();
    private final List<Object> relList;
    private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
    private String previousId;

    public HeavyDBRelJsonWriter() {
        this.jsonBuilder = new EscapedStringJsonBuilder();
        this.relList = this.jsonBuilder.list();
        this.relJson = new HeavyDBRelJson(this.jsonBuilder);
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("id", null);
        map.put("relOp", this.relJson.classToTypeName(rel.getClass()));
        if (rel instanceof TableScan) {
            RelDataType row_type = ((TableScan)rel).getTable().getRowType();
            List<String> list = row_type.getFieldNames();
            map.put("fieldNames", list);
        }
        if (rel instanceof LogicalAggregate) {
            map.put("fields", rel.getRowType().getFieldNames());
        }
        if (rel instanceof LogicalTableModify) {
            // empty if block
        }
        if (this.deliverHints(rel)) {
            map.put("hints", this.explainHints(rel));
        }
        for (Pair pair : values) {
            if (pair.right instanceof RelNode) continue;
            this.put(map, (String)pair.left, pair.right);
        }
        List<Object> list = this.explainInputs(rel.getInputs());
        if (list.size() != 1 || !list.get(0).equals(this.previousId)) {
            map.put("inputs", list);
        }
        String string = Integer.toString(this.relIdMap.size());
        this.relIdMap.put(rel, string);
        map.put("id", string);
        this.relList.add(map);
        this.previousId = string;
    }

    private void put(Map<String, Object> map, String name, Object value) {
        map.put(name, this.relJson.toJson(value));
    }

    private List<Object> explainInputs(List<RelNode> inputs) {
        List<Object> list = this.jsonBuilder.list();
        for (RelNode input : inputs) {
            String id = this.relIdMap.get(input);
            if (id == null) {
                input.explain(this);
                id = this.previousId;
            }
            list.add(id);
        }
        return list;
    }

    private boolean deliverHints(RelNode rel) {
        if (rel instanceof LogicalTableScan) {
            LogicalTableScan node = (LogicalTableScan)rel;
            return !node.getHints().isEmpty();
        }
        if (rel instanceof LogicalAggregate) {
            LogicalAggregate node = (LogicalAggregate)rel;
            return !node.getHints().isEmpty();
        }
        if (rel instanceof LogicalJoin) {
            LogicalJoin node = (LogicalJoin)rel;
            return !node.getHints().isEmpty();
        }
        if (rel instanceof LogicalProject) {
            LogicalProject node = (LogicalProject)rel;
            return !node.getHints().isEmpty();
        }
        if (rel instanceof LogicalCalc) {
            LogicalCalc node = (LogicalCalc)rel;
            return !node.getHints().isEmpty();
        }
        return false;
    }

    private String explainHints(RelNode rel) {
        ArrayList explained = new ArrayList();
        if (rel instanceof LogicalTableScan) {
            LogicalTableScan node = (LogicalTableScan)rel;
            node.getHints().stream().forEach(s2 -> explained.add(s2.toString().toLowerCase()));
        } else if (rel instanceof LogicalAggregate) {
            LogicalAggregate node = (LogicalAggregate)rel;
            node.getHints().stream().forEach(s2 -> explained.add(s2.toString().toLowerCase()));
        } else if (rel instanceof LogicalJoin) {
            LogicalJoin node = (LogicalJoin)rel;
            node.getHints().stream().forEach(s2 -> explained.add(s2.toString().toLowerCase()));
        } else if (rel instanceof LogicalProject) {
            LogicalProject node = (LogicalProject)rel;
            node.getHints().stream().forEach(s2 -> explained.add(s2.toString().toLowerCase()));
        } else if (rel instanceof LogicalCalc) {
            LogicalCalc node = (LogicalCalc)rel;
            node.getHints().stream().forEach(s2 -> explained.add(s2.toString().toLowerCase()));
        }
        return explained.stream().collect(Collectors.joining("|"));
    }

    @Override
    public final void explain(RelNode rel, List<Pair<String, Object>> valueList) {
        this.explain_(rel, valueList);
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return SqlExplainLevel.ALL_ATTRIBUTES;
    }

    @Override
    public RelWriter input(String term, RelNode input) {
        return this;
    }

    @Override
    public RelWriter item(String term, Object value) {
        this.values.add(Pair.of(term, value));
        return this;
    }

    private List<Object> getList(List<Pair<String, Object>> values, String tag) {
        for (Pair<String, Object> value : values) {
            if (!((String)value.left).equals(tag)) continue;
            return (List)value.right;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        values.add(Pair.of(tag, list));
        return list;
    }

    @Override
    public RelWriter itemIf(String term, Object value, boolean condition) {
        if (condition) {
            this.item(term, value);
        }
        return this;
    }

    @Override
    public RelWriter done(RelNode node) {
        ImmutableList<Pair<String, Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, valuesCopy);
        return this;
    }

    @Override
    public boolean nest() {
        return true;
    }

    public String asString() {
        return this.jsonBuilder.toJsonString(this.asJsonMap());
    }

    public Map<String, Object> asJsonMap() {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("rels", this.relList);
        return map;
    }
}

