/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HeavyDBRelWriterImpl
implements RelWriter {
    protected final PrintWriter pw;
    protected final SqlExplainLevel detailLevel;
    protected final boolean withIdPrefix;
    protected final Spacer spacer = new Spacer();
    private final List<Pair<String, @Nullable Object>> values = new ArrayList<Pair<String, Object>>();

    public HeavyDBRelWriterImpl(PrintWriter pw) {
        this(pw, SqlExplainLevel.EXPPLAN_ATTRIBUTES, true);
    }

    public HeavyDBRelWriterImpl(PrintWriter pw, SqlExplainLevel detailLevel, boolean withIdPrefix) {
        this.pw = pw;
        this.detailLevel = detailLevel;
        this.withIdPrefix = withIdPrefix;
    }

    public Set<String> collectRelColumnOrigin(RelMetadataQuery mq, RelNode rel, int targetColumnIndex) {
        Set<Object> columnOrigins = new HashSet();
        HashMap originInfoMap = new HashMap();
        HashSet<String> originInfo = new HashSet<String>();
        try {
            if (!rel.getInputs().isEmpty()) {
                RelNode sourceNode = rel.getInputs().size() == 1 ? rel.getInput(0) : rel;
                columnOrigins = mq.getColumnOrigins(sourceNode, targetColumnIndex);
            }
            for (RelColumnOrigin rco : columnOrigins) {
                RelOptTable relOptTable = rco.getOriginTable();
                String dbName = relOptTable.getQualifiedName().get(0);
                String tableName = relOptTable.getQualifiedName().get(1);
                String colName = relOptTable.getRowType().getFieldList().get(rco.getOriginColumnOrdinal()).getName();
                String key = "$" + targetColumnIndex;
                String info = "db:" + dbName + ",tableName:" + tableName + ",colName:" + colName;
                if (originInfoMap.containsKey(key)) {
                    ((Set)originInfoMap.get(key)).add(info);
                    continue;
                }
                HashSet<String> originList = new HashSet<String>();
                originList.add(info);
                originInfoMap.put(key, originList);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("EXPLAIN CALCITE DETAILED error: " + ex.getMessage());
        }
        for (Map.Entry entry : originInfoMap.entrySet()) {
            int index = 1;
            for (String colInfo : (Set)entry.getValue()) {
                if (((Set)entry.getValue()).size() > 1) {
                    originInfo.add((String)entry.getKey() + "-" + index + "->" + colInfo);
                } else {
                    originInfo.add((String)entry.getKey() + "->" + colInfo);
                }
                ++index;
            }
        }
        return originInfo;
    }

    protected void explain_(final RelNode rel, List<Pair<String, @Nullable Object>> values) {
        List<RelNode> inputs = rel.getInputs();
        final RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        if (!mq.isVisibleInExplain(rel, this.detailLevel)) {
            this.explainInputs(inputs);
            return;
        }
        StringBuilder s2 = new StringBuilder();
        this.spacer.spaces(s2);
        if (this.withIdPrefix) {
            s2.append(rel.getId()).append(":");
        }
        s2.append(rel.getRelTypeName());
        if (this.detailLevel != SqlExplainLevel.NO_ATTRIBUTES) {
            int j = 0;
            for (Pair<String, Object> value : values) {
                if (value.right instanceof RelNode) continue;
                if (j++ == 0) {
                    s2.append("(");
                } else {
                    s2.append(", ");
                }
                s2.append((String)value.left).append("=[").append(value.right).append("]");
            }
            if (j > 0) {
                s2.append(")");
            }
        }
        switch (this.detailLevel) {
            case ALL_ATTRIBUTES: {
                s2.append(": rowcount = ").append(mq.getRowCount(rel)).append(", cumulative cost = ").append(mq.getCumulativeCost(rel));
                break;
            }
        }
        switch (this.detailLevel) {
            case ALL_ATTRIBUTES: 
            case NON_COST_ATTRIBUTES: {
                if (this.withIdPrefix) break;
                s2.append(", id = ").append(rel.getId());
                break;
            }
        }
        final HashSet<String> originInfo = new HashSet<String>();
        if (rel instanceof LogicalAggregate) {
            LogicalAggregate aggregate = (LogicalAggregate)rel;
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                for (int expressionIndex : aggCall.getArgList()) {
                    originInfo.addAll(this.collectRelColumnOrigin(mq, rel, expressionIndex));
                }
            }
        } else {
            rel.accept(new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    originInfo.addAll(HeavyDBRelWriterImpl.this.collectRelColumnOrigin(mq, rel, inputRef.getIndex()));
                    return inputRef;
                }
            });
        }
        if (!originInfo.isEmpty()) {
            s2.append("\t{");
            int index = 1;
            for (String info : originInfo) {
                s2.append("[").append(info).append("]");
                if (index < originInfo.size()) {
                    s2.append(", ");
                }
                ++index;
            }
            s2.append("}");
        }
        this.pw.println(s2);
        this.spacer.add(2);
        this.explainInputs(inputs);
        this.spacer.subtract(2);
    }

    private void explainInputs(List<RelNode> inputs) {
        for (RelNode input : inputs) {
            input.explain(this);
        }
    }

    @Override
    public final void explain(RelNode rel, List<Pair<String, @Nullable Object>> valueList) {
        this.explain_(rel, valueList);
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public RelWriter item(String term, @Nullable Object value) {
        this.values.add(Pair.of(term, value));
        return this;
    }

    @Override
    public RelWriter done(RelNode node) {
        assert (this.checkInputsPresentInExplain(node));
        ImmutableList<Pair<String, @Nullable Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, valuesCopy);
        this.pw.flush();
        return this;
    }

    private boolean checkInputsPresentInExplain(RelNode node) {
        int i = 0;
        if (this.values.size() > 0 && ((String)this.values.get((int)0).left).equals("subset")) {
            ++i;
        }
        for (RelNode input : node.getInputs()) {
            assert (this.values.get((int)i).right == input);
            ++i;
        }
        return true;
    }

    public String simple() {
        StringBuilder buf = new StringBuilder("(");
        for (Ord<Pair<String, Object>> ord : Ord.zip(this.values)) {
            if (ord.i > 0) {
                buf.append(", ");
            }
            buf.append((String)((Pair)ord.e).left).append("=[").append(((Pair)ord.e).right).append("]");
        }
        buf.append(")");
        return buf.toString();
    }
}

