/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class PushProjector {
    private final Project origProj;
    private final RexNode origFilter;
    private final RelNode childRel;
    private final ExprCondition preserveExprCondition;
    private final RelBuilder relBuilder;
    final List<RexNode> origProjExprs;
    final List<RelDataTypeField> childFields;
    final int nChildFields;
    final BitSet projRefs;
    final ImmutableBitSet childBitmap;
    final ImmutableBitSet rightBitmap;
    final ImmutableBitSet strongBitmap;
    final int nFields;
    final int nFieldsRight;
    private final int nSysFields;
    final List<RexNode> childPreserveExprs;
    final List<RexNode> rightPreserveExprs;
    int nSystemProject;
    int nProject;
    int nRightProject;
    final RexBuilder rexBuilder;

    public PushProjector(Project origProj, RexNode origFilter, RelNode childRel, ExprCondition preserveExprCondition, RelBuilder relBuilder) {
        this.origProj = origProj;
        this.origFilter = origFilter;
        this.childRel = childRel;
        this.preserveExprCondition = preserveExprCondition;
        this.relBuilder = Objects.requireNonNull(relBuilder);
        this.origProjExprs = origProj == null ? ImmutableList.of() : origProj.getProjects();
        if (childRel instanceof Join) {
            Join join = (Join)childRel;
            this.childFields = Lists.newArrayList(join.getLeft().getRowType().getFieldList());
            this.childFields.addAll(join.getRight().getRowType().getFieldList());
        } else {
            this.childFields = childRel.getRowType().getFieldList();
        }
        this.nChildFields = this.childFields.size();
        this.projRefs = new BitSet(this.nChildFields);
        if (childRel instanceof Join) {
            Join joinRel = (Join)childRel;
            List<RelDataTypeField> leftFields = joinRel.getLeft().getRowType().getFieldList();
            List<RelDataTypeField> rightFields = joinRel.getRight().getRowType().getFieldList();
            this.nFields = leftFields.size();
            this.nFieldsRight = rightFields.size();
            this.nSysFields = joinRel.getSystemFieldList().size();
            this.childBitmap = ImmutableBitSet.range(this.nSysFields, this.nFields + this.nSysFields);
            this.rightBitmap = ImmutableBitSet.range(this.nFields + this.nSysFields, this.nChildFields);
            switch (joinRel.getJoinType()) {
                case INNER: {
                    this.strongBitmap = ImmutableBitSet.of();
                    break;
                }
                case RIGHT: {
                    this.strongBitmap = ImmutableBitSet.range(this.nSysFields, this.nFields + this.nSysFields);
                    break;
                }
                case LEFT: {
                    this.strongBitmap = ImmutableBitSet.range(this.nFields + this.nSysFields, this.nChildFields);
                    break;
                }
                default: {
                    this.strongBitmap = ImmutableBitSet.range(this.nSysFields, this.nChildFields);
                    break;
                }
            }
        } else if (childRel instanceof Correlate) {
            Correlate corrRel = (Correlate)childRel;
            List<RelDataTypeField> leftFields = corrRel.getLeft().getRowType().getFieldList();
            List<RelDataTypeField> rightFields = corrRel.getRight().getRowType().getFieldList();
            this.nFields = leftFields.size();
            JoinRelType joinType = corrRel.getJoinType();
            switch (joinType) {
                case SEMI: 
                case ANTI: {
                    this.nFieldsRight = 0;
                    break;
                }
                default: {
                    this.nFieldsRight = rightFields.size();
                }
            }
            this.nSysFields = 0;
            this.childBitmap = ImmutableBitSet.range(0, this.nFields);
            this.rightBitmap = ImmutableBitSet.range(this.nFields, this.nChildFields);
            this.projRefs.or(BitSets.of(corrRel.getRequiredColumns()));
            switch (joinType) {
                case INNER: {
                    this.strongBitmap = ImmutableBitSet.of();
                    break;
                }
                case SEMI: 
                case ANTI: {
                    this.strongBitmap = ImmutableBitSet.range(0, this.nFields);
                    break;
                }
                case LEFT: {
                    this.strongBitmap = ImmutableBitSet.range(this.nFields, this.nChildFields);
                    break;
                }
                default: {
                    this.strongBitmap = ImmutableBitSet.range(0, this.nChildFields);
                    break;
                }
            }
        } else {
            this.nFields = this.nChildFields;
            this.nFieldsRight = 0;
            this.childBitmap = ImmutableBitSet.range(this.nChildFields);
            this.rightBitmap = null;
            this.nSysFields = 0;
            this.strongBitmap = ImmutableBitSet.of();
        }
        assert (this.nChildFields == this.nSysFields + this.nFields + this.nFieldsRight);
        this.childPreserveExprs = new ArrayList<RexNode>();
        this.rightPreserveExprs = new ArrayList<RexNode>();
        this.rexBuilder = childRel.getCluster().getRexBuilder();
    }

    public RelNode convertProject(RexNode defaultExpr) {
        RelNode projChild;
        this.locateAllRefs();
        if (this.origProj == null) {
            if (this.childPreserveExprs.size() == 0) {
                return null;
            }
            if (this.nChildFields > 0) {
                this.projRefs.set(0, this.nChildFields);
            }
            this.nProject = this.nChildFields;
        } else if (this.projRefs.cardinality() == this.nChildFields && this.childPreserveExprs.size() == 0) {
            return null;
        }
        if (this.projRefs.cardinality() == 0 && this.childPreserveExprs.size() == 0) {
            if (defaultExpr != null) {
                this.childPreserveExprs.add(defaultExpr);
            } else {
                if (this.nChildFields == 1) {
                    return null;
                }
                this.projRefs.set(0);
                this.nProject = 1;
            }
        }
        Project newProject = this.createProjectRefsAndExprs(this.childRel, false, false);
        int[] adjustments = this.getAdjustments();
        if (this.origFilter != null) {
            RexNode newFilter = this.convertRefsAndExprs(this.origFilter, newProject.getRowType().getFieldList(), adjustments);
            this.relBuilder.push(newProject);
            this.relBuilder.filter(newFilter);
            projChild = this.relBuilder.build();
        } else {
            projChild = newProject;
        }
        return this.createNewProject(projChild, adjustments);
    }

    public boolean locateAllRefs() {
        boolean allFieldsReferenced;
        RexUtil.apply((RexVisitor<Void>)new InputSpecialOpFinder(this.projRefs, this.childBitmap, this.rightBitmap, this.strongBitmap, this.preserveExprCondition, this.childPreserveExprs, this.rightPreserveExprs), this.origProjExprs, this.origFilter);
        this.projRefs.set(this.nSysFields, this.nSysFields + this.nSysFields, true);
        this.projRefs.set(this.nSysFields + this.nFields, this.nSysFields + this.nFields + this.nSysFields, true);
        this.nSystemProject = 0;
        this.nProject = 0;
        this.nRightProject = 0;
        for (int bit : BitSets.toIter(this.projRefs)) {
            if (bit < this.nSysFields) {
                ++this.nSystemProject;
                continue;
            }
            if (bit < this.nSysFields + this.nFields) {
                ++this.nProject;
                continue;
            }
            ++this.nRightProject;
        }
        assert (this.nSystemProject + this.nProject + this.nRightProject == this.projRefs.cardinality());
        if (this.childRel instanceof Join || this.childRel instanceof SetOp) {
            if (this.nProject == 0 && this.childPreserveExprs.size() == 0) {
                this.projRefs.set(0);
                this.nProject = 1;
            }
            if (this.childRel instanceof Join && this.nRightProject == 0 && this.rightPreserveExprs.size() == 0) {
                this.projRefs.set(this.nFields);
                this.nRightProject = 1;
            }
        }
        return (allFieldsReferenced = IntStream.range(0, this.nChildFields).allMatch(i -> this.projRefs.get(i))) && this.childPreserveExprs.size() == 0 && this.rightPreserveExprs.size() == 0;
    }

    public Project createProjectRefsAndExprs(RelNode projChild, boolean adjust, boolean rightSide) {
        int offset;
        int nInputRefs;
        List<RexNode> preserveExprs;
        if (rightSide) {
            preserveExprs = this.rightPreserveExprs;
            nInputRefs = this.nRightProject;
            offset = this.nSysFields + this.nFields;
        } else {
            preserveExprs = this.childPreserveExprs;
            nInputRefs = this.nProject;
            offset = this.nSysFields;
        }
        int refIdx = offset - 1;
        ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> destFields = projChild.getRowType().getFieldList();
        for (int i = 0; i < nInputRefs; ++i) {
            refIdx = this.projRefs.nextSetBit(refIdx + 1);
            assert (refIdx >= 0);
            RelDataTypeField destField = destFields.get(refIdx - offset);
            newProjects.add(Pair.of(this.rexBuilder.makeInputRef(destField.getType(), refIdx - offset), destField.getName()));
        }
        int[] adjustments = new int[]{};
        if (preserveExprs.size() > 0 && adjust) {
            adjustments = new int[this.childFields.size()];
            for (int idx = offset; idx < this.childFields.size(); ++idx) {
                adjustments[idx] = -offset;
            }
        }
        for (RexNode projExpr : preserveExprs) {
            RexNode newExpr = adjust ? projExpr.accept(new RelOptUtil.RexInputConverter(this.rexBuilder, this.childFields, destFields, adjustments)) : projExpr;
            List<RelDataType> typeList = projChild.getRowType().getFieldList().stream().map(field -> field.getType()).collect(Collectors.toList());
            RexUtil.FixNullabilityShuttle fixer = new RexUtil.FixNullabilityShuttle(projChild.getCluster().getRexBuilder(), typeList);
            newExpr = newExpr.accept(fixer);
            newProjects.add(Pair.of(newExpr, ((RexCall)projExpr).getOperator().getName()));
        }
        return (Project)this.relBuilder.push(projChild).projectNamed(Pair.left(newProjects), Pair.right(newProjects), true).build();
    }

    public int[] getAdjustments() {
        int[] adjustments = new int[this.nChildFields];
        int newIdx = 0;
        int rightOffset = this.childPreserveExprs.size();
        for (int pos : BitSets.toIter(this.projRefs)) {
            adjustments[pos] = -(pos - newIdx);
            if (pos >= this.nSysFields + this.nFields) {
                int n = pos;
                adjustments[n] = adjustments[n] + rightOffset;
            }
            ++newIdx;
        }
        return adjustments;
    }

    public RexNode convertRefsAndExprs(RexNode rex, List<RelDataTypeField> destFields, int[] adjustments) {
        return rex.accept(new RefAndExprConverter(this.rexBuilder, this.childFields, destFields, adjustments, this.childPreserveExprs, this.nProject, this.rightPreserveExprs, this.nProject + this.childPreserveExprs.size() + this.nRightProject));
    }

    public RelNode createNewProject(RelNode projChild, int[] adjustments) {
        ArrayList<Pair<RexNode, Object>> projects = new ArrayList<Pair<RexNode, Object>>();
        if (this.origProj != null) {
            for (Pair<RexNode, String> p : this.origProj.getNamedProjects()) {
                projects.add(Pair.of(this.convertRefsAndExprs((RexNode)p.left, projChild.getRowType().getFieldList(), adjustments), p.right));
            }
        } else {
            for (Ord<RelDataTypeField> field : Ord.zip(this.childFields)) {
                projects.add(Pair.of(this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
            }
        }
        return this.relBuilder.push(projChild).project(Pair.left(projects), Pair.right(projects)).build();
    }

    class OperatorExprCondition
    implements ExprCondition {
        private final Set<SqlOperator> operatorSet;

        OperatorExprCondition(Iterable<? extends SqlOperator> operatorSet) {
            this.operatorSet = ImmutableSet.copyOf(operatorSet);
        }

        @Override
        public boolean test(RexNode expr) {
            return expr instanceof RexCall && this.operatorSet.contains(((RexCall)expr).getOperator());
        }
    }

    public static interface ExprCondition
    extends Predicate<RexNode> {
        public static final ExprCondition FALSE = expr -> false;
        public static final ExprCondition TRUE = expr -> true;

        @Override
        public boolean test(RexNode var1);
    }

    private class RefAndExprConverter
    extends RelOptUtil.RexInputConverter {
        private final List<RexNode> preserveLeft;
        private final int firstLeftRef;
        private final List<RexNode> preserveRight;
        private final int firstRightRef;

        RefAndExprConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, int[] adjustments, List<RexNode> preserveLeft, int firstLeftRef, List<RexNode> preserveRight, int firstRightRef) {
            super(rexBuilder, srcFields, destFields, adjustments);
            this.preserveLeft = preserveLeft;
            this.firstLeftRef = firstLeftRef;
            this.preserveRight = preserveRight;
            this.firstRightRef = firstRightRef;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            int match = this.findExprInLists(call, this.preserveLeft, this.firstLeftRef, this.preserveRight, this.firstRightRef);
            if (match >= 0) {
                return this.rexBuilder.makeInputRef(((RelDataTypeField)this.destFields.get(match)).getType(), match);
            }
            return super.visitCall(call);
        }

        private int findExprInLists(RexNode rex, List<RexNode> rexList1, int adjust1, List<RexNode> rexList2, int adjust2) {
            int match = rexList1.indexOf(rex);
            if (match >= 0) {
                return match + adjust1;
            }
            if (rexList2 != null && (match = rexList2.indexOf(rex)) >= 0) {
                return match + adjust2;
            }
            return -1;
        }
    }

    private class InputSpecialOpFinder
    extends RexVisitorImpl<Void> {
        private final BitSet rexRefs;
        private final ImmutableBitSet leftFields;
        private final ImmutableBitSet rightFields;
        private final ImmutableBitSet strongFields;
        private final ExprCondition preserveExprCondition;
        private final List<RexNode> preserveLeft;
        private final List<RexNode> preserveRight;
        private final Strong strong;

        InputSpecialOpFinder(BitSet rexRefs, ImmutableBitSet leftFields, ImmutableBitSet rightFields, ImmutableBitSet strongFields, ExprCondition preserveExprCondition, List<RexNode> preserveLeft, List<RexNode> preserveRight) {
            super(true);
            this.rexRefs = rexRefs;
            this.leftFields = leftFields;
            this.rightFields = rightFields;
            this.preserveExprCondition = preserveExprCondition;
            this.preserveLeft = preserveLeft;
            this.preserveRight = preserveRight;
            this.strongFields = strongFields;
            this.strong = Strong.of(strongFields);
        }

        @Override
        public Void visitCall(RexCall call) {
            if (this.preserve(call)) {
                return null;
            }
            super.visitCall(call);
            return null;
        }

        private boolean isStrong(ImmutableBitSet exprArgs, RexNode call) {
            return !this.strongFields.intersects(exprArgs) || this.strong.isNull(call);
        }

        private boolean preserve(RexNode call) {
            ImmutableBitSet exprArgs;
            if (this.preserveExprCondition.test(call) && (exprArgs = RelOptUtil.InputFinder.bits(call)).cardinality() > 0) {
                if (this.leftFields.contains(exprArgs) && this.isStrong(exprArgs, call)) {
                    if (!this.preserveLeft.contains(call)) {
                        this.preserveLeft.add(call);
                    }
                    return true;
                }
                if (this.rightFields.contains(exprArgs) && this.isStrong(exprArgs, call)) {
                    assert (this.preserveRight != null);
                    if (!this.preserveRight.contains(call)) {
                        this.preserveRight.add(call);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.rexRefs.set(inputRef.getIndex());
            return null;
        }
    }
}

