/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;

public class SqlHopTableFunction
extends SqlWindowTableFunction {
    public SqlHopTableFunction() {
        super(SqlKind.HOP.name());
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(4, 5);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType type4;
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        SqlNode operand1 = callBinding.operand(1);
        if (operand1.getKind() != SqlKind.DESCRIPTOR) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand1).getOperandList());
        RelDataType type2 = validator.getValidatedNodeType(callBinding.operand(2));
        if (!SqlTypeUtil.isInterval(type2)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        RelDataType type3 = validator.getValidatedNodeType(callBinding.operand(3));
        if (!SqlTypeUtil.isInterval(type3)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        if (callBinding.getOperandCount() > 4 && !SqlTypeUtil.isInterval(type4 = validator.getValidatedNodeType(callBinding.operand(4)))) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col), datetime interval, datetime interval[, datetime interval])";
    }
}

