/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIResultSet;
import ai.heavy.jdbc.HeavyAIType;
import ai.heavy.thrift.server.TColumn;
import ai.heavy.thrift.server.TColumnData;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDatumType;
import ai.heavy.thrift.server.TEncodingType;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TQueryType;
import ai.heavy.thrift.server.TRowSet;
import ai.heavy.thrift.server.TTypeInfo;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class HeavyAIArray
implements Array {
    private TDatumType type;
    private Object[] elements;

    public HeavyAIArray(TDatumType type, Object[] elements) throws SQLException {
        if (elements == null) {
            throw new SQLException("Elements[] cannot be null");
        }
        this.type = type;
        this.elements = elements;
        Class<?> elements_class = elements.getClass().getComponentType();
        switch (type) {
            case TINYINT: {
                this.checkClass(elements_class, Byte.class);
                break;
            }
            case SMALLINT: {
                this.checkClass(elements_class, Short.class);
                break;
            }
            case INT: {
                this.checkClass(elements_class, Integer.class);
                break;
            }
            case BIGINT: {
                this.checkClass(elements_class, Long.class);
                break;
            }
            case BOOL: {
                this.checkClass(elements_class, Boolean.class);
                break;
            }
            case TIME: {
                this.checkClass(elements_class, Time.class);
                break;
            }
            case TIMESTAMP: {
                this.checkClass(elements_class, Timestamp.class);
                break;
            }
            case DATE: {
                this.checkClass(elements_class, Date.class);
                break;
            }
            case FLOAT: {
                this.checkClass(elements_class, Float.class);
                break;
            }
            case DECIMAL: {
                this.checkClass(elements_class, BigDecimal.class);
                break;
            }
            case DOUBLE: {
                this.checkClass(elements_class, Double.class);
                break;
            }
            case STR: 
            case POINT: 
            case MULTIPOINT: 
            case LINESTRING: 
            case MULTILINESTRING: 
            case POLYGON: 
            case MULTIPOLYGON: {
                this.checkClass(elements_class, String.class);
                break;
            }
            default: {
                throw new AssertionError((Object)type.toString());
            }
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.type.name();
    }

    @Override
    public int getBaseType() throws SQLException {
        return HeavyAIType.toJava(this.type);
    }

    @Override
    public Object getArray() throws SQLException {
        return this.elements;
    }

    @Override
    public Object getArray(long start, int size) throws SQLException {
        this.checkSize(Math.toIntExact(start), size);
        return Arrays.copyOfRange(this.elements, Math.toIntExact(start), size);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(0L, this.elements.length);
    }

    @Override
    public ResultSet getResultSet(long start, int size) throws SQLException {
        this.checkSize(Math.toIntExact(start), size);
        ArrayList<TColumnType> columnTypes = new ArrayList<TColumnType>(2);
        TTypeInfo idxType = new TTypeInfo(TDatumType.BIGINT, TEncodingType.NONE, false, false, 0, 0, 0);
        columnTypes.add(new TColumnType("INDEX", idxType, false, "", false, false, 0L));
        int precision = this.type == TDatumType.TIMESTAMP || this.type == TDatumType.TIME || this.type == TDatumType.DATE ? 3 : 0;
        TTypeInfo valueType = new TTypeInfo(this.type, TEncodingType.NONE, true, false, precision, 0, 0);
        columnTypes.add(new TColumnType("VALUE", valueType, false, "", false, false, 1L));
        Long[] indexes = new Long[size];
        for (int i = 0; i < size; ++i) {
            indexes[i] = i + 1;
        }
        TColumnData idxData = new TColumnData(Arrays.asList(indexes), null, null, null);
        ArrayList<Boolean> idxNulls = new ArrayList<Boolean>(size);
        for (int i = 0; i < size; ++i) {
            idxNulls.add(Boolean.FALSE);
        }
        Long[] int_values = new Long[size];
        Double[] real_values = new Double[size];
        String[] string_values = new String[size];
        boolean is_real = false;
        boolean is_string = false;
        ArrayList<Boolean> valueNulls = new ArrayList<Boolean>(size);
        int i = Math.toIntExact(start);
        while ((long)i < start + (long)size) {
            if (this.elements[i] == null) {
                valueNulls.add(true);
            } else {
                valueNulls.add(false);
                switch (this.type) {
                    case TINYINT: {
                        int_values[i] = ((Byte)this.elements[i]).longValue();
                        break;
                    }
                    case SMALLINT: {
                        int_values[i] = ((Short)this.elements[i]).longValue();
                        break;
                    }
                    case INT: {
                        int_values[i] = ((Integer)this.elements[i]).longValue();
                        break;
                    }
                    case BIGINT: {
                        int_values[i] = (Long)this.elements[i];
                        break;
                    }
                    case BOOL: {
                        int_values[i] = this.elements[i] == Boolean.TRUE ? 1L : 0L;
                        break;
                    }
                    case TIME: {
                        int_values[i] = ((Time)this.elements[i]).getTime();
                        break;
                    }
                    case TIMESTAMP: {
                        int_values[i] = ((Timestamp)this.elements[i]).getTime();
                        break;
                    }
                    case DATE: {
                        int_values[i] = ((java.util.Date)this.elements[i]).getTime();
                        break;
                    }
                    case FLOAT: {
                        is_real = true;
                        real_values[i] = ((Float)this.elements[i]).doubleValue();
                        break;
                    }
                    case DECIMAL: {
                        is_real = true;
                        real_values[i] = ((BigDecimal)this.elements[i]).doubleValue();
                        break;
                    }
                    case DOUBLE: {
                        is_real = true;
                        real_values[i] = (Double)this.elements[i];
                        break;
                    }
                    case STR: 
                    case POINT: 
                    case MULTIPOINT: 
                    case LINESTRING: 
                    case MULTILINESTRING: 
                    case POLYGON: 
                    case MULTIPOLYGON: {
                        is_string = true;
                        string_values[i] = (String)this.elements[i];
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)this.type.toString());
                    }
                }
            }
            ++i;
        }
        TColumnData valuesData = is_real ? new TColumnData(null, Arrays.asList(real_values), null, null) : (is_string ? new TColumnData(null, null, Arrays.asList(string_values), null) : new TColumnData(Arrays.asList(int_values), null, null, null));
        ArrayList<TColumn> columns = new ArrayList<TColumn>(2);
        columns.add(new TColumn(idxData, idxNulls));
        columns.add(new TColumn(valuesData, valueNulls));
        TRowSet rowSet = new TRowSet(columnTypes, null, columns, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, "", "", true, TQueryType.READ);
        return new HeavyAIResultSet(result, "");
    }

    @Override
    public void free() throws SQLException {
        this.elements = null;
    }

    public String toString() {
        if (this.elements == null) {
            return "NULL";
        }
        switch (this.type) {
            case TIME: 
            case TIMESTAMP: 
            case DATE: 
            case STR: 
            case POINT: 
            case MULTIPOINT: 
            case LINESTRING: 
            case MULTILINESTRING: 
            case POLYGON: 
            case MULTIPOLYGON: {
                StringBuilder sb = new StringBuilder("{");
                for (Object e : this.elements) {
                    if (e != null) {
                        sb.append("'").append(e.toString()).append("', ");
                        continue;
                    }
                    sb.append("NULL").append(", ");
                }
                if (this.elements.length > 0) {
                    sb.delete(sb.length() - 2, sb.length());
                }
                sb.append("}");
                return sb.toString();
            }
        }
        String arr_str = Arrays.toString(this.elements);
        return "{" + arr_str.substring(1, arr_str.length() - 1) + "}";
    }

    @Override
    public ResultSet getResultSet(long start, int size, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Object getArray(long start, int size, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    private void checkSize(int start, int size) throws SQLException {
        if (start < 0 || start >= this.elements.length || start + size > this.elements.length) {
            throw new SQLException("Array length = " + Integer.toString(this.elements.length) + ", slice start index = " + Integer.toString(start) + ", slice length = " + Integer.toString(size));
        }
    }

    private void checkClass(Class<?> given, Class<?> expected) throws SQLException {
        if (!expected.isAssignableFrom(given)) {
            throw new SQLException("For array of " + this.getBaseTypeName() + ", elements of type " + expected + " are expected. Got " + given + " instead");
        }
    }
}

