/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIConnection;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyAIDriver
implements Driver {
    static int DriverMajorVersion = -1;
    static int DriverMinorVersion = -1;
    static String DriverVersion = "UNKNOWN";
    static final String VERSION_FILE = "version.properties";
    static final Logger logger = LoggerFactory.getLogger(HeavyAIDriver.class);
    public static final String OMNISCI_PREFIX = "jdbc:omnisci:";
    public static final String MAPD_PREFIX = "jdbc:mapd:";
    public static final String HEAVYAI_PREFIX = "jdbc:heavyai:";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!HeavyAIDriver.isValidURL(url)) {
            return null;
        }
        url = url.trim();
        return new HeavyAIConnection(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return HeavyAIDriver.isValidURL(url);
    }

    private static boolean isValidURL(String url) {
        return url != null && (url.toLowerCase().startsWith(OMNISCI_PREFIX) || url.toLowerCase().startsWith(MAPD_PREFIX) || url.toLowerCase().startsWith(HEAVYAI_PREFIX));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public int getMajorVersion() {
        return DriverMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        return DriverMinorVersion;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new HeavyAIDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try (InputStream input = HeavyAIDriver.class.getClassLoader().getResourceAsStream(VERSION_FILE);){
            Properties prop = new Properties();
            if (input == null) {
                logger.error("Cannot read version.properties file");
            } else {
                prop.load(input);
                DriverVersion = prop.getProperty("version");
                String[] version = DriverVersion.split("\\.");
                try {
                    DriverMajorVersion = Integer.parseInt(version[0]);
                    DriverMinorVersion = Integer.parseInt(version[1]);
                }
                catch (NumberFormatException ex) {
                    logger.error("Unexpected driver version format in version.properties");
                    DriverVersion = "UNKNOWN";
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

